/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.machines;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IPickup;
import nmd.primal.core.api.interfaces.types.ITypeNBT;
import nmd.primal.core.api.interfaces.types.ITypeWood;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.AbstractWorkTable;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.tiles.machines.TileWorkTableSlab;

public class WorkTableSlab
extends AbstractWorkTable<TileWorkTableSlab>
implements ITypeWood,
IPickup {
    public static final PropertyEnum<EnumSlab> HALF = PropertyEnum.func_177709_a((String)"half", EnumSlab.class);

    public WorkTableSlab(Material material) {
        super(material);
        this.func_149713_g(1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(HALF, (Comparable)((Object)EnumSlab.BOTTOM)));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileWorkTableSlab();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        tooltip.add(TextFormatting.BLUE + I18n.func_74838_a((String)"tooltip.info.primal.worktable_slab"));
    }

    @Override
    public boolean doPickup(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileWorkTableSlab) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.func_185473_a(world, pos, state));
            this.dropOnlyItems(world, pos, state);
            world.func_175666_e(pos, state.func_177230_c());
            world.func_175656_a(pos, this.getReplacementBlock(world, pos, state));
            world.func_175713_t(pos);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, true);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        return this.doPickup(world, pos, state, EnumFacing.UP, player, player.func_184600_cs());
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (this.hasTileEntity(state)) {
            world.func_175713_t(pos);
        }
    }

    @Override
    public void dropItemsAndBlock(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots && (tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof TileWorkTableSlab) {
            float offset = 0.7f;
            RecipeHelper.dropSlotItems(world, pos, offset, ((TileWorkTableSlab)tile).getCraftingHandler());
            PlayerHelper.spawnItemOnGround(world, pos, this.func_185473_a(world, pos, state));
        }
    }

    public void dropOnlyItems(World world, BlockPos pos, IBlockState state) {
        TileWorkTableSlab tile;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots && (tile = (TileWorkTableSlab)world.func_175625_s(pos)) != null && !tile.func_145837_r()) {
            float offset = 0.7f;
            for (int i = 0; i < tile.getCraftingHandler().getSlots(); ++i) {
                ItemStack stack = tile.getCraftingHandler().getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                double offsetX = (double)(RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
                double offsetY = (double)(RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
                double offsetZ = (double)(RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
                EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + offsetX, (double)pos.func_177956_o() + offsetY, (double)pos.func_177952_p() + offsetZ, stack);
                item.func_174869_p();
                world.func_72838_d((Entity)item);
            }
            world.func_175698_g(pos);
        }
    }

    @Override
    public int getFacingIndexFromMeta(int meta) {
        int modifier = meta < 4 ? 0 : (meta < 8 ? 4 : 8);
        return meta - modifier;
    }

    public boolean isTop(IBlockState state) {
        return state.func_177229_b(HALF) == EnumSlab.TOP;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)PrimalCore.INSTANCE, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.isTop(state) ? PrimalAPI.Bounds.AABB_SLAB_TOP : PrimalAPI.Bounds.AABB_SLAB_BOTTOM;
    }

    public boolean func_185481_k(IBlockState state) {
        return this.isTop(state);
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        if (state.func_185914_p()) {
            return true;
        }
        EnumSlab side = (EnumSlab)((Object)state.func_177229_b(HALF));
        return side == EnumSlab.TOP && face == EnumFacing.UP || side == EnumSlab.BOTTOM && face == EnumFacing.DOWN;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess access, BlockPos pos, EnumFacing side) {
        return this.func_149688_o(state) == Material.field_151592_s || (side == EnumFacing.UP || side == EnumFacing.DOWN || super.func_176225_a(state, access, pos, side)) && super.func_176225_a(state, access, pos, side);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return this.isTop(state) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (ITypeWood.EnumType blocks$enumtype : ITypeWood.EnumType.values()) {
            ItemStack stack = new ItemStack((Block)this, 1, blocks$enumtype.getMetadata());
            NBTHelper.setString(stack, "type", blocks$enumtype.func_176610_l());
            list.add((Object)stack);
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof ITypeNBT) {
            ItemStack stack = new ItemStack((Block)this, 1, ITypeWood.EnumType.byName(((ITypeNBT)tile).getType()).getMetadata());
            NBTHelper.setString(stack, "type", ((ITypeNBT)tile).getType());
            return stack;
        }
        return super.func_185473_a(world, pos, state);
    }

    public Material func_149688_o(IBlockState state) {
        return Material.field_151575_d;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return this.func_185467_w();
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HALF, TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumSlab.byMetadata(meta))).func_177226_a((IProperty)FACING, (Comparable)this.getHorizontalFacingFromIndex(this.getFacingIndexFromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return EnumSlab.getIndex(state) + this.getHorizontalIndexFromState(state);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof ITypeNBT) {
            String type = ((ITypeNBT)tile).getType();
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeWood.EnumType.byName(type)));
        }
        return state;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.getFacingState(placer, this);
        return face != EnumFacing.DOWN && (face == EnumFacing.UP || (double)hitY <= 0.5) ? state.func_177226_a(HALF, (Comparable)((Object)EnumSlab.BOTTOM)) : state.func_177226_a(HALF, (Comparable)((Object)EnumSlab.TOP));
    }

    public static enum EnumSlab implements IStringSerializable
    {
        BOTTOM("bottom"),
        TOP("top");

        private final String name;
        private static int index;

        private EnumSlab(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static int getIndex(IBlockState state) {
            EnumSlab type = (EnumSlab)((Object)state.func_177229_b(HALF));
            return type == TOP ? 4 : 0;
        }

        public static EnumSlab byMetadata(int meta) {
            index = meta > 3 ? 1 : 0;
            return EnumSlab.values()[index];
        }
    }
}

