/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.misc;

import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.common.blocks.AbstractFace;
import nmd.primal.core.common.blocks.misc.WattleDaubHelper;
import nmd.primal.core.common.helper.RecipeHelper;

public class Wattle
extends AbstractFace {
    private WattleDaubHelper.EnumWattle wattle;

    public Wattle(WattleDaubHelper.EnumWattle wattle_type, Material material, MapColor map_color) {
        super(material, map_color);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149713_g(1);
        this.wattle = wattle_type;
    }

    public Wattle(WattleDaubHelper.EnumWattle wattle_type) {
        this(wattle_type, Material.field_151575_d, MapColor.field_151663_o);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        String name;
        ItemStack stack;
        if (!world.field_72995_K && !(stack = player.func_184586_b(hand)).func_190926_b() && RecipeHelper.isOreName(stack, WattleDaubHelper.getDaubNames()) && (name = WattleDaubHelper.getDaubNameFromStack(stack)) != null) {
            world.func_180501_a(pos, WattleDaubHelper.EnumDaub.getTypeByDaubName(this.wattle, name).func_177226_a((IProperty)IFace.FACING, state.func_177229_b((IProperty)IFace.FACING)), 3);
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: 
            case SOUTH: {
                return PrimalAPI.Bounds.AABB_WATTLE_NORTH;
            }
        }
        return PrimalAPI.Bounds.AABB_WATTLE_EAST;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }
}

