/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.ores;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.ores.AbstractOre;
import nmd.primal.core.common.helper.RegistryHelper;

public class SaltOre
extends AbstractOre {
    public static final PropertyEnum<Type> TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);

    public SaltOre() {
        super(Material.field_151592_s, SoundType.field_185853_f, "pickaxe", 1);
        this.func_149711_c(3.0f);
        this.func_149752_b(3.0f);
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return true;
    }

    @Override
    public void registerDictionaryNames() {
        for (String string : this.getDictionaryNames()) {
            RegistryHelper.registerDictionaryNames(new ItemStack((Block)this, 1, Short.MAX_VALUE), string);
        }
        for (Type type : Type.values()) {
            for (String name : type.getOreNames()) {
                RegistryHelper.registerDictionaryNames(new ItemStack((Block)this, 1, type.getMetadata()), name);
            }
        }
    }

    @Override
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        switch ((Type)((Object)state.func_177229_b(TYPE))) {
            case ROCK: {
                return PrimalAPI.Items.SALT_DUST_ROCK;
            }
            case FIRE: {
                return PrimalAPI.Items.SALT_DUST_FIRE;
            }
            case VOID: {
                return PrimalAPI.Items.SALT_DUST_VOID;
            }
        }
        return null;
    }

    @Override
    public int func_149745_a(Random random) {
        return RANDOM.nextInt(2, 6);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (Type blocks$enumtype : Type.values()) {
            list.add((Object)new ItemStack((Block)this, 1, blocks$enumtype.getMetadata()));
        }
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        switch ((Type)((Object)state.func_177229_b(TYPE))) {
            case ROCK: {
                return MapColor.field_193567_S;
            }
            case FIRE: {
                return MapColor.field_193562_N;
            }
            case VOID: {
                return MapColor.field_193571_W;
            }
        }
        return this.field_149764_J.func_151565_r();
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177229_b(TYPE) == Type.FIRE ? 8 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        if (world.func_175727_C(pos.func_177984_a()) && !world.func_180495_p(pos.func_177977_b()).func_185896_q() && PrimalAPI.randomCheck(15)) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.DRIP_WATER, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        PrimalAPI.logger(3, "getStateForPlacement", "meta: " + meta);
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Type.byMetadata(placer != null ? placer.func_184586_b(hand).func_77952_i() : meta)));
    }

    public static enum Type implements IStringSerializable
    {
        ROCK("rock", "blockSaltRock"),
        FIRE("fire", "blockSaltFire"),
        VOID("void", "blockSaltVoid");

        private static final Type[] META_LOOKUP;
        private final String name;
        private final String[] oreNames;

        private Type(String name, String ... oreNames) {
            this.name = name;
            this.oreNames = oreNames;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMetadata() {
            return this.ordinal();
        }

        public String[] getOreNames() {
            return this.oreNames;
        }

        public static Type byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type blocks$enumtype;
                Type.META_LOOKUP[blocks$enumtype.getMetadata()] = blocks$enumtype = typeArray[i];
            }
        }
    }
}

