/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.parts;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.api.interfaces.IPickup;
import nmd.primal.core.common.blocks.AbstractFace;
import nmd.primal.core.common.helper.PlayerHelper;

public class Ladder
extends AbstractFace
implements IPickup {
    private boolean flammable;

    public Ladder(Material material, boolean flammable) {
        super(material);
        this.func_149672_a(SoundType.field_185857_j);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)IFace.FACING, (Comparable)EnumFacing.NORTH));
        this.func_149713_g(0);
        this.flammable = flammable;
    }

    public Ladder(boolean flammable) {
        this(Material.field_151575_d, flammable);
    }

    public Ladder() {
        this(Material.field_151575_d, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.ladder_placement"));
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammable;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammable ? 5 : 0;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammable ? 20 : 0;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return PrimalAPI.Bounds.AABB_LADDER_NORTH;
            }
            case SOUTH: {
                return PrimalAPI.Bounds.AABB_LADDER_SOUTH;
            }
            case WEST: {
                return PrimalAPI.Bounds.AABB_LADDER_WEST;
            }
        }
        return PrimalAPI.Bounds.AABB_LADDER_EAST;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        Block place_ladder;
        super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
        if (world.field_72995_K) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && (place_ladder = Block.func_149634_a((Item)stack.func_77973_b())) instanceof Ladder) {
            while (world.func_180495_p(pos).func_177230_c() instanceof Ladder) {
                BlockPos placePos = (double)hitY > 0.5 ? pos.func_177984_a() : pos.func_177977_b();
                IBlockState placeState = place_ladder.func_176223_P().func_177226_a((IProperty)IFace.FACING, state.func_177229_b((IProperty)IFace.FACING));
                IBlockState checkState = world.func_180495_p(placePos);
                if (checkState.func_177230_c() instanceof Ladder) {
                    pos = placePos;
                    continue;
                }
                if (!checkState.func_177230_c().func_176200_f((IBlockAccess)world, placePos) || world.func_189509_E(placePos)) break;
                world.func_180501_a(placePos, placeState, 2);
                world.func_184148_a(null, (double)placePos.func_177958_n(), (double)placePos.func_177956_o(), (double)placePos.func_177952_p(), Blocks.field_150468_ap.func_185467_w().func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                PlayerHelper.useStack(player, hand, stack);
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (face.func_176740_k().func_176722_c() && this.canBlockStay(world, pos, face)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face);
        }
        if (face.func_176740_k().func_176720_b() && this.canBlockStay(world, pos, face)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canBlockStay(world, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (!this.canBlockStay(world, pos, enumfacing)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
        super.func_189540_a(state, world, pos, block, fromPos);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177976_e()).isSideSolid((IBlockAccess)world, pos.func_177976_e(), EnumFacing.EAST) || world.func_180495_p(pos.func_177974_f()).isSideSolid((IBlockAccess)world, pos.func_177974_f(), EnumFacing.WEST) || world.func_180495_p(pos.func_177978_c()).isSideSolid((IBlockAccess)world, pos.func_177978_c(), EnumFacing.SOUTH) || world.func_180495_p(pos.func_177968_d()).isSideSolid((IBlockAccess)world, pos.func_177968_d(), EnumFacing.NORTH) || world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177976_e(), EnumFacing.UP) || world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof Ladder || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof Ladder;
    }

    protected boolean canBlockStay(World world, BlockPos pos, EnumFacing facing) {
        return world.func_180495_p(pos.func_177972_a(facing.func_176734_d())).isSideSolid((IBlockAccess)world, pos.func_177972_a(facing.func_176734_d()), facing) || world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177976_e(), EnumFacing.UP) || world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof Ladder || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof Ladder;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

