/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.parts;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.AbstractSubBlock;

public class SlabHalf
extends AbstractSubBlock {
    public static final PropertyEnum<EnumSlab> HALF = PropertyEnum.func_177709_a((String)"half", EnumSlab.class);

    public SlabHalf(IBlockState state, int opacity, boolean facing) {
        super(state);
        this.func_149713_g(opacity);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(HALF, (Comparable)((Object)EnumSlab.BOTTOM)));
    }

    public SlabHalf(IBlockState state, int opacity) {
        this(state, opacity, false);
    }

    public SlabHalf(IBlockState state, boolean facing) {
        this(state, 8, facing);
    }

    public SlabHalf(IBlockState state) {
        this(state, 8, false);
    }

    public boolean isFull(IBlockState state) {
        return false;
    }

    public boolean isTop(IBlockState state) {
        return state.func_177229_b(HALF) == EnumSlab.TOP;
    }

    public boolean isBottom(IBlockState state) {
        return state.func_177229_b(HALF) == EnumSlab.BOTTOM;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.isTop(state) ? PrimalAPI.Bounds.AABB_SLAB_TOP : PrimalAPI.Bounds.AABB_SLAB_BOTTOM;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        if (facing == EnumFacing.UP && this.isTop(state)) {
            return BlockFaceShape.SOLID;
        }
        return facing == EnumFacing.DOWN && this.isBottom(state) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return this.isTop(state);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.getParentMaterial() == Material.field_151592_s) {
            return false;
        }
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        EnumSlab side = (EnumSlab)((Object)state.func_177229_b(HALF));
        return side == EnumSlab.TOP && face == EnumFacing.UP || side == EnumSlab.BOTTOM && face == EnumFacing.DOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.field_149764_J == Material.field_151592_s) {
            IBlockState neighbor_state = world.func_180495_p(pos.func_177972_a(side));
            return state != neighbor_state;
        }
        if (this.isFull(state)) {
            return super.func_176225_a(state, world, pos, side);
        }
        if (side != EnumFacing.UP && side != EnumFacing.DOWN && !super.func_176225_a(state, world, pos, side)) {
            return false;
        }
        return super.func_176225_a(state, world, pos, side);
    }

    @Override
    protected boolean func_149700_E() {
        return false;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176223_P();
        return face != EnumFacing.DOWN && (face == EnumFacing.UP || (double)hitY <= 0.5) ? state.func_177226_a(HALF, (Comparable)((Object)EnumSlab.BOTTOM)) : state.func_177226_a(HALF, (Comparable)((Object)EnumSlab.TOP));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumSlab.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumSlab)((Object)state.func_177229_b(HALF))).getMetadata();
    }

    public int getFacingIndexFromMeta(int meta) {
        int modifier = meta < 4 ? 0 : (meta < 8 ? 4 : 8);
        return meta - modifier;
    }

    public static enum EnumSlab implements IStringSerializable
    {
        BOTTOM(0, "bottom"),
        TOP(1, "top");

        private static final EnumSlab[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumSlab(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public static EnumSlab byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumSlab[EnumSlab.values().length];
            EnumSlab[] enumSlabArray = EnumSlab.values();
            int n = enumSlabArray.length;
            for (int i = 0; i < n; ++i) {
                EnumSlab blocks$enumtype;
                EnumSlab.META_LOOKUP[blocks$enumtype.getMetadata()] = blocks$enumtype = enumSlabArray[i];
            }
        }
    }
}

