/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.parts;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.common.blocks.parts.SlabHalf;
import nmd.primal.core.common.blocks.parts.ThinSlab;

public class TrapDoor
extends ThinSlab
implements IFace {
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");

    public TrapDoor(IBlockState state) {
        super(state, 0, true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)IFace.FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)HALF, (Comparable)((Object)SlabHalf.EnumSlab.BOTTOM)));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB axisalignedbb;
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            switch ((EnumFacing)state.func_177229_b((IProperty)IFace.FACING)) {
                default: {
                    axisalignedbb = PrimalAPI.Bounds.AABB_THIN_SLAB_NORTH;
                    break;
                }
                case SOUTH: {
                    axisalignedbb = PrimalAPI.Bounds.AABB_THIN_SLAB_SOUTH;
                    break;
                }
                case WEST: {
                    axisalignedbb = PrimalAPI.Bounds.AABB_THIN_SLAB_WEST;
                    break;
                }
                case EAST: {
                    axisalignedbb = PrimalAPI.Bounds.AABB_THIN_SLAB_EAST;
                    break;
                }
            }
        } else {
            axisalignedbb = state.func_177229_b((IProperty)HALF) == SlabHalf.EnumSlab.TOP ? PrimalAPI.Bounds.AABB_THIN_SLAB_TOP : PrimalAPI.Bounds.AABB_THIN_SLAB_BOTTOM;
        }
        return axisalignedbb;
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.TRAPDOOR;
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState iblockstate = this.func_176223_P();
        if (face.func_176740_k().func_176722_c()) {
            iblockstate = iblockstate.func_177226_a((IProperty)IFace.FACING, (Comparable)face).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
            iblockstate = iblockstate.func_177226_a((IProperty)HALF, (Comparable)((Object)(hitY > 0.5f ? SlabHalf.EnumSlab.TOP : SlabHalf.EnumSlab.BOTTOM)));
        } else {
            iblockstate = iblockstate.func_177226_a((IProperty)IFace.FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
            iblockstate = iblockstate.func_177226_a((IProperty)HALF, (Comparable)((Object)(face == EnumFacing.UP ? SlabHalf.EnumSlab.BOTTOM : SlabHalf.EnumSlab.TOP)));
        }
        if (world.func_175640_z(pos)) {
            iblockstate = iblockstate.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true));
        }
        return iblockstate;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (this.field_149764_J == Material.field_151573_f) {
            return true;
        }
        state = state.func_177231_a((IProperty)OPEN);
        world.func_180501_a(pos, state, 2);
        this.playSound(player, world, pos, (Boolean)state.func_177229_b((IProperty)OPEN));
        return true;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return (Boolean)state.func_177229_b((IProperty)OPEN);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        boolean flag1;
        boolean flag;
        if (!world.field_72995_K && ((flag = world.func_175640_z(pos)) || block.func_176223_P().func_185897_m()) && (flag1 = ((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) != flag) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
            this.playSound(null, world, pos, flag);
        }
    }

    protected void playSound(@Nullable EntityPlayer player, World world, BlockPos pos, boolean p_185731_4_) {
        if (p_185731_4_) {
            int i = this.field_149764_J == Material.field_151573_f ? 1037 : 1007;
            world.func_180498_a(player, i, pos, 0);
        } else {
            int j = this.field_149764_J == Material.field_151573_f ? 1036 : 1013;
            world.func_180498_a(player, j, pos, 0);
        }
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IFace.FACING, SlabHalf.HALF, PrimalAPI.States.OPEN});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IFace.FACING, (Comparable)this.getFacing(meta)).func_177226_a((IProperty)PrimalAPI.States.OPEN, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a(SlabHalf.HALF, (Comparable)((Object)((meta & 8) == 0 ? SlabHalf.EnumSlab.BOTTOM : SlabHalf.EnumSlab.TOP)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= this.getMetaForFacing((EnumFacing)state.func_177229_b((IProperty)IFace.FACING));
        if (((Boolean)state.func_177229_b((IProperty)PrimalAPI.States.OPEN)).booleanValue()) {
            i |= 4;
        }
        if (state.func_177229_b((IProperty)HALF) == SlabHalf.EnumSlab.TOP) {
            i |= 8;
        }
        return i;
    }
}

