/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.crops;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IInflictedDamage;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.plants.IHarvest;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.blocks.plants.AbstractPlantGrowing;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.DamageHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.init.ModConfig;

public class DaucusMurn
extends AbstractPlantGrowing
implements IHarvest,
ISchedule,
IInflictedDamage {
    @Override
    public boolean shouldDamage(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this && this.isMature(state) && this.isBlooming(state);
    }

    @Override
    public DamageSource getSource(World world, BlockPos pos) {
        return DamageHelper.DAUCUS;
    }

    @Override
    public float getDamage(World world, BlockPos pos) {
        return 1.0f;
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return !this.isBlooming(state) && !CommonUtils.isValueMatch(this.getAge(state), 5);
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return true;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt(ModConfig.Plants.PLANT_BASE_TICK_RATE / 2, ModConfig.Plants.PLANT_BASE_TICK_RATE);
    }

    @Override
    public IPrimalPlants.EnumType getType(IBlockState state) {
        return IPrimalPlants.EnumType.NETHER;
    }

    @Override
    public ItemStack getStalk(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.DAUCUS_MURN_FRONDS);
    }

    @Override
    public ItemStack getSeed(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.DAUCUS_MURN_SEEDS);
    }

    @Override
    public ItemStack getCrop(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.DAUCUS_MURN_ROOT);
    }

    @Override
    public int getMaxHeight() {
        return 2;
    }

    @Override
    public boolean isMature(IBlockState state) {
        return CommonUtils.isValueMatch(this.getAge(state), 5, 7);
    }

    @Override
    public void growFullPlant(World world, BlockPos pos, IBlockState state, int update_flag) {
        super.growFullPlant(world, pos, state, update_flag);
        if (this.isValidSoil((IBlockAccess)world, pos.func_177977_b())) {
            world.func_180501_a(pos, this.getAgedPlant(state, 5), update_flag);
            world.func_180501_a(pos.func_177984_a(), this.getBloomingPlant(state, 7, world.field_73012_v.nextBoolean()), update_flag);
        }
    }

    @Override
    public float getGrowChance(World world, BlockPos pos, IBlockState state) {
        return super.getGrowChance(world, pos, state);
    }

    @Override
    public float getBloomChance(World world, BlockPos pos, IBlockState state) {
        return 0.35f;
    }

    @Override
    public boolean canBloom(World world, BlockPos pos, IBlockState state) {
        return !this.isBlooming(state) && CommonUtils.isValueMatch(this.getAge(state), 7);
    }

    @Override
    public int harvestAmount() {
        return RANDOM.nextInt(1, 3);
    }

    @Override
    public boolean canHarvest(IBlockState state) {
        int age = this.getAge(state);
        return age == 4 || age == 5 || age == 7 && this.isBlooming(state);
    }

    @Override
    public boolean harvestPlant(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityPlayer player, EnumHand hand, int amount) {
        IBlockState harvested_state = state.func_177231_a((IProperty)PLANT_BLOOM);
        int age = this.getAge(state);
        if (age == 7 && this.isBlooming(state) && PrimalAPI.placeScheduledBlock(world, pos, harvested_state, 2)) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(this.getStalk(state).func_77973_b()));
            return true;
        }
        return (age == 4 || age == 5) && world.func_175655_b(pos, true);
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase && !PlayerHelper.isNetherEntity(entity)) {
            int age = this.getAge(state);
            if (age > 3) {
                entity.field_70159_w *= 0.6;
                entity.field_70179_y *= 0.6;
            }
            if (age == 7 && this.isBlooming(state)) {
                entity.func_70110_aj();
                entity.func_70097_a((DamageSource)DamageHelper.DAUCUS, 1.0f);
            }
        }
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getAge(state) == 7 && this.isBlooming(state) ? PathNodeType.DAMAGE_CACTUS : PathNodeType.DANGER_CACTUS;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            float extra_seeds = 0.25f;
            int age = this.getAge(state);
            if (age == 7 && this.isBlooming(state)) {
                DaucusMurn.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getStalk(state));
                if (PrimalAPI.randomCheck(extra_seeds)) {
                    DaucusMurn.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getSeed(state));
                }
            }
            if (age == 4 || age == 5) {
                for (int i = 0; i < RANDOM.nextInt(1, 4); ++i) {
                    DaucusMurn.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getCrop(state));
                }
            }
        }
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState soil = this.getSoil((IBlockAccess)world, pos);
        if (state.func_177230_c() == this && this.getAge(state) < 4) {
            return this.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
        }
        return this.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant_state = plantable.getPlant(world, pos.func_177972_a(direction));
        Block soil = state.func_177230_c();
        if (plantable == this) {
            int age = this.getAge(plant_state);
            if (age > 3) {
                return soil == this || this.isValidSoil(world, pos);
            }
            return PrimalAPI.Predicates.SOIL_NETHER_FARMING.apply((Object)state);
        }
        return super.canSustainPlant(state, world, pos.func_177977_b(), direction, plantable);
    }

    @Override
    public boolean isValidSoil(IBlockAccess world, BlockPos pos) {
        return PrimalAPI.Predicates.SOIL_NETHER_COMMON.apply((Object)world.func_180495_p(pos));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getAge(state) == 0 ? PrimalAPI.Bounds.AABB_FLAT_PLANT : PrimalAPI.Bounds.AABB_BUSH;
    }
}

