/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.crops;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.plants.IPerennial;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.blocks.plants.AbstractPlantGrowing;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;
import nmd.primal.core.common.init.ModConfig;

public class SinuousWeed
extends AbstractPlantGrowing
implements IShearable,
IPerennial,
ISchedule {
    private int range = 3;

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return !this.isBlooming(state);
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return true;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt(ModConfig.Plants.PLANT_BASE_TICK_RATE / 2, ModConfig.Plants.PLANT_BASE_TICK_RATE);
    }

    @Override
    public IBlockState getNewPlant() {
        return this.func_176223_P();
    }

    @Override
    public boolean canNewGrow(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public IPrimalPlants.EnumType getType(IBlockState state) {
        return IPrimalPlants.EnumType.NETHER;
    }

    @Override
    public ItemStack getStalk(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.SINUOUS_FIBER);
    }

    @Override
    public ItemStack getSeed(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.SINUOUS_SPORE);
    }

    @Override
    public ItemStack getCrop(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.SINUOUS_FIBER);
    }

    @Override
    public int getMaxHeight() {
        return 3;
    }

    @Override
    public boolean isMature(IBlockState state) {
        return CommonUtils.isValueMatch(this.getAge(state), 3, 4);
    }

    @Override
    public void growFullPlant(World world, BlockPos pos, IBlockState state, int update_flag) {
        super.growFullPlant(world, pos, state, update_flag);
        if (this.isValidSoil((IBlockAccess)world, pos.func_177977_b())) {
            world.func_180501_a(pos, this.getBloomingPlant(state, 3, world.field_73012_v.nextBoolean()), update_flag);
            world.func_180501_a(pos.func_177984_a(), this.getBloomingPlant(state, 3, world.field_73012_v.nextBoolean()), update_flag);
            world.func_180501_a(pos.func_177981_b(2), this.getBloomingPlant(state, 4, world.field_73012_v.nextBoolean()), update_flag);
        }
    }

    @Override
    public float getGrowChance(World world, BlockPos pos, IBlockState state) {
        return super.getGrowChance(world, pos, state);
    }

    @Override
    public float getBloomChance(World world, BlockPos pos, IBlockState state) {
        return 0.25f;
    }

    @Override
    public boolean canBloom(World world, BlockPos pos, IBlockState state) {
        return CommonUtils.isValueMatch(this.getAge(state), 3, 4);
    }

    @Override
    public boolean isValidSoil(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return !BlockMultiplexer.forBlock(PrimalAPI.Blocks.NIGHT_STONE).apply(state) && (state.isSideSolid(world, pos, EnumFacing.UP) || PrimalAPI.Predicates.SOIL_NETHER_COMMON.apply((Object)state));
    }

    @Override
    public void updatePlant(World world, BlockPos pos, IBlockState state, Random rand, int age) {
        if (this.isMature(state) && this.canBloom(world, pos, state) && PrimalAPI.randomCheck(this.getBloomChance(world, pos, state))) {
            world.func_180501_a(pos, state.func_177231_a((IProperty)PLANT_BLOOM), 2);
        }
        IBlockState aged_current = this.increaseAge(state, 1);
        IBlockState base_stage = this.getAgedPlant(state, 3);
        IBlockState growth_stage = this.getAgedPlant(state, 4);
        switch (age) {
            case 0: 
            case 1: {
                if (!CommonUtils.hasNearByMaterial((IBlockAccess)world, pos, this.range, this.range, Material.field_151587_i)) break;
                PrimalAPI.placeScheduledBlock(world, pos, aged_current, 2);
                break;
            }
            case 2: {
                if (!CommonUtils.hasNearByMaterial((IBlockAccess)world, pos, this.range, this.range, Material.field_151587_i)) break;
                PrimalAPI.placeScheduledBlock(world, pos, base_stage, 2);
                PrimalAPI.placeScheduledBlock(world, pos.func_177984_a(), growth_stage, 2);
                break;
            }
            case 4: {
                if (!this.isBelowHeight(world, pos, state)) break;
                PrimalAPI.placeScheduledBlock(world, pos, base_stage, 2);
                PrimalAPI.placeScheduledBlock(world, pos.func_177984_a(), growth_stage, 2);
            }
        }
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!PlayerHelper.isNetherEntity(entity)) {
            int age = this.getAge(world.func_180495_p(pos));
            if (age > 2) {
                entity.field_70159_w *= 0.6;
                entity.field_70179_y *= 0.6;
            }
            if (PrimalAPI.randomCheck(90) && age > 2) {
                float factor = RANDOM.nextFloat() * 1.6f;
                float a = 0.0f;
                float c = 0.0f;
                for (int r = 1; r <= this.range; ++r) {
                    for (int n = pos.func_177958_n() - r; n <= pos.func_177958_n() + r; ++n) {
                        for (int m = pos.func_177952_p() - r; m <= pos.func_177952_p() + r; ++m) {
                            for (int v = pos.func_177956_o(); v >= pos.func_177956_o() - 3; --v) {
                                if (world.func_180495_p(new BlockPos(n, v, m)).func_185904_a() != Material.field_151587_i) continue;
                                float f = n > pos.func_177958_n() ? a + factor : (a = n < pos.func_177958_n() ? a - factor : a);
                                c = m > pos.func_177952_p() ? c + factor : (m < pos.func_177952_p() ? c - factor : c);
                                entity.func_70024_g((double)a, 0.0, (double)c);
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.DANGER_OTHER;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            int spores;
            float seeds = 0.6f;
            int fibers = RANDOM.nextInt(1, 2);
            int n = spores = this.isBlooming(state) ? RANDOM.nextInt(1, 2) : 0;
            if (this.getAge(state) > 2) {
                SinuousWeed.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(PrimalAPI.Items.SINUOUS_FIBER, fibers));
                if (spores > 0) {
                    SinuousWeed.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(PrimalAPI.Items.SINUOUS_SPORE, spores));
                }
            } else if (RANDOM.nextFloat() <= seeds) {
                SinuousWeed.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getSeed(state));
            }
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        int spores;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        IBlockState state = world.func_180495_p(pos);
        float seeds = 0.6f;
        int fibers = RANDOM.nextInt(1, 2);
        int n = spores = this.isBlooming(state) ? RANDOM.nextInt(1, 2) : 0;
        if (this.getAge(state) > 2) {
            drops.add(new ItemStack(PrimalAPI.Items.SINUOUS_FIBER, fibers));
            if (spores > 0) {
                drops.add(new ItemStack(PrimalAPI.Items.SINUOUS_SPORE, spores));
            }
        } else if (RANDOM.nextFloat() <= seeds) {
            drops.add(this.getSeed(state));
        }
        return drops;
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState soil = this.getSoil((IBlockAccess)world, pos);
        if (state.func_177230_c() == this && this.getAge(state) < 4) {
            return this.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
        }
        return this.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant_state = plantable.getPlant(world, pos.func_177972_a(direction));
        Block plant = plant_state.func_177230_c();
        Block soil = state.func_177230_c();
        if (plant == this) {
            int age = this.getAge(plant_state);
            if (age > 2) {
                return soil == this && ((IPrimalPlants)soil).isMature(state) || world.isSideSolid(pos, EnumFacing.UP, true);
            }
            return world.isSideSolid(pos, EnumFacing.UP, true);
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isBlooming(state)) {
            FXHelper.makeParticles(world, pos, EnumParticleTypes.TOWN_AURA, 4, 6, 0.62f);
        }
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getAge(state) == 0 ? PrimalAPI.Bounds.AABB_EMPTY : PrimalAPI.Bounds.AABB_BUSH_LARGE;
    }
}

