/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.invasive;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.plants.IInvasive;
import nmd.primal.core.api.interfaces.plants.IPerennial;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.blocks.plants.AbstractPlantInvasive;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.init.ModConfig;

public class CinerisGrass
extends AbstractPlantInvasive
implements IShearable,
IPerennial,
ISchedule {
    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.isMature(state) ? PrimalAPI.Bounds.AABB_BUSH_LARGE : (this.getAge(state) == 0 ? PrimalAPI.Bounds.AABB_EMPTY : PrimalAPI.Bounds.AABB_BUSH);
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return !this.isBlooming(state);
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return true;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt(ModConfig.Plants.PLANT_BASE_TICK_RATE / 2, ModConfig.Plants.PLANT_BASE_TICK_RATE);
    }

    @Override
    public IBlockState getNewPlant() {
        return this.func_176223_P();
    }

    @Override
    public boolean canNewGrow(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public IBlockState getSpreadPlant(World world, BlockPos pos) {
        return PrimalAPI.randomCheck(90) ? PrimalAPI.Blocks.CINERIS_BLOOM.func_176223_P() : PrimalAPI.Blocks.CINERIS_GRASS.func_176223_P();
    }

    @Override
    public boolean shouldSpread(World world, BlockPos pos, IBlockState state) {
        PrimalAPI.logger(8, "cineris", "shouldSpread: " + this.isBlooming(state));
        return world.field_73011_w.func_186058_p() != DimensionType.NETHER && !CommonUtils.isValueMatch(this.getAge(world.func_180495_p(pos)), 4) && !PrimalAPI.Predicates.SPREAD_INTERDICTION.apply((Object)world.func_180495_p(pos.func_177977_b()));
    }

    @Override
    public boolean canSpreadTo(World world, BlockPos source_pos, BlockPos spread_pos) {
        return !world.func_175678_i(spread_pos) && !PrimalAPI.Predicates.SPREAD_RESISTANT.apply((Object)world.func_180495_p(spread_pos.func_177977_b()));
    }

    @Override
    public float getSpreadChance(World word, BlockPos source_pos, IBlockState source_state) {
        return 0.25f;
    }

    @Override
    public int getSpreadChecks(World word, BlockPos source_pos, IBlockState source_state) {
        return 16;
    }

    @Override
    public int getSpreadRange(World word, BlockPos source_pos, IBlockState source_state) {
        return 6;
    }

    @Override
    public IPrimalPlants.EnumType getType(IBlockState state) {
        return IPrimalPlants.EnumType.NETHER;
    }

    @Override
    public ItemStack getSeed(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.CINERIS_SEED);
    }

    @Override
    public ItemStack getCrop(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.CINERIS_FIBER);
    }

    @Override
    public ItemStack getStalk(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.CINERIS_ROOT);
    }

    @Override
    public boolean isMature(IBlockState state) {
        return this.getAge(state) == 4;
    }

    @Override
    public float getGrowChance(World world, BlockPos pos, IBlockState state) {
        return super.getGrowChance(world, pos, state);
    }

    @Override
    public boolean isValidSoil(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.isSideSolid(world, pos, EnumFacing.UP) || PrimalAPI.Predicates.SOIL_NETHER_COMMON.apply((Object)state);
    }

    @Override
    public boolean canBloom(World world, BlockPos pos, IBlockState state) {
        return !this.isBlooming(state) && CommonUtils.isValueMatch(this.getAge(state), 4);
    }

    @Override
    public float getBloomChance(World world, BlockPos pos, IBlockState state) {
        return 0.65f;
    }

    @Override
    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isMature(state);
    }

    @Override
    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    @Override
    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        ((IInvasive)PrimalAPI.Blocks.CINERIS_GRASS).spreadPlant(world, pos, PrimalAPI.Blocks.CINERIS_GRASS.func_176223_P());
        super.onBlockExploded(world, pos, explosion);
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            if (PrimalAPI.randomCheck((float)ModConfig.Survival.DROPS_CINERIS_FIBERS)) {
                CinerisGrass.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getCrop(state));
            }
            if (this.isBlooming(state) && PrimalAPI.randomCheck((float)ModConfig.Survival.DROPS_CINERIS_SEEDS)) {
                ItemStack seeds = this.getSeed(state);
                int amount = PrimalAPI.randomCheck(8) ? 2 : 1;
                seeds.func_190920_e(amount);
                CinerisGrass.func_180635_a((World)world, (BlockPos)pos, (ItemStack)seeds);
            }
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack drop = this.isMature(state) ? this.getStalk(state) : this.getCrop(state);
        return Arrays.asList(drop);
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        this.collideWithGrass(world, pos, state, entity);
    }

    private void collideWithGrass(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this.getAge(state) < 3) {
            return;
        }
        if (entity.field_70122_E && !entity.func_70093_af() && !PlayerHelper.isNetherEntity(entity)) {
            int phase = (int)(world.getCurrentMoonPhaseFactorBody() * 100.0f);
            float factor = 0.012f;
            float a = 0.0f;
            float c = 0.0f;
            switch (phase) {
                case 100: {
                    a += RANDOM.nextFloat() * factor;
                    c += RANDOM.nextFloat() * factor;
                    break;
                }
                case 75: {
                    a += RANDOM.nextFloat() * factor;
                    c -= RANDOM.nextFloat() * factor;
                    break;
                }
                case 25: {
                    a -= RANDOM.nextFloat() * factor;
                    c += RANDOM.nextFloat() * factor;
                    break;
                }
                case 0: {
                    a -= RANDOM.nextFloat() * factor;
                    c -= RANDOM.nextFloat() * factor;
                    break;
                }
                default: {
                    a += RANDOM.nextFloat() * factor - RANDOM.nextFloat() * factor;
                    c += RANDOM.nextFloat() * factor - RANDOM.nextFloat() * factor;
                }
            }
            entity.func_70024_g((double)a, 0.0, (double)c);
        }
    }
}

