/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.invasive;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.plants.IPerennial;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.blocks.plants.AbstractPlantInvasive;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;
import nmd.primal.core.common.init.ModConfig;

public class DryGrass
extends AbstractPlantInvasive
implements IShearable,
IPerennial,
ISchedule {
    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.isMature(state) ? PrimalAPI.Bounds.AABB_BUSH_LARGE : (this.getAge(state) == 0 ? PrimalAPI.Bounds.AABB_EMPTY : PrimalAPI.Bounds.AABB_BUSH);
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return !this.isMature(state);
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return true;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt(ModConfig.Plants.PLANT_BASE_TICK_RATE / 2, ModConfig.Plants.PLANT_BASE_TICK_RATE);
    }

    @Override
    public IBlockState getNewPlant() {
        return this.func_176223_P();
    }

    @Override
    public boolean canNewGrow(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public boolean canBloom(World world, BlockPos pos, IBlockState state) {
        return false;
    }

    @Override
    public float getBloomChance(World world, BlockPos pos, IBlockState state) {
        return 0.65f;
    }

    @Override
    public IBlockState getSpreadPlant(World world, BlockPos pos) {
        return PrimalAPI.Blocks.DRY_GRASS.func_176223_P();
    }

    @Override
    public boolean shouldSpread(World world, BlockPos pos, IBlockState state) {
        PrimalAPI.logger(8, "dry grass", "shouldSpread: " + this.isBlooming(state));
        return world.field_73011_w.func_186058_p() == DimensionType.NETHER && !CommonUtils.isValueMatch(this.getAge(world.func_180495_p(pos)), 3) && !BlockMultiplexer.forBlock(PrimalAPI.Blocks.NETHER_FARMLAND, PrimalAPI.Blocks.NETHER_GROWTH, PrimalAPI.Blocks.DESICCATED_STONE).apply(world.func_180495_p(pos.func_177977_b()));
    }

    @Override
    public boolean canSpreadTo(World world, BlockPos source_pos, BlockPos spread_pos) {
        return !PrimalAPI.Predicates.SPREAD_RESISTANT.apply((Object)world.func_180495_p(spread_pos.func_177977_b()));
    }

    @Override
    public float getSpreadChance(World word, BlockPos source_pos, IBlockState source_state) {
        return 0.25f;
    }

    @Override
    public int getSpreadChecks(World word, BlockPos source_pos, IBlockState source_state) {
        return 8;
    }

    @Override
    public int getSpreadRange(World word, BlockPos source_pos, IBlockState source_state) {
        return 3;
    }

    @Override
    public IPrimalPlants.EnumType getType(IBlockState state) {
        return IPrimalPlants.EnumType.UNKNOWN;
    }

    @Override
    public ItemStack getSeed(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.DRY_GRASS_ROOT);
    }

    @Override
    public ItemStack getCrop(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.PLANT_FIBER);
    }

    @Override
    public boolean isMature(IBlockState state) {
        return this.getAge(state) == 3;
    }

    @Override
    public float getGrowChance(World world, BlockPos pos, IBlockState state) {
        return super.getGrowChance(world, pos, state);
    }

    @Override
    public boolean isValidSoil(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return !BlockMultiplexer.forBlock(PrimalAPI.Blocks.NIGHT_STONE).apply(state) && (state.isSideSolid(world, pos, EnumFacing.UP) || PrimalAPI.Predicates.SOIL_NETHER_COMMON.apply((Object)state));
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant_state = plantable.getPlant(world, pos.func_177972_a(direction));
        Block plant = plant_state.func_177230_c();
        if (plant == this) {
            return this.isValidSoil(world, pos);
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
    }

    @Override
    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tile, @Nullable ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots && (double)RANDOM.nextFloat() <= ModConfig.Survival.DROPS_CINERIS_FIBERS) {
            DryGrass.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getCrop(state));
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack drop = this.isMature(state) ? this.getStalk(state) : this.getCrop(state);
        return Arrays.asList(drop);
    }
}

