/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.invasive;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.plants.IInvasive;
import nmd.primal.core.api.interfaces.plants.IPerennial;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.api.interfaces.types.ITypeBrick;
import nmd.primal.core.common.blocks.plants.AbstractPlantInvasive;
import nmd.primal.core.common.init.ModConfig;

public class TallGrass
extends AbstractPlantInvasive
implements IPerennial,
ISchedule {
    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return true;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt(ModConfig.Plants.PLANT_BASE_TICK_RATE / 2, ModConfig.Plants.PLANT_BASE_TICK_RATE);
    }

    @Override
    public IBlockState getNewPlant() {
        return this.func_176223_P();
    }

    @Override
    public boolean canNewGrow(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public IBlockState getSpreadPlant(World world, BlockPos pos) {
        return PrimalAPI.Blocks.TALL_GRASS.func_176223_P();
    }

    @Override
    public boolean shouldSpread(World world, BlockPos pos, IBlockState state) {
        PrimalAPI.logger(8, "tall grass", "shouldSpread: " + this.isBlooming(state));
        return world.func_175727_C(pos);
    }

    @Override
    public boolean canSpreadTo(World world, BlockPos source_pos, BlockPos spread_pos) {
        return world.func_180495_p(source_pos.func_177977_b()).func_177230_c() == Blocks.field_150349_c;
    }

    @Override
    public float getSpreadChance(World word, BlockPos source_pos, IBlockState source_state) {
        return 0.25f;
    }

    @Override
    public int getSpreadChecks(World word, BlockPos source_pos, IBlockState source_state) {
        return 6;
    }

    @Override
    public int getSpreadRange(World word, BlockPos source_pos, IBlockState source_state) {
        return 2;
    }

    @Override
    public IPrimalPlants.EnumType getType(IBlockState state) {
        return IPrimalPlants.EnumType.NORMAL;
    }

    @Override
    public ItemStack getSeed(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.TALL_GRASS_SEEDS);
    }

    @Override
    public ItemStack getCrop(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.PLANT_FIBER);
    }

    @Override
    public boolean isMature(IBlockState state) {
        return false;
    }

    @Override
    public boolean canBloom(World world, BlockPos pos, IBlockState state) {
        return false;
    }

    @Override
    public float getBloomChance(World world, BlockPos pos, IBlockState state) {
        return 0.0f;
    }

    @Override
    public float getGrowChance(World world, BlockPos pos, IBlockState state) {
        return super.getGrowChance(world, pos, state) + 10.0f;
    }

    @Override
    public void updatePlant(World world, BlockPos pos, IBlockState state, Random rand, int age) {
        float growth_chance = this.getGrowChance(world, pos, state);
        if (ModConfig.Plants.TALL_GRASS_RAIN_SPREAD) {
            this.spreadPlant(world, pos, state);
        }
        if (this.canTerraformSurface(world, pos) && PrimalAPI.randomCheck(growth_chance)) {
            PrimalAPI.logger(8, "tall grass", "terraform check");
            this.terraformSurface(world, pos);
        } else if (PrimalAPI.randomCheck(growth_chance)) {
            PrimalAPI.logger(8, "tall grass", "grow");
            world.func_180501_a(pos, Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS), 2);
        }
        PrimalAPI.scheduleBlock(world, pos, state);
    }

    private void spreadSurfaceGrass(World world, BlockPos pos) {
        if (!world.func_175697_a(pos, 3)) {
            return;
        }
        BlockPos pos_surface = pos.func_177977_b();
        if (world.func_175671_l(pos_surface.func_177984_a()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos_surface.func_177982_a(RANDOM.nextInt(3) - 1, RANDOM.nextInt(5) - 3, RANDOM.nextInt(3) - 1);
                if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256 && !world.func_175667_e(blockpos)) {
                    return;
                }
                IBlockState iblockstate = world.func_180495_p(blockpos.func_177984_a());
                IBlockState iblockstate1 = world.func_180495_p(blockpos);
                if (!this.isTargetDirt(iblockstate1) || world.func_175671_l(blockpos.func_177984_a()) < 4 || iblockstate.getLightOpacity((IBlockAccess)world, pos_surface.func_177984_a()) > 2) continue;
                world.func_175656_a(blockpos, Blocks.field_150349_c.func_176223_P());
            }
        }
    }

    private void terraformSurface(World world, BlockPos pos) {
        BlockPos pos_surface = pos.func_177977_b();
        IBlockState surface_state = world.func_180495_p(pos_surface);
        if (this.isTargetDirt(surface_state)) {
            if (world.func_175671_l(pos) >= 4) {
                world.func_180501_a(pos_surface, Blocks.field_150349_c.func_176223_P(), 2);
            }
        } else if (this.isTargetDesiccated(surface_state)) {
            world.func_180501_a(pos_surface, Blocks.field_150346_d.func_176223_P(), 2);
        }
    }

    private boolean canTerraformSurface(World world, BlockPos pos) {
        IBlockState surface_state = world.func_180495_p(pos.func_177977_b());
        if (this.isTargetDirt(surface_state)) {
            PrimalAPI.logger(8, "tall grass", "terraform: dirt");
            return true;
        }
        if (this.isTargetDesiccated(surface_state)) {
            PrimalAPI.logger(8, "tall grass", "terraform: nether earth");
            return true;
        }
        return false;
    }

    private boolean isTargetDirt(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150346_d && state.func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.DIRT;
    }

    private boolean isTargetDesiccated(IBlockState state) {
        return state.func_177230_c() == PrimalAPI.Blocks.DESICCATED_STONE && state.func_177229_b(ITypeBrick.TYPE) == ITypeBrick.EnumType.NORMAL;
    }

    @Override
    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    @Override
    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS), 2);
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public int func_149745_a(Random random) {
        return 0;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        ((IInvasive)PrimalAPI.Blocks.TALL_GRASS).spreadPlant(world, pos, PrimalAPI.Blocks.TALL_GRASS.func_176223_P());
        super.onBlockExploded(world, pos, explosion);
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState soil = this.getSoil((IBlockAccess)world, pos);
        if (state.func_177230_c() == this && this.getAge(state) < 4) {
            return this.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
        }
        return this.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant_state = plantable.getPlant(world, pos.func_177972_a(direction));
        Block plant = plant_state.func_177230_c();
        if (plant == this) {
            return this.isValidSoil(world, pos);
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    @Override
    public boolean isValidSoil(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return PrimalAPI.Predicates.SOIL_DIRT.apply((Object)state) || this.isTargetDesiccated(state);
    }
}

