/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.saxum;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.enums.EnumMoisture;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.types.ITypeBrick;
import nmd.primal.core.common.blocks.saxum.MudWet;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.init.ModConfig;

public class MudDrying
extends MudWet
implements ISchedule {
    private float spread_chance;

    public MudDrying() {
        this.func_149672_a(SoundType.field_185849_b);
        this.spread_chance = 0.01f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.abstract_wet_block"));
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_environment"));
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return CommonUtils.checkForAir((IBlockAccess)world, pos);
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return true;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt((int)Math.floor(4500.0 * ModConfig.Features.MUD_DRYING_MODIFIER), (int)Math.floor(6500.0 * ModConfig.Features.MUD_DRYING_MODIFIER));
    }

    private float getDryChance(World world, BlockPos pos) {
        float chance = 0.05f;
        if (world.func_72935_r() && world.func_175678_i(pos)) {
            chance += 0.15f;
        } else if (!CommonUtils.checkForAir((IBlockAccess)world, pos)) {
            chance += 0.1f;
        }
        if (FireHelper.hasNearByHeat(world, pos, 4, 2, true)) {
            chance += 0.15f;
        }
        return chance;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        float dry_chance;
        if (world.field_72995_K) {
            return;
        }
        boolean getting_wet = world.func_175727_C(pos.func_177984_a()) || CommonUtils.hasNearByMaterial((IBlockAccess)world, pos, 1, -1, Material.field_151586_h);
        float f = dry_chance = getting_wet ? 0.0f : this.getDryChance(world, pos);
        if (this.isWet(state)) {
            if (PrimalAPI.randomCheck(dry_chance)) {
                world.func_180501_a(pos, state.func_177226_a(PrimalAPI.States.WET_DRY, (Comparable)((Object)EnumMoisture.DRY)), 18);
            }
        } else if (getting_wet) {
            world.func_180501_a(pos, state.func_177226_a(PrimalAPI.States.WET_DRY, (Comparable)((Object)EnumMoisture.WET)), 18);
        } else if (PrimalAPI.randomCheck(dry_chance)) {
            world.func_180501_a(pos, this.getDryState(), 18);
            return;
        }
        PrimalAPI.scheduleBlock(world, pos, state);
    }

    private IBlockState getDryState() {
        return PrimalAPI.Blocks.MUD_DRIED.func_176223_P().func_177226_a(ITypeBrick.TYPE, (Comparable)((Object)ITypeBrick.EnumType.NORMAL));
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this.isWet(state)) {
            super.func_180634_a(world, pos, state, entity);
        }
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.isWet(state) ? PrimalAPI.Items.MUD_CLUMP : Item.func_150898_a((Block)this);
    }

    @Override
    public int func_149745_a(Random random) {
        return RANDOM.nextInt(3, 6);
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ThreadLocalRandom rand = RANDOM;
        if (this.isWet(state)) {
            int count = this.quantityDropped(state, fortune, rand);
            for (int i = 0; i < count; ++i) {
                Item item = this.func_180660_a(state, rand, fortune);
                if (item == null) continue;
                drops.add(new ItemStack(item, 1, this.func_180651_a(state)));
            }
        } else {
            Item item = this.func_180660_a(state, rand, fortune);
            if (item != null) {
                drops.add(new ItemStack(item, 1, this.func_180651_a(state)));
            }
        }
        return drops;
    }

    @Override
    public EnumPushReaction func_149656_h(IBlockState state) {
        return this.isWet(state) ? EnumPushReaction.DESTROY : EnumPushReaction.NORMAL;
    }

    @Override
    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }
}

