/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.ct.tools;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.recipes.AbstractToolRecipe;
import nmd.primal.core.common.recipes.inworld.ShovelRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.primal.Shovel")
@ModOnly(value="primal")
@ZenRegister
public class CTShovel {
    @ZenMethod
    public static void addRecipe(String recipe_name, crafttweaker.api.block.IBlockState input_state, @Optional crafttweaker.api.block.IBlockState output_state, @Optional IItemStack output_stack, @Optional int[] output_amount, @Optional String output_orientation) {
        CraftTweakerAPI.apply((IAction)new Add(recipe_name, CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)input_state), output_state != null ? CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)output_state) : Blocks.field_150350_a.func_176223_P(), output_stack != null ? (ItemStack)output_stack.getInternal() : ItemStack.field_190927_a, output_amount, AbstractToolRecipe.Orientation.byName(output_orientation)));
    }

    @ZenMethod
    public static void addRecipe(String recipe_name, IItemStack input_state, @Optional IItemStack output_state, @Optional IItemStack output_stack, @Optional int[] output_amount, @Optional String output_orientation) {
        if (RecipeHelper.isBlock((ItemStack)input_state.getInternal())) {
            IBlockState output;
            Block input_block = CraftTweakerMC.getBlock((IItemStack)input_state);
            IBlockState input = input_block.func_176203_a(input_state.getMetadata());
            if (output_state != null) {
                Block output_block = CraftTweakerMC.getBlock((IItemStack)output_state);
                output = output_block.func_176203_a(output_state.getMetadata());
            } else {
                output = Blocks.field_150350_a.func_176223_P();
            }
            CraftTweakerAPI.apply((IAction)new Add(recipe_name, input, output, output_stack != null ? (ItemStack)output_stack.getInternal() : ItemStack.field_190927_a, output_amount, AbstractToolRecipe.Orientation.byName(output_orientation)));
        } else {
            PrimalCore.LOGGER.error(String.format("%s input must create a valid BlockState", input_state.getDisplayName()), (Throwable)new IllegalArgumentException(String.format("%s input must create a valid BlockState", input_state.getDisplayName())));
        }
    }

    @ZenMethod
    public static void removeRecipe(String recipe_name) {
        CraftTweakerAPI.apply((IAction)new Remove(recipe_name));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    static {
        PrimalCore.LOGGER.info("Registering CraftTweaker: shovel");
    }

    private static class RemoveAll
    implements IAction {
        public void apply() {
            for (ShovelRecipe recipe : ShovelRecipe.RECIPES) {
                if (recipe.isHidden()) continue;
                recipe.setDisabled(true);
            }
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: shovel";
        }
    }

    private static class Remove
    implements IAction {
        private String recipe_name;

        public Remove(String recipe_name) {
            this.recipe_name = recipe_name;
        }

        public void apply() {
            ShovelRecipe recipe = (ShovelRecipe)ShovelRecipe.REGISTRY.getValue(ShovelRecipe.getFullRecipeName(this.recipe_name));
            if (recipe != null && !recipe.isHidden()) {
                PrimalCore.LOGGER.info("Remove CraftTweaker Recipe: " + this.recipe_name);
                recipe.setDisabled(true);
            }
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: shovel";
        }
    }

    private static class Add
    implements IAction {
        private String recipe_name;
        private IBlockState input_state;
        private IBlockState output_state;
        private ItemStack output_stack;
        private AbstractToolRecipe.Orientation output_orientation;
        private int[] output_amount;
        private boolean is_disabled;
        private boolean is_hidden;

        public Add(String recipe_name, IBlockState input_state, IBlockState output_state, ItemStack output_stack, int[] output_amount, AbstractToolRecipe.Orientation output_orientation) {
            int[] nArray;
            this.recipe_name = recipe_name;
            this.input_state = input_state;
            this.output_state = output_state != null ? output_state : Blocks.field_150350_a.func_176223_P();
            ItemStack itemStack = this.output_stack = output_stack != null ? output_stack : ItemStack.field_190927_a;
            if (output_amount != null) {
                nArray = output_amount;
            } else {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 0;
            }
            this.output_amount = nArray;
            this.output_orientation = output_orientation != null ? output_orientation : AbstractToolRecipe.Orientation.NORMAL;
            this.is_disabled = false;
            this.is_hidden = false;
        }

        public void apply() {
            PrimalCore.LOGGER.info("Add CraftTweaker Recipe: " + this.recipe_name);
            ShovelRecipe.REGISTRY.register((IForgeRegistryEntry)new ShovelRecipe(this.input_state, this.output_state, this.output_stack, this.output_amount, this.output_orientation).setRecipeName(this.recipe_name));
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: shovel";
        }
    }
}

