/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.jei;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreIngredient;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.types.ITypeMud;
import nmd.primal.core.api.interfaces.types.ITypeWood;
import nmd.primal.core.client.gui.GuiWorkTableShelf;
import nmd.primal.core.client.gui.GuiWorkTableSlab;
import nmd.primal.core.common.compat.jei.CraftingTableTransfer;
import nmd.primal.core.common.compat.jei.brickmold.BrickRecipeCategory;
import nmd.primal.core.common.compat.jei.brickmold.BrickRecipeChecker;
import nmd.primal.core.common.compat.jei.brickmold.BrickRecipeHandler;
import nmd.primal.core.common.compat.jei.cauldron.CauldronRecipeCategory;
import nmd.primal.core.common.compat.jei.cauldron.CauldronRecipeChecker;
import nmd.primal.core.common.compat.jei.cauldron.CauldronRecipeHandler;
import nmd.primal.core.common.compat.jei.drying.DryingRecipeCategory;
import nmd.primal.core.common.compat.jei.drying.DryingRecipeChecker;
import nmd.primal.core.common.compat.jei.drying.DryingRecipeHandler;
import nmd.primal.core.common.compat.jei.flake.FlakeRecipeCategory;
import nmd.primal.core.common.compat.jei.flake.FlakeRecipeChecker;
import nmd.primal.core.common.compat.jei.flake.FlakeRecipeHandler;
import nmd.primal.core.common.compat.jei.hibachi.HibachiRecipeCategory;
import nmd.primal.core.common.compat.jei.hibachi.HibachiRecipeChecker;
import nmd.primal.core.common.compat.jei.hibachi.HibachiRecipeHandler;
import nmd.primal.core.common.compat.jei.smelter.SmelterRecipeCategory;
import nmd.primal.core.common.compat.jei.smelter.SmelterRecipeChecker;
import nmd.primal.core.common.compat.jei.smelter.SmelterRecipeHandler;
import nmd.primal.core.common.compat.jei.tools.axe.AxeRecipeCategory;
import nmd.primal.core.common.compat.jei.tools.axe.AxeRecipeChecker;
import nmd.primal.core.common.compat.jei.tools.axe.AxeRecipeHandler;
import nmd.primal.core.common.compat.jei.tools.blade.BladeRecipeCategory;
import nmd.primal.core.common.compat.jei.tools.blade.BladeRecipeChecker;
import nmd.primal.core.common.compat.jei.tools.blade.BladeRecipeHandler;
import nmd.primal.core.common.compat.jei.tools.gallahger.GallagherRecipeCategory;
import nmd.primal.core.common.compat.jei.tools.gallahger.GallagherRecipeChecker;
import nmd.primal.core.common.compat.jei.tools.gallahger.GallagherRecipeHandler;
import nmd.primal.core.common.compat.jei.tools.hoe.HoeRecipeCategory;
import nmd.primal.core.common.compat.jei.tools.hoe.HoeRecipeChecker;
import nmd.primal.core.common.compat.jei.tools.hoe.HoeRecipeHandler;
import nmd.primal.core.common.compat.jei.tools.shovel.ShovelRecipeCategory;
import nmd.primal.core.common.compat.jei.tools.shovel.ShovelRecipeChecker;
import nmd.primal.core.common.compat.jei.tools.shovel.ShovelRecipeHandler;
import nmd.primal.core.common.containers.ContainerWorkTableShelf;
import nmd.primal.core.common.containers.ContainerWorkTableSlab;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.items.tools.Gallagher;
import nmd.primal.core.common.items.tools.WorkBlade;
import nmd.primal.core.common.recipes.inworld.AxeRecipe;
import nmd.primal.core.common.recipes.inworld.BladeRecipe;
import nmd.primal.core.common.recipes.inworld.FlakeRecipe;
import nmd.primal.core.common.recipes.inworld.GallagherRecipe;
import nmd.primal.core.common.recipes.inworld.HoeRecipe;
import nmd.primal.core.common.recipes.inworld.ShovelRecipe;
import nmd.primal.core.common.recipes.tile.BrickRecipe;
import nmd.primal.core.common.recipes.tile.CauldronRecipe;
import nmd.primal.core.common.recipes.tile.DryingRecipe;
import nmd.primal.core.common.recipes.tile.HibachiRecipe;
import nmd.primal.core.common.recipes.tile.SmelterRecipe;

@JEIPlugin
public class ModJEI
implements IModPlugin {
    public static IJeiHelpers jeiHelper;
    public static ICraftingGridHelper craftingGridHelper;
    public static IRecipeRegistry recipeRegistry;
    public static IGuiHelper guiHelper;
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    private static List<ItemStack> gallaghers;
    private static List<ItemStack> blades;
    private static List<ItemStack> axes;
    private static List<ItemStack> shovels;
    private static List<ItemStack> hoes;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new FlakeRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GallagherRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BladeRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AxeRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ShovelRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new HoeRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BrickRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new DryingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new HibachiRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SmelterRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CauldronRecipeCategory(guiHelper)});
    }

    public void register(@Nonnull IModRegistry registry) {
        jeiHelper = registry.getJeiHelpers();
        guiHelper = jeiHelper.getGuiHelper();
        craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
        this.buildToolLists();
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new CraftingTableTransfer());
        registry.addRecipeCatalyst((Object)new ItemStack(PrimalAPI.Blocks.WORKTABLE_SHELF, 1, Short.MAX_VALUE), new String[]{"minecraft.crafting"});
        registry.addRecipeCatalyst((Object)new ItemStack(PrimalAPI.Blocks.WORKTABLE_SLAB, 1, Short.MAX_VALUE), new String[]{"minecraft.crafting"});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerWorkTableSlab.class, "minecraft.crafting", 1, 9, 10, 36);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(GuiWorkTableSlab.ClientContainerWorkTableSlab.class, "minecraft.crafting", 1, 9, 10, 36);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerWorkTableShelf.class, "minecraft.crafting", 1, 9, 10, 40);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(GuiWorkTableShelf.ClientContainerWorkTableShelf.class, "minecraft.crafting", 1, 9, 10, 40);
        registry.handleRecipes(BrickRecipe.class, (IRecipeWrapperFactory)new BrickRecipeHandler(), BrickRecipeCategory.CATEGORY);
        registry.addRecipes(BrickRecipeChecker.getRecipes(), BrickRecipeCategory.CATEGORY);
        for (ITypeWood.EnumType enumType : ITypeWood.EnumType.values()) {
            registry.addRecipeCatalyst((Object)new ItemStack(PrimalAPI.Blocks.BRICK_MOLD, 1, enumType.getMetadata()), new String[]{BrickRecipeCategory.CATEGORY});
        }
        registry.handleRecipes(DryingRecipe.class, (IRecipeWrapperFactory)new DryingRecipeHandler(), DryingRecipeCategory.CATEGORY);
        registry.addRecipes(DryingRecipeChecker.getRecipes(), DryingRecipeCategory.CATEGORY);
        for (ITypeWood.EnumType enumType : ITypeWood.EnumType.values()) {
            registry.addRecipeCatalyst((Object)new ItemStack(PrimalAPI.Blocks.DRYING_RACK, 1, enumType.getMetadata()), new String[]{DryingRecipeCategory.CATEGORY});
        }
        registry.handleRecipes(HibachiRecipe.class, (IRecipeWrapperFactory)new HibachiRecipeHandler(), HibachiRecipeCategory.CATEGORY);
        registry.addRecipes(HibachiRecipeChecker.getRecipes(), HibachiRecipeCategory.CATEGORY);
        for (Enum enum_ : ITypeMud.EnumType.values()) {
            registry.addRecipeCatalyst((Object)new ItemStack(PrimalAPI.Blocks.HIBACHI, 1, ((ITypeMud.EnumType)enum_).getMetadata()), new String[]{HibachiRecipeCategory.CATEGORY});
        }
        registry.handleRecipes(SmelterRecipe.class, (IRecipeWrapperFactory)new SmelterRecipeHandler(), SmelterRecipeCategory.CATEGORY);
        registry.addRecipes(SmelterRecipeChecker.getRecipes(), SmelterRecipeCategory.CATEGORY);
        for (Enum enum_ : ITypeMud.EnumType.values()) {
            ItemStack stack = new ItemStack(PrimalAPI.Blocks.SMELTER, 1, ((ITypeMud.EnumType)enum_).getMetadata());
            NBTTagCompound nbt = new NBTTagCompound();
            stack.func_77983_a("BlockEntityTag", (NBTBase)nbt);
            nbt.func_74757_a("covered", true);
            registry.addRecipeCatalyst((Object)stack, new String[]{SmelterRecipeCategory.CATEGORY});
        }
        registry.handleRecipes(CauldronRecipe.class, (IRecipeWrapperFactory)new CauldronRecipeHandler(), CauldronRecipeCategory.CATEGORY);
        registry.addRecipes(CauldronRecipeChecker.getRecipes(), CauldronRecipeCategory.CATEGORY);
        registry.addRecipeCatalyst((Object)new ItemStack(PrimalAPI.Blocks.CAULDRON), new String[]{CauldronRecipeCategory.CATEGORY});
        registry.handleRecipes(FlakeRecipe.class, (IRecipeWrapperFactory)new FlakeRecipeHandler(), FlakeRecipeCategory.CATEGORY);
        registry.addRecipes(FlakeRecipeChecker.getRecipes(), FlakeRecipeCategory.CATEGORY);
        registry.addRecipeCatalyst((Object)new ItemStack(Blocks.field_150348_b), new String[]{FlakeRecipeCategory.CATEGORY});
        registry.handleRecipes(GallagherRecipe.class, (IRecipeWrapperFactory)new GallagherRecipeHandler(), GallagherRecipeCategory.CATEGORY);
        registry.addRecipes(GallagherRecipeChecker.getRecipes(), GallagherRecipeCategory.CATEGORY);
        for (ItemStack stack : gallaghers) {
            registry.addRecipeCatalyst((Object)stack, new String[]{GallagherRecipeCategory.CATEGORY});
        }
        registry.handleRecipes(BladeRecipe.class, (IRecipeWrapperFactory)new BladeRecipeHandler(), BladeRecipeCategory.CATEGORY);
        registry.addRecipes(BladeRecipeChecker.getRecipes(), BladeRecipeCategory.CATEGORY);
        for (ItemStack stack : blades) {
            registry.addRecipeCatalyst((Object)stack, new String[]{BladeRecipeCategory.CATEGORY});
        }
        registry.handleRecipes(AxeRecipe.class, (IRecipeWrapperFactory)new AxeRecipeHandler(), AxeRecipeCategory.CATEGORY);
        registry.addRecipes(AxeRecipeChecker.getRecipes(), AxeRecipeCategory.CATEGORY);
        for (ItemStack stack : axes) {
            registry.addRecipeCatalyst((Object)stack, new String[]{AxeRecipeCategory.CATEGORY});
        }
        registry.handleRecipes(ShovelRecipe.class, (IRecipeWrapperFactory)new ShovelRecipeHandler(), ShovelRecipeCategory.CATEGORY);
        registry.addRecipes(ShovelRecipeChecker.getRecipes(), ShovelRecipeCategory.CATEGORY);
        for (ItemStack stack : shovels) {
            registry.addRecipeCatalyst((Object)stack, new String[]{ShovelRecipeCategory.CATEGORY});
        }
        registry.handleRecipes(HoeRecipe.class, (IRecipeWrapperFactory)new HoeRecipeHandler(), HoeRecipeCategory.CATEGORY);
        registry.addRecipes(HoeRecipeChecker.getRecipes(), HoeRecipeCategory.CATEGORY);
        for (ItemStack stack : hoes) {
            registry.addRecipeCatalyst((Object)stack, new String[]{HoeRecipeCategory.CATEGORY});
        }
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Blocks.FISH_TRAP, 1, Short.MAX_VALUE), VanillaTypes.ITEM, new String[]{"jei.info.primal.fish_trap"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Blocks.DRYING_RACK, 1, Short.MAX_VALUE), VanillaTypes.ITEM, new String[]{"jei.info.primal.drying_rack"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Blocks.HIBACHI, 1, Short.MAX_VALUE), VanillaTypes.ITEM, new String[]{"jei.info.primal.hibachi"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Blocks.SMELTER, 1, Short.MAX_VALUE), VanillaTypes.ITEM, new String[]{"jei.info.primal.smelter"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Blocks.CAULDRON), VanillaTypes.ITEM, new String[]{"jei.info.primal.cauldron"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Blocks.STORAGE_CRATE, 1, Short.MAX_VALUE), VanillaTypes.ITEM, new String[]{"jei.info.primal.crate"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Blocks.BARREL, 1, Short.MAX_VALUE), VanillaTypes.ITEM, new String[]{"jei.info.primal.barrel"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Blocks.THATCH_WET), VanillaTypes.ITEM, new String[]{"jei.info.primal.wet_block"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Blocks.MUD_WET), VanillaTypes.ITEM, new String[]{"jei.info.primal.wet_block"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Blocks.IGNIS_FATUUS), VanillaTypes.ITEM, new String[]{"jei.info.primal.ignis"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Blocks.SOUL_GLASS), VanillaTypes.ITEM, new String[]{"jei.info.primal.soulglass"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Blocks.PITFALL), VanillaTypes.ITEM, new String[]{"jei.info.primal.pitfall"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Blocks.ANCIENT_ICE), VanillaTypes.ITEM, new String[]{"jei.info.primal.ancient_ice"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Blocks.OVIS_ATRE_WOOL), VanillaTypes.ITEM, new String[]{"jei.info.primal.ovis_atre_wool"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Items.PLANT_FIBER), VanillaTypes.ITEM, new String[]{"jei.info.primal.plant_fiber", "jei.info.primal.fiber"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Items.CINERIS_FIBER), VanillaTypes.ITEM, new String[]{"jei.info.primal.cineris_fiber", "jei.info.primal.fiber"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Items.INANIS_FIBER), VanillaTypes.ITEM, new String[]{"jei.info.primal.inanis_fiber", "jei.info.primal.fiber"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Items.ACONITE_ROOT), VanillaTypes.ITEM, new String[]{"jei.info.primal.aconite"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Items.CINERIS_SEED), VanillaTypes.ITEM, new String[]{"jei.info.primal.cineris"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Items.INANIS_SEED), VanillaTypes.ITEM, new String[]{"jei.info.primal.cineris"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Items.GOGGLES_DARK_LENS), VanillaTypes.ITEM, new String[]{"jei.info.primal.goggles"});
        registry.addIngredientInfo((Object)new ItemStack(PrimalAPI.Items.DIRT_STICK), VanillaTypes.ITEM, new String[]{"jei.info.primal.debug_dirt_stick"});
        registry.addIngredientInfo(RecipeHelper.buildList(new OreIngredient("ladle").func_193365_a()), VanillaTypes.ITEM, new String[]{"jei.info.primal.ladle"});
        registry.addIngredientInfo(RecipeHelper.buildList(new OreIngredient("rock").func_193365_a()), VanillaTypes.ITEM, new String[]{"jei.info.primal.rocks"});
        registry.addIngredientInfo(RecipeHelper.buildList(new OreIngredient("pelt").func_193365_a()), VanillaTypes.ITEM, new String[]{"jei.info.primal.pelts"});
        registry.addIngredientInfo(RecipeHelper.buildList(new OreIngredient("hide").func_193365_a()), VanillaTypes.ITEM, new String[]{"jei.info.primal.hides"});
        registry.addIngredientInfo(RecipeHelper.buildList(new OreIngredient("ash").func_193365_a()), VanillaTypes.ITEM, new String[]{"jei.info.primal.ash"});
        registry.addIngredientInfo(RecipeHelper.buildList(new OreIngredient("logStripped").func_193365_a()), VanillaTypes.ITEM, new String[]{"jei.info.primal.log_stripped"});
        registry.addIngredientInfo(RecipeHelper.buildList(new OreIngredient("logSplit").func_193365_a()), VanillaTypes.ITEM, new String[]{"jei.info.primal.log_split"});
        registry.addIngredientInfo(RecipeHelper.buildList(new OreIngredient("logStack").func_193365_a()), VanillaTypes.ITEM, new String[]{"jei.info.primal.log_stack"});
        registry.addIngredientInfo(RecipeHelper.buildList(new OreIngredient("charcoalGrade").func_193365_a()), VanillaTypes.ITEM, new String[]{"jei.info.primal.charcoal"});
        if (ModConfig.Features.ENABLE_FLAKING_RECIPES) {
            registry.addIngredientInfo(RecipeHelper.buildList(new OreIngredient("flake").func_193365_a()), VanillaTypes.ITEM, new String[]{"jei.info.primal.flakes"});
        }
        this.cleanLists();
    }

    private void buildToolLists() {
        for (Item item : ForgeRegistries.ITEMS.getValuesCollection()) {
            if (item == null) continue;
            if (item instanceof ItemAxe) {
                axes.add(new ItemStack(item));
                continue;
            }
            if (item instanceof ItemSpade) {
                shovels.add(new ItemStack(item));
                continue;
            }
            if (item instanceof ItemHoe) {
                hoes.add(new ItemStack(item));
                continue;
            }
            if (item instanceof WorkBlade) {
                blades.add(new ItemStack(item));
                continue;
            }
            if (!(item instanceof Gallagher)) continue;
            gallaghers.add(new ItemStack(item));
        }
    }

    private void cleanLists() {
        axes.clear();
        shovels.clear();
        hoes.clear();
        blades.clear();
        gallaghers.clear();
    }

    static {
        PrimalAPI.logger(1, "Registering JEI Support");
        gallaghers = new ArrayList<ItemStack>();
        blades = new ArrayList<ItemStack>();
        axes = new ArrayList<ItemStack>();
        shovels = new ArrayList<ItemStack>();
        hoes = new ArrayList<ItemStack>();
    }
}

