/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.jei.cauldron;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;
import nmd.primal.core.common.compat.jei.ModJEI;
import nmd.primal.core.common.recipes.tile.CauldronRecipe;

public class CauldronRecipeWrapper
implements IRecipeWrapper {
    protected final CauldronRecipe recipe;
    protected final List<FluidStack> input_fluid;
    protected final List<FluidStack> output_fluid;
    protected final List<List<ItemStack>> input_slots;
    protected final List<ItemStack> output_items;
    protected final int time;
    private static ResourceLocation catalyst_texture = new ResourceLocation("primal", "textures/gui/jei/catalyst_slot.png");
    private final IDrawableStatic catalyst;

    public CauldronRecipeWrapper(CauldronRecipe recipe) {
        this.recipe = recipe;
        this.input_fluid = recipe.listFluidInput();
        this.output_fluid = recipe.listFluidOutput();
        this.input_slots = recipe.getInput();
        this.output_items = recipe.getOutput();
        this.time = recipe.getCookTime();
        IGuiHelper guiHelper = ModJEI.guiHelper;
        this.catalyst = guiHelper.createDrawable(catalyst_texture, 0, 0, 16, 16, 0, 0, 0, 0);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.FLUID, this.input_fluid);
        ingredients.setInputLists(VanillaTypes.ITEM, this.input_slots);
        ingredients.setOutputs(VanillaTypes.FLUID, this.output_fluid);
        ingredients.setOutputs(VanillaTypes.ITEM, this.output_items);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.field_71466_p.func_78276_b(String.valueOf(this.time), 80, 48, Color.gray.getRGB());
        if (this.recipe.hasCatalyst()) {
            String catalyst_text;
            if (this.recipe.isCatalystIngredient()) {
                int catalyst_y;
                int catalyst_x;
                switch (this.recipe.getCatalystSlot()) {
                    case 3: {
                        catalyst_x = 51;
                        catalyst_y = 38;
                        break;
                    }
                    case 2: {
                        catalyst_x = 32;
                        catalyst_y = 39;
                        break;
                    }
                    case 1: {
                        catalyst_x = 51;
                        catalyst_y = 19;
                        break;
                    }
                    default: {
                        catalyst_x = 32;
                        catalyst_y = 19;
                    }
                }
                this.catalyst.draw(minecraft, catalyst_x, catalyst_y);
                catalyst_text = "jei.recipe.primal.catalyst_ingredient";
            } else {
                catalyst_text = "jei.recipe.primal.catalyst_unknown";
            }
            minecraft.field_71466_p.func_78276_b(I18n.func_74838_a((String)catalyst_text), 26, -1, Color.GRAY.getRGB());
        }
        if (this.recipe.requiresLid()) {
            minecraft.field_71466_p.func_78276_b(I18n.func_74838_a((String)"jei.recipe.primal.cauldron_lid"), 26, 8, Color.GRAY.getRGB());
        }
    }
}

