/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.mods;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.helper.RegistryHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.init.ModRecipes;
import nmd.primal.core.common.recipes.tile.CauldronRecipe;
import nmd.primal.core.common.recipes.tile.DryingRecipe;
import nmd.primal.core.common.recipes.tile.HibachiRecipe;
import nmd.primal.core.common.recipes.tile.SmelterRecipe;

public class BNLCompat {
    public static final String MOD_ID = "thebetweenlands";
    @GameRegistry.ObjectHolder(value="thebetweenlands:mud")
    private static final Item BNL_MUD;
    @GameRegistry.ObjectHolder(value="thebetweenlands:black_ice")
    private static final Item BNL_ICE;
    @GameRegistry.ObjectHolder(value="thebetweenlands:bl_bucket")
    private static final Item BNL_BUCKET;
    @GameRegistry.ObjectHolder(value="thebetweenlands:bl_bucket_rubber")
    private static final Item BNL_BUCKET_RUBBER;
    @GameRegistry.ObjectHolder(value="thebetweenlands:items_misc")
    private static final Item BNL_MISC_ITEMS;
    @GameRegistry.ObjectHolder(value="thebetweenlands:items_crushed")
    private static final Item BNL_ITEMS_CRUSHED;
    @GameRegistry.ObjectHolder(value="thebetweenlands:log_rotten_bark")
    private static final Block BNL_LOG_ROTTEN;
    @GameRegistry.ObjectHolder(value="thebetweenlands:log_hearthgrove")
    private static final Block BNL_LOG_HEARTHGROVE;
    @GameRegistry.ObjectHolder(value="thebetweenlands:log_nibbletwig")
    private static final Block BNL_LOG_NIBBLETWIG;
    @GameRegistry.ObjectHolder(value="thebetweenlands:log_weedwood")
    private static final Block BNL_LOG_WEEDWOOD;
    @GameRegistry.ObjectHolder(value="thebetweenlands:weedwood")
    private static final Block BNL_WEEDWOOD;
    @GameRegistry.ObjectHolder(value="thebetweenlands:leaves_hearthgrove_tree")
    private static final Block BNL_LEAVES_HEARTHGROVE;
    @GameRegistry.ObjectHolder(value="thebetweenlands:leaves_nibbletwig_tree")
    private static final Block BNL_LEAVES_NIBBLETWIG;
    @GameRegistry.ObjectHolder(value="thebetweenlands:leaves_weedwood_tree")
    private static final Block BNL_LEAVES_WEEDWOOD;
    @GameRegistry.ObjectHolder(value="thebetweenlands:soft_rush")
    private static final Block BNL_SOFT_RUSH;

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)new BNLCompat());
    }

    public static void init() {
        if (BNL_MISC_ITEMS != null) {
            RegistryHelper.registerDictionaryNames(new ItemStack(BNL_MISC_ITEMS, 1, 10), "mudBetween");
        }
        if (BNL_SOFT_RUSH != null) {
            ModRecipes.addBasicKernRecipe(new ItemStack(BNL_SOFT_RUSH), new ItemStack(PrimalAPI.Items.URUSHI_GROUND, 3));
            RegistryHelper.registerDictionaryNames(new ItemStack(BNL_SOFT_RUSH), "thatchingMaterial");
        }
        if (BNL_MISC_ITEMS != null) {
            ModRecipes.addBasicKernRecipe(new ItemStack(BNL_MISC_ITEMS, 1, 13), new ItemStack(PrimalAPI.Items.TANNIN_GROUND, 2));
        }
        if (BNL_ITEMS_CRUSHED != null) {
            ModRecipes.addBasicKernRecipe(new ItemStack(BNL_ITEMS_CRUSHED, 1, 16), new ItemStack(PrimalAPI.Items.TANNIN_GROUND, 2));
        }
    }

    @SubscribeEvent
    public void registerDryingRecipes(RegistryEvent.Register<DryingRecipe> event) {
        PrimalAPI.logger(7, "Registering Drying Recipes: thebetweenlands");
        IForgeRegistry recipes = event.getRegistry();
        if (BNL_MISC_ITEMS != null) {
            recipes.register((IForgeRegistryEntry)new DryingRecipe(16, RecipeHelper.getOreStack("barkWood", 1, new ItemStack[0]), new ItemStack(BNL_MISC_ITEMS, 1, 13)).setRecipeName("thebetweenlands_bark"));
        }
    }

    @SubscribeEvent
    public void registerHibachiRecipes(RegistryEvent.Register<HibachiRecipe> event) {
        PrimalAPI.logger(7, "Registering Hibachi Recipes: thebetweenlands");
        IForgeRegistry recipes = event.getRegistry();
        if (BNL_MUD != null && BNL_MISC_ITEMS != null) {
            recipes.register((IForgeRegistryEntry)new HibachiRecipe(12, RecipeHelper.buildList(new ItemStack(BNL_MUD)), new ItemStack(BNL_MISC_ITEMS, 1, 10)).setRecipeName("thebetweenlands_mud_brick"));
        }
    }

    @SubscribeEvent
    public void registerCauldronRecipes(RegistryEvent.Register<CauldronRecipe> event) {
        FluidStack swamp_water;
        PrimalAPI.logger(7, "Registering Cauldron Recipes: thebetweenlands");
        IForgeRegistry recipes = event.getRegistry();
        if (BNL_ICE != null) {
            recipes.register((IForgeRegistryEntry)new CauldronRecipe(4, null, new FluidStack(FluidRegistry.WATER, 2000), RecipeHelper.buildList(new ItemStack(BNL_ICE)), ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("thebetweenlands_ice_to_water"));
        }
        if ((swamp_water = FluidRegistry.getFluidStack((String)"swamp_water", (int)1000)) != null) {
            recipes.register((IForgeRegistryEntry)new CauldronRecipe(6, swamp_water, new FluidStack(FluidRegistry.WATER, 1000), RecipeHelper.getOreStack(1, "charcoal"), ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("thebetweenlands_swamp_water"));
        }
    }

    @SubscribeEvent
    public void registerSmelterRecipes(RegistryEvent.Register<SmelterRecipe> event) {
        Block[] leaves;
        Block[] logs;
        PrimalAPI.logger(7, "Registering Smelter Recipes: thebetweenlands");
        IForgeRegistry recipes = event.getRegistry();
        for (Block block : logs = new Block[]{BNL_LOG_HEARTHGROVE, BNL_LOG_NIBBLETWIG, BNL_LOG_WEEDWOOD}) {
            if (block == null) continue;
            recipes.register((IForgeRegistryEntry)new SmelterRecipe(3, RecipeHelper.buildList(new ItemStack(block, 1, Short.MAX_VALUE)), new ItemStack(Items.field_151044_h, 1, 1), new ItemStack(PrimalAPI.Items.CHARCOAL_MOTE, 4)).setRecipeName(MOD_ID + RegistryHelper.formatRecipeName(block.func_149739_a() + "_charcoal")));
        }
        for (Block block : leaves = new Block[]{BNL_LEAVES_HEARTHGROVE, BNL_LEAVES_NIBBLETWIG, BNL_LEAVES_WEEDWOOD}) {
            if (block == null) continue;
            recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(16, RecipeHelper.buildList(new ItemStack(block, 4)), new ItemStack(PrimalAPI.Items.FERMENTED_JUNGLE)).setRecipeName(MOD_ID + RegistryHelper.formatRecipeName(block.func_149739_a() + "_fermented"))).setPassive(true));
        }
        if (BNL_LOG_ROTTEN != null) {
            recipes.register((IForgeRegistryEntry)new SmelterRecipe(3, RecipeHelper.buildList(new ItemStack(BNL_LOG_ROTTEN)), new ItemStack(PrimalAPI.Items.CHARCOAL_MOTE, 6)).setRecipeName("thebetweenlands_rotten_log"));
        }
        if (BNL_WEEDWOOD != null) {
            recipes.register((IForgeRegistryEntry)new SmelterRecipe(3, RecipeHelper.buildList(new ItemStack(BNL_WEEDWOOD)), new ItemStack(Items.field_151044_h, 1, 1)).setRecipeName("thebetweenlands_weedwood"));
        }
        if (BNL_ITEMS_CRUSHED != null) {
            recipes.register((IForgeRegistryEntry)new SmelterRecipe(2, RecipeHelper.buildList(new ItemStack(BNL_ITEMS_CRUSHED, 1, 16)), new ItemStack(PrimalAPI.Items.CHARCOAL_MOTE, 2)).setRecipeName("thebetweenlands_ground_bark_mote"));
        }
        if (BNL_MISC_ITEMS != null) {
            recipes.register((IForgeRegistryEntry)new SmelterRecipe(2, RecipeHelper.buildList(new ItemStack(BNL_MISC_ITEMS, 1, 13)), new ItemStack(PrimalAPI.Items.CHARCOAL_MOTE, 2)).setRecipeName("thebetweenlands_dry_bark_mote"));
            recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(20, RecipeHelper.buildList(new ItemStack(Items.field_151103_aS, 1)), RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.MUCK, 1)), new ItemStack(BNL_MISC_ITEMS, 1, 14)).setRecipeName("thebetweenlands_slimy_bone")).setPassive(true));
            if (BNL_BUCKET != null && BNL_BUCKET_RUBBER != null) {
                recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, RecipeHelper.buildList(new ItemStack(BNL_BUCKET_RUBBER, 1, 0)), RecipeHelper.getOreStack("charcoalMote", 3, new ItemStack[0]), new ItemStack(BNL_MISC_ITEMS, 1, 23), new ItemStack(BNL_BUCKET, 1, 0)).setRecipeName("thebetweenlands_weedwood_bucket_rubber"));
                recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, RecipeHelper.buildList(new ItemStack(BNL_BUCKET_RUBBER, 1, 1)), RecipeHelper.getOreStack("charcoalMote", 3, new ItemStack[0]), new ItemStack(BNL_MISC_ITEMS, 1, 23), new ItemStack(BNL_BUCKET, 1, 1)).setRecipeName("thebetweenlands_syrmorite_bucket_rubber"));
                Fluid rubber = FluidRegistry.getFluid((String)"rubber");
                if (rubber != null) {
                    List<ItemStack> bucket;
                    if (ModConfig.Fluids.BUCKETS_CLAY_ENABLED && !(bucket = RecipeHelper.buildList(PrimalAPI.Items.BUCKET_CLAY.getBucket(rubber))).isEmpty()) {
                        recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, bucket, RecipeHelper.getOreStack("charcoalMote", 3, new ItemStack[0]), new ItemStack(BNL_MISC_ITEMS, 1, 23), new ItemStack((Item)PrimalAPI.Items.BUCKET_CLAY)).setRecipeName("thebetweenlands_clay_bucket_rubber"));
                    }
                    if (ModConfig.Fluids.BUCKETS_TERRA_ENABLED && !(bucket = RecipeHelper.buildList(PrimalAPI.Items.BUCKET_TERRA.getBucket(rubber))).isEmpty()) {
                        recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, bucket, RecipeHelper.getOreStack("charcoalMote", 3, new ItemStack[0]), new ItemStack(BNL_MISC_ITEMS, 1, 23), new ItemStack((Item)PrimalAPI.Items.BUCKET_TERRA)).setRecipeName("thebetweenlands_terra_bucket_rubber"));
                    }
                    if (ModConfig.Fluids.BUCKETS_CINIS_ENABLED && !(bucket = RecipeHelper.buildList(PrimalAPI.Items.BUCKET_CINIS.getBucket(rubber))).isEmpty()) {
                        recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, bucket, RecipeHelper.getOreStack("charcoalMote", 3, new ItemStack[0]), new ItemStack(BNL_MISC_ITEMS, 1, 23), new ItemStack((Item)PrimalAPI.Items.BUCKET_CINIS)).setRecipeName("thebetweenlands_cinis_bucket_rubber"));
                    }
                }
            }
        }
    }

    static {
        PrimalAPI.logger(1, "Mod Integration: thebetweenlands");
        BNL_MUD = null;
        BNL_ICE = null;
        BNL_BUCKET = null;
        BNL_BUCKET_RUBBER = null;
        BNL_MISC_ITEMS = null;
        BNL_ITEMS_CRUSHED = null;
        BNL_LOG_ROTTEN = null;
        BNL_LOG_HEARTHGROVE = null;
        BNL_LOG_NIBBLETWIG = null;
        BNL_LOG_WEEDWOOD = null;
        BNL_WEEDWOOD = null;
        BNL_LEAVES_HEARTHGROVE = null;
        BNL_LEAVES_NIBBLETWIG = null;
        BNL_LEAVES_WEEDWOOD = null;
        BNL_SOFT_RUSH = null;
    }
}

