/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.mods;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.CompatHelper;
import nmd.primal.core.common.init.ModConfig;

public class FaunaCompat {
    public static final String MOD_ID = "familiarfauna";
    @GameRegistry.ObjectHolder(value="familiarfauna:familiarfauna.deer")
    private static final EntityEntry FAUNA_DEER;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new FaunaCompat());
    }

    @Optional.Method(modid="familiarfauna")
    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public void onEntityDrop(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_130014_f_().field_72995_K) {
            return;
        }
        if (ModConfig.Compatibility.FAMILIAR_FAUNA_DEER_DROPS && CompatHelper.isModEntityMatch((Entity)entity, MOD_ID, FAUNA_DEER)) {
            List drops = event.getDrops();
            Item animal_fat = PrimalAPI.Items.ANIMAL_FAT;
            boolean pelt_drops = ModConfig.Survival.HARD_LEATHER && !entity.func_70631_g_();
            boolean lard_drops = ModConfig.Survival.DROPS_EXTRA_ANIMAL_STUFF;
            if (pelt_drops && PrimalCore.RANDOM.nextFloat() < 0.75f) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(PrimalAPI.Items.PELT_DEER, 1));
            }
            if (lard_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(animal_fat, PrimalCore.RANDOM.nextInt(5)));
            }
        }
    }

    static {
        PrimalAPI.logger(1, "Mod Integration: familiarfauna");
        FAUNA_DEER = null;
    }
}

