/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.mods;

import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.api.interfaces.ITorch;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.inworld.FireSource;

public class PTCompat {
    public static final String MOD_ID = "primal_tech";
    @GameRegistry.ObjectHolder(value="primal_tech:fibre_torch")
    private static final Block PT_UNLIT_TORCH;
    @GameRegistry.ObjectHolder(value="primal_tech:fibre_torch_lit")
    private static final Block PT_LIT_TORCH;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new PTCompat());
    }

    @Optional.Method(modid="primal_tech")
    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=false)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EnumHand hand;
        if (ModConfig.Compatibility.PTECH_TORCH_INTEGRATION && PT_LIT_TORCH != null && PT_UNLIT_TORCH != null && (hand = event.getHand()) == EnumHand.MAIN_HAND) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            EnumFacing face = event.getFace();
            EntityPlayer player = event.getEntityPlayer();
            ItemStack stack = event.getItemStack();
            if (stack.func_77973_b() == Item.func_150898_a((Block)PT_UNLIT_TORCH) && block instanceof ILit && ((ILit)block).isLit((IBlockAccess)world, pos, state) && this.liteHeldTorch(player, stack)) {
                player.func_184609_a(hand);
                event.setCanceled(true);
            } else if (block == PT_LIT_TORCH) {
                if (!(stack.func_77969_a(new ItemStack(PT_LIT_TORCH)) || stack.func_77969_a(new ItemStack(PT_UNLIT_TORCH)) || stack.func_77973_b() instanceof ITorch)) {
                    this.extinguish(world, pos, state, face, (EntityLivingBase)player);
                    player.func_184609_a(hand);
                    event.setCanceled(true);
                }
            } else if (block == PT_UNLIT_TORCH && FireSource.useSource(world, pos, face, player, hand, stack, (float)event.getHitVec().field_72450_a, (float)event.getHitVec().field_72448_b, (float)event.getHitVec().field_72449_c)) {
                this.lite(world, pos, state, face, (EntityLivingBase)player);
                player.func_184609_a(hand);
                event.setCanceled(true);
            }
        }
    }

    private boolean liteHeldTorch(EntityPlayer player, ItemStack stack) {
        EnumHand hand = EnumHand.MAIN_HAND;
        ItemStack lit = new ItemStack(PT_LIT_TORCH);
        if (!stack.func_190926_b()) {
            if (!player.field_70170_p.field_72995_K) {
                FXHelper.soundFireAmbient(player.field_70170_p, player.func_180425_c(), 0.5f);
                stack.func_190918_g(1);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)lit);
            }
            return true;
        }
        return false;
    }

    private boolean lite(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_180501_a(pos, PT_LIT_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, state.func_177229_b((IProperty)BlockTorch.field_176596_a)), 2)) {
            FireHelper.makeSmoke(world, pos, 16);
            world.func_184133_a(null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        return false;
    }

    private boolean extinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_180501_a(pos, PT_UNLIT_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, state.func_177229_b((IProperty)BlockTorch.field_176596_a)), 2)) {
            FireHelper.makeSmoke(world, pos, 16);
            world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        return false;
    }

    static {
        PrimalAPI.logger(1, "Mod Integration: primal_tech");
        PT_UNLIT_TORCH = null;
        PT_LIT_TORCH = null;
    }
}

