/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.vanilla;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ITorch;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.init.ModConfig;

public class VanillaTorchItem
extends ItemBlock
implements ITorch {
    private final int douse_chance;

    public VanillaTorchItem(Block block) {
        super(block);
        this.setRegistryName("minecraft", "torch");
        this.douse_chance = ModConfig.Lighting.TORCH_DOUSE_CHANCE;
    }

    @Override
    public ItemStack getLitTorch(ItemStack stack) {
        return new ItemStack(PrimalAPI.Blocks.TORCH_WOOD);
    }

    @Override
    public ItemStack getUnlitTorch(ItemStack stack) {
        return new ItemStack(PrimalAPI.Blocks.TORCH_WOOD);
    }

    @Override
    public boolean isTorchLit(ItemStack stack) {
        return true;
    }

    public void douseTorchInventory(World world, EntityPlayer player, int slot, ItemStack lit, ItemStack unlit) {
        FXHelper.soundFireExtinguish(world, player.func_180425_c(), 1.0f);
        unlit.func_190920_e(lit.func_190916_E());
        if (player.func_184592_cb() == lit) {
            player.field_71071_by.field_184439_c.set(slot, (Object)unlit);
        } else {
            player.field_71071_by.func_70299_a(slot, unlit);
        }
    }

    public void douseTorchEntity(World world, EntityItem torch, ItemStack lit, ItemStack unlit) {
        FXHelper.soundFireExtinguish(world, torch.func_180425_c(), 1.0f);
        unlit.func_190920_e(lit.func_190916_E());
        torch.func_92058_a(unlit);
    }

    public void douseTorchEntity(EntityItem torch) {
        this.douseTorchEntity(torch.func_130014_f_(), torch, new ItemStack(Blocks.field_150478_aa), this.getUnlitTorch(torch.func_92059_d()));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        EntityPlayer player;
        if (!world.field_72995_K && PrimalAPI.randomCheckFail(this.douse_chance) && entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).func_184812_l_() && !player.func_175149_v() && player.func_70086_ai() < 300) {
            this.douseTorchInventory(world, player, slot, stack, this.getUnlitTorch(stack));
        }
    }

    public boolean onEntityItemUpdate(EntityItem item) {
        if (!item.field_70170_p.field_72995_K && PrimalAPI.randomCheckFail(this.douse_chance) && item.func_70090_H()) {
            this.douseTorchEntity(item.func_130014_f_(), item, item.func_92059_d(), this.getUnlitTorch(item.func_92059_d()));
        }
        return super.onEntityItemUpdate(item);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!stack.func_190926_b()) {
            if (!block.func_176200_f((IBlockAccess)world, pos)) {
                pos = pos.func_177972_a(facing);
            }
            if (!world.func_180495_p(pos).func_185904_a().func_76224_d() && player.func_175151_a(pos, facing, stack) && world.func_190527_a(this.field_150939_a, pos, false, facing, (Entity)null)) {
                int i = this.func_77647_b(stack.func_77960_j());
                IBlockState place_state = this.field_150939_a.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
                if (this.placeBlockAt(stack, player, world, pos, facing, hitX, hitY, hitZ, place_state)) {
                    place_state = world.func_180495_p(pos);
                    SoundType soundtype = place_state.func_177230_c().getSoundType(place_state, world, pos, (Entity)player);
                    world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    stack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }
}

