/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.entities;

import net.minecraft.entity.item.EntityBoat;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;
import nmd.primal.core.api.PrimalAPI;

public class EntityBoatWood
extends EntityBoat {
    private static final DataParameter<Integer> BOAT_TYPE = EntityDataManager.func_187226_a(EntityBoatWood.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityBoatWood(World world) {
        super(world);
    }

    public EntityBoatWood(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BOAT_TYPE, (Object)Type.IRONWOOD.ordinal());
        super.func_70088_a();
    }

    public Type getType() {
        return Type.byId((Integer)this.field_70180_af.func_187225_a(BOAT_TYPE));
    }

    public void setType(Type boatType) {
        this.field_70180_af.func_187227_b(BOAT_TYPE, (Object)boatType.ordinal());
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74778_a("Type", this.getType().getName());
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("Type", 8)) {
            this.setType(Type.getTypeFromString(compound.func_74779_i("Type")));
        }
    }

    public Item func_184455_j() {
        switch (this.getType()) {
            default: {
                return PrimalAPI.Items.BOAT_IRONWOOD;
            }
            case YEW: {
                return PrimalAPI.Items.BOAT_YEW;
            }
            case LACQUER: 
        }
        return PrimalAPI.Items.BOAT_LACQUER;
    }

    public static enum Type {
        IRONWOOD("ironwood"),
        YEW("yew"),
        LACQUER("lacquer");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public int getMetadata() {
            return this.ordinal();
        }

        public static Type byId(int id) {
            if (id < 0 || id >= Type.values().length) {
                id = 0;
            }
            return Type.values()[id];
        }

        public static Type getTypeFromString(String nameIn) {
            for (int i = 0; i < Type.values().length; ++i) {
                if (!Type.values()[i].getName().equals(nameIn)) continue;
                return Type.values()[i];
            }
            return Type.values()[0];
        }
    }
}

