/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.entities.projectiles;

import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.BlockFluidBase;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.common.blocks.lighting.Torch;
import nmd.primal.core.common.entities.projectiles.AbstractEntityArrow;
import nmd.primal.core.common.fluids.custom.BitumenFluid;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.items.projectiles.Arrow;

public class TypeArrow
extends AbstractEntityArrow {
    private int duration = 200;
    private static final DataParameter<String> TYPE = EntityDataManager.func_187226_a(TypeArrow.class, (DataSerializer)DataSerializers.field_187194_d);

    public TypeArrow(World world) {
        super(world);
        this.attributes();
    }

    public TypeArrow(World world, EntityLivingBase shooter) {
        super(world, shooter);
        this.attributes();
    }

    public TypeArrow(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.attributes();
    }

    @Override
    public void attributes() {
        this.field_70178_ae = false;
    }

    public boolean func_70027_ad() {
        return this.matchType(Arrow.Type.TORCH_WOOD, Arrow.Type.TORCH_NETHER);
    }

    @Override
    public void func_70071_h_() {
        block7: {
            super.func_70071_h_();
            if (!this.func_70027_ad() || !PrimalAPI.randomCheck(ModConfig.Flammability.TORCH_ARROW_FIRE) || !this.field_70170_p.func_82736_K().func_82766_b("doFireTick")) break block7;
            int i = RANDOM.nextInt(3);
            if (i > 0) {
                BlockPos blockpos = this.func_180425_c();
                for (int j = 0; j < i; ++j) {
                    if ((blockpos = blockpos.func_177982_a(RANDOM.nextInt(3) - 1, 1, RANDOM.nextInt(3) - 1)).func_177956_o() >= 0 && blockpos.func_177956_o() < this.field_70170_p.func_72800_K() && !this.field_70170_p.func_175667_e(blockpos)) {
                        return;
                    }
                    IBlockState state = this.field_70170_p.func_180495_p(blockpos);
                    Material material = state.func_185904_a();
                    if (material == Material.field_151579_a) {
                        if (!FireHelper.isSurroundingBlockFlammable(this.field_70170_p, blockpos)) continue;
                        this.field_70170_p.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                        this.func_70106_y();
                        return;
                    }
                    if (!material.func_76230_c()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos1 = this.func_180425_c().func_177982_a(RANDOM.nextInt(3) - 1, 0, RANDOM.nextInt(3) - 1);
                    if (blockpos1.func_177956_o() >= 0 && blockpos1.func_177956_o() < 256 && !this.field_70170_p.func_175667_e(blockpos1)) {
                        return;
                    }
                    if (!this.field_70170_p.func_175623_d(blockpos1.func_177984_a()) || !FireHelper.getCanBlockBurn(this.field_70170_p, blockpos1)) continue;
                    this.field_70170_p.func_175656_a(blockpos1.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                    this.func_70106_y();
                }
            }
        }
    }

    protected void func_184549_a(RayTraceResult result) {
        BlockPos arrow_pos = this.func_180425_c();
        BlockPos block_pos = result.func_178782_a();
        if (!this.field_70170_p.field_72995_K) {
            Entity entity = result.field_72308_g;
            EnumFacing facing = result.field_178784_b;
            if (this.func_70090_H() && this.matchType(Arrow.Type.TORCH_WOOD, Arrow.Type.TORCH_NETHER, Arrow.Type.TORCH_REDSTONE, Arrow.Type.WATER, Arrow.Type.PARAFFIN, Arrow.Type.BITUMEN)) {
                this.dropArrow();
            } else if (this.isTorchArrow() && entity == null && this.getTorchBlock() != null && facing != EnumFacing.DOWN) {
                IBlockState torch_state;
                BlockPos torch_pos = block_pos.func_177972_a(facing);
                IBlockState block_state = this.field_70170_p.func_180495_p(block_pos);
                IBlockState iBlockState = torch_state = this.func_70027_ad() ? this.getTorchBlock().func_177226_a((IProperty)Torch.field_176596_a, (Comparable)facing).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true)) : this.getTorchBlock().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing);
                if (block_state.func_185904_a() != Material.field_151579_a && this.field_70170_p.func_175623_d(torch_pos) && Torch.canPlaceTorch(this.field_70170_p, block_pos, facing)) {
                    this.field_70170_p.func_180501_a(torch_pos, torch_state, 2);
                    if (this.matchType(Arrow.Type.TORCH_REDSTONE)) {
                        FXHelper.makeParticles((WorldServer)this.field_70170_p, arrow_pos, EnumParticleTypes.REDSTONE, RANDOM.nextInt(6, 8), 0, 0.0, 0.9f, 0.0, 0.0);
                    } else {
                        FXHelper.makeParticles((WorldServer)this.field_70170_p, arrow_pos, EnumParticleTypes.SMOKE_LARGE, RANDOM.nextInt(6, 8), 0, 0.0, 0.9f, 0.0, 0.0);
                    }
                    this.func_70106_y();
                }
            } else if (this.matchType(Arrow.Type.PARAFFIN)) {
                FireHelper.explode(this.field_70170_p, this.func_180425_c(), (Entity)this, RANDOM.nextInt(2, 4), 1.0f, true, true);
            } else if (this.matchType(Arrow.Type.BITUMEN)) {
                if (result.field_178784_b != null && !this.field_70170_p.func_180495_p(arrow_pos).func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, arrow_pos)) {
                    arrow_pos = arrow_pos.func_177972_a(result.field_178784_b);
                }
                BitumenFluid fluid = PrimalAPI.Fluids.BITUMEN_BOILING;
                Block fluidBlock = fluid.getBlock();
                IBlockState fluidState = fluidBlock.func_176223_P().func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(0));
                IBlockState state = this.field_70170_p.func_180495_p(arrow_pos);
                if (this.field_70170_p.func_175623_d(arrow_pos) || state.func_185904_a() == Material.field_151581_o || state.func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, arrow_pos)) {
                    this.field_70170_p.func_180501_a(arrow_pos, fluidState, 3);
                    this.field_70170_p.func_184138_a(arrow_pos, state, state, 3);
                } else {
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_184550_j()));
                }
                this.func_70106_y();
            } else if (this.matchType(Arrow.Type.WATER)) {
                this.func_184185_a(SoundEvents.field_187825_fO, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                FXHelper.makeParticles((WorldServer)this.field_70170_p, arrow_pos, EnumParticleTypes.CLOUD, RANDOM.nextInt(4, 8), 0, 0.0, 0.9f, 0.0, 0.0);
                if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                    for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)arrow_pos.func_177982_a(-2, -2, -2), (BlockPos)arrow_pos.func_177982_a(2, 2, 2))) {
                        IBlockState state = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos);
                        Block block = state.func_177230_c();
                        if (block == Blocks.field_150478_aa) {
                            this.field_70170_p.func_180501_a((BlockPos)blockpos$mutableblockpos, PrimalAPI.Blocks.TORCH_WOOD.func_176223_P().func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockTorch.field_176596_a, state.func_177229_b((IProperty)BlockTorch.field_176596_a)), 3);
                            this.field_70170_p.func_175685_c((BlockPos)blockpos$mutableblockpos, block, false);
                            continue;
                        }
                        if (block == Blocks.field_150480_ab) {
                            this.field_70170_p.func_175698_g((BlockPos)blockpos$mutableblockpos);
                            continue;
                        }
                        if (block instanceof ILit && ((Boolean)state.func_177229_b((IProperty)ILit.LIT)).booleanValue() && ((ILit)block).canExtinguish(this.field_70170_p, (BlockPos)blockpos$mutableblockpos, state, null, null)) {
                            ((ILit)block).doExtinguish(this.field_70170_p, (BlockPos)blockpos$mutableblockpos, state, EnumFacing.UP, null);
                            continue;
                        }
                        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                            this.field_70170_p.func_180501_a((BlockPos)blockpos$mutableblockpos, Blocks.field_150348_b.func_176223_P(), 3);
                            continue;
                        }
                        if (block == PrimalAPI.Fluids.MAGMA.getBlock()) {
                            this.field_70170_p.func_180501_a((BlockPos)blockpos$mutableblockpos, PrimalAPI.Blocks.SARSEN_STONE.func_176223_P(), 3);
                            continue;
                        }
                        if (block != PrimalAPI.Fluids.OVIS_ATRE_MILK.getBlock()) continue;
                        this.field_70170_p.func_180501_a((BlockPos)blockpos$mutableblockpos, PrimalAPI.Blocks.DESICCATED_STONE.func_176223_P(), 3);
                    }
                }
                FireHelper.applyWater((Entity)this);
                this.func_70106_y();
            }
        }
        super.func_184549_a(result);
        if (!this.field_70170_p.field_72995_K && this.field_70254_i && this.matchType(Arrow.Type.TORCH_WOOD, Arrow.Type.TORCH_NETHER)) {
            IBlockState block_state = this.field_70170_p.func_180495_p(block_pos);
            if (block_state.func_177230_c() instanceof ILit && !((Boolean)block_state.func_177229_b((IProperty)ILit.LIT)).booleanValue()) {
                FXHelper.makeParticles((WorldServer)this.field_70170_p, arrow_pos, EnumParticleTypes.SMOKE_LARGE, RANDOM.nextInt(8, 12), 0, 0.0, 0.75, 0.0, 0.0);
                this.func_184185_a(SoundEvents.field_187643_bs, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.field_70170_p.func_180501_a(block_pos, block_state.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true)), 3);
                this.field_70170_p.func_175685_c(block_pos, block_state.func_177230_c(), false);
            }
            this.func_70106_y();
        }
    }

    protected void func_184548_a(EntityLivingBase living) {
        super.func_184548_a(living);
        if (this.func_70027_ad()) {
            living.func_70015_d(RANDOM.nextInt(2, 10));
        }
    }

    private IBlockState getTorchBlock() {
        return this.matchType(Arrow.Type.TORCH_WOOD) ? PrimalAPI.Blocks.TORCH_WOOD.func_176223_P() : (this.matchType(Arrow.Type.TORCH_NETHER) ? PrimalAPI.Blocks.TORCH_NETHER.func_176223_P() : (this.matchType(Arrow.Type.TORCH_REDSTONE) ? Blocks.field_150429_aA.func_176223_P() : null));
    }

    private boolean isTorchArrow() {
        return this.matchType(Arrow.Type.TORCH_WOOD, Arrow.Type.TORCH_NETHER, Arrow.Type.TORCH_REDSTONE);
    }

    private void doWaterDrop() {
        if (this.func_70090_H() && this.matchType(Arrow.Type.TORCH_WOOD, Arrow.Type.TORCH_NETHER, Arrow.Type.TORCH_REDSTONE, Arrow.Type.WATER, Arrow.Type.PARAFFIN, Arrow.Type.BITUMEN)) {
            this.dropArrow();
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)"quartz");
    }

    public double func_70242_d() {
        return Arrow.Type.byName(this.getType()).getDamage();
    }

    @Override
    protected ItemStack func_184550_j() {
        switch (this.getType()) {
            case "ironwood": {
                return new ItemStack(PrimalAPI.Items.ARROW_IRONWOOD);
            }
            case "torch_wood": {
                return new ItemStack(PrimalAPI.Items.ARROW_TORCH_WOOD);
            }
            case "torch_nether": {
                return new ItemStack(PrimalAPI.Items.ARROW_TORCH_NETHER);
            }
            case "torch_redstone": {
                return new ItemStack(PrimalAPI.Items.ARROW_TORCH_REDSTONE);
            }
            case "water": {
                return new ItemStack(PrimalAPI.Items.ARROW_WATER);
            }
            case "paraffin": {
                return new ItemStack(PrimalAPI.Items.ARROW_PARAFFIN);
            }
            case "bitumen": {
                return new ItemStack(PrimalAPI.Items.ARROW_BITUMEN);
            }
        }
        return new ItemStack(PrimalAPI.Items.ARROW_QUARTZ);
    }

    public String getType() {
        return (String)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setType(String type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type);
    }

    public boolean matchType(Arrow.Type ... types) {
        for (Arrow.Type type : types) {
            if (!this.getType().equals(type.func_176610_l())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(compound.func_74779_i("type"));
        if (compound.func_74764_b("Duration")) {
            this.duration = compound.func_74762_e("Duration");
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("type", this.getType());
        compound.func_74768_a("Duration", this.duration);
    }
}

