/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.entities.projectiles;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.entities.projectiles.TypeArrow;
import nmd.primal.core.common.fluids.custom.BitumenFluid;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.items.projectiles.BottleSplash;

public class TypeBottle
extends EntityThrowable {
    private static final DataParameter<String> TYPE = EntityDataManager.func_187226_a(TypeArrow.class, (DataSerializer)DataSerializers.field_187194_d);

    public TypeBottle(World world) {
        super(world);
    }

    public TypeBottle(World world, EntityLivingBase thrower, ItemStack potionDamageIn) {
        super(world, thrower);
    }

    public TypeBottle(World worldIn, double x, double y, double z, ItemStack potionDamageIn) {
        super(worldIn, x, y, z);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            BlockPos pos = this.func_180425_c();
            if (this.func_70090_H()) {
                this.dropBottle();
            } else if (this.matchType(BottleSplash.Type.PARAFFIN)) {
                FireHelper.explode(this.field_70170_p, pos, null, PrimalCore.RANDOM.nextInt(2, 5), 1.0f, true, false);
                this.func_70106_y();
            } else if (this.matchType(BottleSplash.Type.BITUMEN)) {
                if (result.field_178784_b != null && !this.field_70170_p.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos)) {
                    pos = pos.func_177972_a(result.field_178784_b);
                }
                BitumenFluid fluid = PrimalAPI.Fluids.BITUMEN_BOILING;
                Block fluidBlock = fluid.getBlock();
                IBlockState fluidState = fluidBlock.func_176223_P().func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(0));
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                if (this.field_70170_p.func_175623_d(pos) || state.func_185904_a() == Material.field_151581_o || state.func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos)) {
                    this.field_70170_p.func_180501_a(pos, fluidState, 3);
                    this.field_70170_p.func_184138_a(pos, state, state, 3);
                } else {
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getBottleStack()));
                }
                this.func_70106_y();
            }
        }
    }

    public void dropBottle() {
        this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getBottleStack()));
        this.func_70106_y();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)"paraffin");
    }

    protected float func_70185_h() {
        return BottleSplash.Type.byName(this.getType()).getGravity();
    }

    public ItemStack getBottleStack() {
        switch (this.getType()) {
            case "bitumen": {
                return new ItemStack(PrimalAPI.Items.BOTTLE_BITUMEN);
            }
        }
        return new ItemStack(PrimalAPI.Items.BOTTLE_PARAFFIN);
    }

    public String getType() {
        return (String)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setType(String type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type);
    }

    public boolean matchType(BottleSplash.Type ... types) {
        for (BottleSplash.Type type : types) {
            if (!this.getType().equals(type.func_176610_l())) continue;
            return true;
        }
        return false;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(compound.func_74779_i("type"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("type", this.getType());
    }
}

