/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.events;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.events.CauldronRecipeEvent;
import nmd.primal.core.api.interfaces.crafting.IToolHandler;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.ores.AncientIce;
import nmd.primal.core.common.recipes.tile.CauldronRecipe;
import nmd.primal.core.common.tiles.machines.TileCauldron;

@Mod.EventBusSubscriber
public final class CraftingEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onItemCrafting(PlayerEvent.ItemCraftedEvent event) {
        EntityPlayer player = event.player;
        ItemStack result_stack = event.crafting;
        for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
            SoundEvent sound;
            ItemStack input_stack = event.craftMatrix.func_70301_a(i);
            if (input_stack.func_190926_b()) continue;
            Item input_item = input_stack.func_77973_b();
            if (input_item instanceof IToolHandler && input_stack.func_185136_b(result_stack)) {
                event.craftMatrix.func_70298_a(i, 1);
            }
            if (!(input_item instanceof IToolHandler) || (sound = ((IToolHandler)input_item).getToolType().getToolSound()) == null) continue;
            player.func_130014_f_().func_184133_a((EntityPlayer)null, player.func_180425_c(), sound, SoundCategory.AMBIENT, 0.2f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCauldronRecipe(CauldronRecipeEvent.Pre event) {
        World world = event.getWorld();
        TileCauldron tile = event.getTile();
        CauldronRecipe recipe = event.getRecipe();
        String name = recipe.getRecipeName();
        ItemStackHandler handler = tile.getOutputHandler();
        if (name.equals("primal:cauldron_ancient_ice_to_water") && PrimalAPI.randomCheck(0.035f)) {
            ItemStack loot_stack = AncientIce.getLootDrop(world);
            PrimalAPI.logger(23, "ancient ice loot: " + loot_stack.func_77977_a());
            if (!loot_stack.func_190926_b()) {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack output_slack = handler.insertItem(i, loot_stack, false);
                    if (!output_slack.func_190926_b()) continue;
                    return;
                }
            }
        }
    }

    static {
        PrimalAPI.logger(1, "Registering Crafting Events");
    }
}

