/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.events;

import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.enums.EnumArmorSet;
import nmd.primal.core.common.blocks.misc.AshLayer;
import nmd.primal.core.common.fluids.PrimalBucket;
import nmd.primal.core.common.helper.BlockHelper;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.TeleportHelper;
import nmd.primal.core.common.init.ModConfig;

@Mod.EventBusSubscriber
public final class EntityEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onEnderTeleport(EnderTeleportEvent event) {
        PrimalAPI.logger(62, "ender teleport detected");
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        for (int i = 0; i <= 2; ++i) {
            IBlockState state = world.func_180495_p(entity.func_180425_c().func_177979_c(i));
            if (!PrimalAPI.Predicates.TELEPORT_INTERDICTION.apply((Object)state)) continue;
            FXHelper.soundMagicInhibit(world, entity.func_180425_c(), 1.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onEntityDespawn(LivingSpawnEvent.AllowDespawn event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        for (int i = 0; i <= 2; ++i) {
            IBlockState state = world.func_180495_p(entity.func_180425_c().func_177979_c(i));
            if (!PrimalAPI.Predicates.DESPAWN_INTERDICTION.apply((Object)state)) continue;
            FXHelper.soundMagicInhibit(world, entity.func_180425_c(), 1.0f);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onLivingFallEvent(LivingFallEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        float distance = event.getDistance();
        if (world.field_72995_K) {
            return;
        }
        if (PlayerHelper.isArmorSlot(entity, EntityEquipmentSlot.FEET, EnumArmorSet.WOLF, EnumArmorSet.OVIS)) {
            event.setDistance(distance * 0.65f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        if (world.field_72995_K) {
            return;
        }
        if (source == DamageSource.field_76379_h && entity.field_70143_R >= 2.0f) {
            if (ModConfig.Features.ENABLE_LANDING_SAFE) {
                int adjacentZ;
                int adjacentX;
                BlockPos entity_pos = entity.func_180425_c();
                ArrayList<IBlockState> ground_states = new ArrayList<IBlockState>();
                ground_states.add(world.func_180495_p(entity_pos.func_177977_b()));
                float rmX = CommonUtils.getEntityQuadrantOnBlock(entity.field_70165_t);
                float rmZ = CommonUtils.getEntityQuadrantOnBlock(entity.field_70161_v);
                int entityX = entity_pos.func_177958_n();
                int entityY = entity_pos.func_177977_b().func_177956_o();
                int entityZ = entity_pos.func_177952_p();
                int n = (double)rmX > 0.7 ? entityX + 1 : (adjacentX = (double)rmX < 0.31 ? entityX - 1 : entityX);
                int n2 = (double)rmZ > 0.7 ? entityZ + 1 : (adjacentZ = (double)rmZ < 0.31 ? entityZ - 1 : entityZ);
                if (adjacentX != entityX || adjacentZ != entityZ) {
                    ground_states.add(world.func_180495_p(new BlockPos(adjacentX, entityY, adjacentZ)));
                }
                if (adjacentX != entityX && adjacentZ != entityZ) {
                    ground_states.add(world.func_180495_p(new BlockPos(adjacentX, entityY, entityZ)));
                    ground_states.add(world.func_180495_p(new BlockPos(entityX, entityY, adjacentZ)));
                }
                if (BlockHelper.isSafeFallBlock(ground_states)) {
                    PrimalAPI.logger(13, "safe fall", "detected blocks: " + ground_states);
                    event.setAmount(amount * 0.25f);
                    if (entity.field_70143_R > 8.0f) {
                        BlockPos fall = new BlockPos(entityX, entityY, entityZ);
                        AshLayer.spreadAsh(world, fall);
                        world.func_175655_b(fall, true);
                        if (adjacentX != entityX || adjacentZ != entityZ) {
                            fall = new BlockPos(adjacentX, entityY, adjacentZ);
                            AshLayer.spreadAsh(world, fall);
                            world.func_175655_b(fall, true);
                        }
                        if (adjacentX != entityX && adjacentZ != entityZ) {
                            fall = new BlockPos(adjacentX, entityY, entityZ);
                            AshLayer.spreadAsh(world, fall);
                            world.func_175655_b(fall, true);
                            fall = new BlockPos(entityX, entityY, adjacentZ);
                            AshLayer.spreadAsh(world, fall);
                            world.func_175655_b(fall, true);
                        }
                    }
                }
            }
            return;
        }
        if (source == DamageSource.field_76370_b || source == DamageSource.field_76372_a || entity.func_70027_ad()) {
            if (entity instanceof EntityCreeper && !entity.func_70026_G() && PrimalAPI.randomCheck(ModConfig.Monsters.BURNING_CREEPERS)) {
                ((EntityCreeper)entity).func_146079_cb();
            }
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=false)
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        if (ModConfig.Monsters.ENHANCED_ENDERMEN && entity instanceof EntityEnderman) {
            EntityEnderman ender = (EntityEnderman)entity;
            EntityLivingBase target = ender.func_70638_az();
            if (PrimalAPI.randomCheck(16) && !ender.field_70122_E) {
                for (int i = 0; i < 16 && !ender.func_184595_k(ender.field_70165_t + (Math.random() - 0.5) * 2.0, ender.field_70163_u + 0.5, ender.field_70161_v + (Math.random() - 0.5) * 2.0); ++i) {
                }
                ender.func_184185_a(SoundEvents.field_187532_aV, 1.0f, 1.0f);
                ender.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
            if (PrimalAPI.randomCheck(16) && target != null && target.field_70122_E) {
                BlockPos target_pos = target.func_180425_c();
                IBlockState roof_state = entity.func_130014_f_().func_180495_p(target_pos.func_177981_b(2));
                if (target.func_70026_G() || roof_state.func_177230_c().func_180646_a(roof_state, (IBlockAccess)world, target_pos.func_177981_b(2)) != null) {
                    TeleportHelper.teleportTargetToSelf((EntityLivingBase)ender, target, true);
                }
            }
        }
        if (entity instanceof EntityChicken && PrimalAPI.randomCheckFail(ModConfig.Monsters.CHICKEN_FEATHER_CHANCE)) {
            if (world.field_72995_K) {
                return;
            }
            EntityChicken chicken = (EntityChicken)entity;
            if (!chicken.func_70631_g_() && !chicken.func_152116_bZ()) {
                chicken.func_145779_a(Items.field_151008_G, 1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=false)
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof EntityLiving) {
            EntityLivingBase target = event.getTarget();
            EntityLiving entity = (EntityLiving)event.getEntityLiving();
            World world = entity.field_70170_p;
            if (target == null) {
                return;
            }
            if (entity.func_94060_bK() == target) {
                return;
            }
            if (entity.func_70643_av() != null) {
                return;
            }
            if (world.field_73011_w.func_186058_p() == DimensionType.NETHER) {
                if (entity instanceof EntityBlaze && PlayerHelper.isNetherCapable(target)) {
                    ((EntityBlaze)entity).func_70624_b((EntityLivingBase)null);
                    ((EntityBlaze)entity).func_70604_c((EntityLivingBase)null);
                }
                if (entity instanceof EntityGhast && PlayerHelper.isFullArmor(target, EnumArmorSet.OVIS)) {
                    ((EntityGhast)entity).func_70624_b((EntityLivingBase)null);
                    ((EntityGhast)entity).func_70604_c((EntityLivingBase)null);
                }
            }
            if (entity instanceof EntityEnderman && PlayerHelper.isVoidCapable(target)) {
                ((EntityEnderman)entity).func_70624_b((EntityLivingBase)null);
                ((EntityEnderman)entity).func_70604_c((EntityLivingBase)null);
                if (target instanceof EntityPlayerMP) {
                    ((EntityEnderman)entity).func_184203_c((EntityPlayerMP)target);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingSpawn(EntityJoinWorldEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (event.getEntity() instanceof EntityLiving) {
            EntityLiving entity = (EntityLiving)event.getEntity();
            if (ModConfig.Monsters.DISABLE_VANILLA_SQUID && entity.getClass() == EntitySquid.class) {
                event.setCanceled(true);
            } else if (ModConfig.Monsters.DISABLE_VANILLA_WOLVES && entity.getClass() == EntityWolf.class) {
                event.setCanceled(true);
            } else if (ModConfig.Monsters.SAFETY_WITHER_SKELETON && !world.field_73011_w.func_177495_o() && entity.getClass() == EntityWitherSkeleton.class) {
                event.setCanceled(true);
            } else if (ModConfig.Monsters.SAFETY_BLAZE && !world.field_73011_w.func_177495_o() && entity.getClass() == EntityBlaze.class) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=false)
    public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        ItemStack stack;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (event.getTarget() instanceof EntityCow && (stack = event.getItemStack()).func_77973_b() instanceof PrimalBucket) {
            ((PrimalBucket)stack.func_77973_b()).getMilk((EntityCow)event.getTarget(), event.getEntityPlayer(), event.getHand(), stack);
        }
    }

    static {
        PrimalAPI.logger(1, "Registering Entity Events");
    }
}

