/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.fluids;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.inworld.MagmaRecipe;

public abstract class AbstractFluidBlock
extends BlockFluidClassic {
    protected static ThreadLocalRandom RANDOM = PrimalCore.RANDOM;

    public AbstractFluidBlock(Fluid fluid, Material material) {
        super(fluid, material);
        this.func_149713_g(1);
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.WATER;
    }

    public boolean isSolidTexture() {
        return false;
    }

    public boolean doFluidMixing(World world, BlockPos pos, IBlockState state) {
        if (this == PrimalAPI.Fluids.MAGMA.getBlock()) {
            for (EnumFacing facing : EnumFacing.values()) {
                IBlockState facing_state = world.func_180495_p(pos.func_177972_a(facing));
                Material facing_material = facing_state.func_185904_a();
                int level = (Integer)state.func_177229_b((IProperty)LEVEL);
                MagmaRecipe recipe = MagmaRecipe.getRecipe(facing_state);
                if ((recipe == null || recipe.isDisabled() || !ModConfig.Fluids.ENABLE_FLUID_MIXING_RECIPES) && facing_material != Material.field_151586_h) continue;
                IBlockState output = recipe != null ? recipe.getOutput() : PrimalAPI.Blocks.SARSEN_STONE.func_176223_P();
                switch (facing) {
                    case UP: {
                        if (level == 0) {
                            if (facing_material != Material.field_151586_h) break;
                            return RecipeHelper.changeBlock(world, pos, Blocks.field_189877_df.func_176223_P(), 16);
                        }
                        return RecipeHelper.changeBlock(world, pos, output, 16);
                    }
                }
                BlockPos pos_offset = facing_state.func_177230_c() == FluidRegistry.WATER.getBlock() ? pos : pos.func_177972_a(facing);
                return RecipeHelper.changeBlock(world, pos_offset, output, 16);
            }
        }
        return false;
    }

    public void triggerMixEffects(World worldIn, BlockPos pos) {
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0 + Math.random(), d1 + 1.2, d2 + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        return !world.func_180495_p(pos).func_185904_a().func_76224_d() && super.displaceIfPossible(world, pos);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.doFluidMixing(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos) {
        super.func_189540_a(state, world, pos, block, neighborPos);
        this.doFluidMixing(world, pos, state);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.isSolidTexture() ? BlockRenderLayer.SOLID : BlockRenderLayer.TRANSLUCENT;
    }

    static enum FluidMix implements IStringSerializable
    {
        BITUMEN("bitumen", PrimalAPI.Fluids.BITUMEN, PrimalAPI.Blocks.SARSEN_STONE.func_176223_P()),
        BITUMEN_BOILING("bitumen_boiling", PrimalAPI.Fluids.BITUMEN_BOILING, PrimalAPI.Blocks.FERRO_STONE.func_176223_P()),
        ATRE_MILK("atre_milk", PrimalAPI.Fluids.OVIS_ATRE_MILK, PrimalAPI.Blocks.SCORIA_STONE.func_176223_P());

        private final String name;
        private final Fluid fluid;
        private final IBlockState output;

        private FluidMix(String name, Fluid fluid, IBlockState output) {
            this.name = name;
            this.fluid = fluid;
            this.output = output;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public IBlockState getOutput() {
            return this.output;
        }
    }
}

