/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.fluids;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.fluids.AbstractFluidBlock;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.helper.checks.MaterialMultiplexer;

public class Magma
extends AbstractFluidBlock {
    public Magma(Fluid fluid, Material material) {
        super(fluid, material);
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.LAVA;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (PrimalAPI.randomCheck(6) && world.func_175727_C(pos.func_177984_a())) {
            RecipeHelper.changeBlock(world, pos, PrimalAPI.Blocks.SARSEN_STONE.func_176223_P(), 16);
        }
    }

    @Override
    public boolean isSolidTexture() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        Material material = state.func_185904_a();
        if (MaterialMultiplexer.forMaterial(new Material[]{PrimalAPI.BlockMaterials.SMOKE, PrimalAPI.BlockMaterials.BITUMEN}).apply(state)) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
        if (material == Material.field_151587_i) {
            return new Vec3d((double)0.6f, (double)0.1f, 0.0);
        }
        return super.getFogColor(world, pos, state, entity, originalColor, partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        Material material;
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && !world.func_180495_p(pos.func_177984_a()).func_185914_p()) {
            if (rand.nextInt(100) == 0) {
                double d8 = d0 + (double)rand.nextFloat();
                double d4 = d1 + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72337_e;
                double d6 = d2 + (double)rand.nextFloat();
                world.func_175688_a(EnumParticleTypes.LAVA, d8, d4, d6, 0.0, 0.0, 0.0, new int[0]);
                world.func_184134_a(d8, d4, d6, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
            if (rand.nextInt(200) == 0) {
                world.func_184134_a(d0, d1, d2, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        }
        if (rand.nextInt(10) == 0 && world.func_180495_p(pos.func_177977_b()).func_185896_q() && !(material = world.func_180495_p(pos.func_177979_c(2)).func_185904_a()).func_76230_c() && !material.func_76224_d()) {
            double d3 = d0 + (double)rand.nextFloat();
            double d5 = d1 - 1.05;
            double d7 = d2 + (double)rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.DRIP_LAVA, d3, d5, d7, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing face) {
        return false;
    }
}

