/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.fluids;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFireProof;
import nmd.primal.core.api.interfaces.crafting.IDictionaryName;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.RegistryHelper;
import nmd.primal.core.common.init.ModConfig;

public class PrimalBucket
extends UniversalBucket
implements IFireProof<Item>,
IDictionaryName<Item> {
    private final ItemStack empty;
    private boolean is_fire_proof;
    private String[] dictionary_names;

    public PrimalBucket(Item bucket) {
        super(1000, ItemStack.field_190927_a, true);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.empty = new ItemStack((Item)(bucket != null ? bucket : this), 1, 0);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Fluid", (NBTBase)new NBTTagCompound());
        this.empty.func_77982_d(nbt);
    }

    public PrimalBucket() {
        this(null);
    }

    @Override
    public Item setDictionaryNames(String ... strings) {
        this.dictionary_names = strings;
        return this;
    }

    @Override
    public String[] getDictionaryNames() {
        return this.dictionary_names;
    }

    @Override
    public void registerDictionaryNames() {
        for (String name : this.getDictionaryNames()) {
            RegistryHelper.registerDictionaryNames(new ItemStack((Item)this), name);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (this.is_fire_proof) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_74838_a((String)"tooltip.info.primal.abstract_fire_proof"));
        } else if (ModConfig.Fluids.BUCKETS_PICKUP_HOT_FLUIDS) {
            tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"tooltip.info.primal.abstract_fire_unsafe"));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return new FluidBucketHandler(stack, this.getCapacity());
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.hasFluid(stack) ? 1 : 16;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.getEmptyBucket(stack).func_190926_b();
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        return this.hasContainerItem(stack) ? this.getEmptyBucket(stack).func_77946_l() : super.getContainerItem(stack);
    }

    @Nullable
    public FluidStack getFluid(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("Fluid"));
    }

    public boolean hasFluid(ItemStack stack) {
        return this.getFluid(stack) != null;
    }

    public ItemStack getEmptyBucket(ItemStack stack) {
        return this.empty;
    }

    public ItemStack getEmptyBucket() {
        return this.empty;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        FluidStack containedFluid = this.getFluid(stack);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult target = this.func_77621_a(world, player, true);
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        BlockPos pos = target.func_178782_a();
        if (containedFluid != null) {
            ActionResult result = super.func_77659_a(world, player, hand);
            if (result.func_188397_a() == EnumActionResult.SUCCESS) {
                world.func_184133_a(null, pos, containedFluid.getFluid().getEmptySound(containedFluid), SoundCategory.BLOCKS, 1.0f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
            }
            return result;
        }
        ActionResult use = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)stack, (RayTraceResult)target);
        if (use != null) {
            return use;
        }
        if (world.func_175660_a(player, pos) && player.func_175151_a(pos, target.field_178784_b, stack)) {
            FluidStack filledFluid;
            ItemStack singleBucket = stack.func_77946_l();
            singleBucket.func_190920_e(1);
            FluidActionResult filledResult = FluidUtil.tryPickUpFluid((ItemStack)singleBucket, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b);
            if (filledResult.isSuccess() && (filledFluid = this.getFluid(filledResult.getResult())) != null) {
                world.func_184133_a(null, pos, filledFluid.getFluid().getEmptySound(filledFluid), SoundCategory.BLOCKS, 1.0f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
                ItemStack filledBucket = filledResult.result;
                if (player.field_71075_bZ.field_75098_d) {
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)filledBucket);
                }
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)filledBucket);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        String unlocalizedName = this.getEmptyBucket(stack).func_77977_a();
        if (fluidStack == null) {
            return I18n.func_74838_a((String)(unlocalizedName + ".name")).trim();
        }
        return I18n.func_74837_a((String)(this.getEmptyBucket(stack).func_77977_a() + ".filled.name"), (Object[])new Object[]{fluidStack.getFluid().getRarity((FluidStack)fluidStack).field_77937_e + fluidStack.getLocalizedName() + TextFormatting.WHITE});
    }

    public void func_150895_a(@Nullable CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)this.empty);
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                ItemStack filled;
                if (fluid.getName().equals("milk") || (filled = this.getBucket(fluid)).func_190926_b()) continue;
                subItems.add((Object)filled);
            }
        }
    }

    public ItemStack getBucket(Fluid fluid) {
        ItemStack bucket = new ItemStack((Item)this, 1, 0);
        FluidStack bucket_fluid = new FluidStack(fluid, this.getCapacity());
        IFluidHandlerItem handler = (IFluidHandlerItem)bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (handler != null && handler.fill(bucket_fluid, true) == bucket_fluid.amount) {
            return handler.getContainer();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getMilkBucket() {
        if (this == PrimalAPI.Items.BUCKET_CLAY) {
            return new ItemStack(PrimalAPI.Items.BUCKET_CLAY_MILK);
        }
        if (this == PrimalAPI.Items.BUCKET_TERRA) {
            return new ItemStack(PrimalAPI.Items.BUCKET_TERRA_MILK);
        }
        if (this == PrimalAPI.Items.BUCKET_CINIS) {
            return new ItemStack(PrimalAPI.Items.BUCKET_CINIS_MILK);
        }
        return ItemStack.field_190927_a;
    }

    public boolean getMilk(EntityCow cow, EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (cow.func_70089_S() && !cow.func_70631_g_() && !player.field_71075_bZ.field_75098_d && this == stack.func_77973_b() && !this.hasFluid(stack)) {
            ItemStack milk = this.getMilkBucket().func_77946_l();
            cow.func_130014_f_().func_184133_a(null, cow.func_180425_c(), SoundEvents.field_187564_an, SoundCategory.BLOCKS, 1.0f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, milk);
            } else if (!player.field_71071_by.func_70441_a(milk)) {
                player.func_71019_a(milk, false);
            }
            return true;
        }
        return false;
    }

    @Override
    public PrimalBucket setFireProof(boolean is_fire_proof) {
        this.is_fire_proof = is_fire_proof;
        return this;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.is_fire_proof;
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        return this.getEntity(world, location, stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (ModConfig.Fluids.BUCKETS_PICKUP_HOT_FLUIDS) {
            FluidStack fluid;
            if (stack.func_190926_b()) {
                return;
            }
            if (this.is_fire_proof) {
                return;
            }
            if (entity.func_70026_G() || entity.func_70045_F()) {
                return;
            }
            if (PrimalAPI.randomCheck(36) && (fluid = this.getFluid(stack)) != null && fluid.getFluid().getTemperature(fluid) > 430) {
                FireHelper.doLavaDamage(entity, 4.0f);
            }
        }
    }

    private static final class FluidBucketHandler
    extends FluidHandlerItemStackSimple {
        public FluidBucketHandler(ItemStack container, int capacity) {
            super(container, capacity);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return !(!ModConfig.Fluids.BUCKETS_PICKUP_HOT_FLUIDS && fluid.getFluid().getTemperature(fluid) > 430 && !((PrimalBucket)this.container.func_77973_b()).is_fire_proof || fluid.getFluid() != FluidRegistry.WATER && fluid.getFluid() != FluidRegistry.LAVA && !fluid.getFluid().getName().equals("milk") && !FluidRegistry.getBucketFluids().contains(fluid.getFluid()));
        }

        @Nullable
        public FluidStack getFluid() {
            return ((PrimalBucket)this.container.func_77973_b()).getFluid(this.container);
        }

        protected void setContainerToEmpty() {
            this.container = ((PrimalBucket)this.container.func_77973_b()).getEmptyBucket(this.container).func_77946_l();
        }
    }
}

