/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.helper;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FireHelper;

public class FXHelper {
    public static void itemParticles(World world, ItemStack stack, double x, double y, double z, int iterations) {
        for (int i = 0; i < iterations; ++i) {
            world.func_175688_a(EnumParticleTypes.ITEM_CRACK, x, y, z, MathHelper.func_82716_a((Random)PrimalCore.RANDOM, (double)-0.08, (double)0.08), MathHelper.func_82716_a((Random)PrimalCore.RANDOM, (double)-0.08, (double)0.08), MathHelper.func_82716_a((Random)PrimalCore.RANDOM, (double)-0.08, (double)0.08), new int[]{Item.func_150891_b((Item)stack.func_77973_b())});
        }
    }

    public static void smokeParticles(World world, BlockPos pos, int amount) {
        FXHelper.smokeParticles(world, pos, amount, 0, 0.5, 0.5);
    }

    public static void smokeParticles(World world, BlockPos pos, int amount, int interval) {
        FXHelper.smokeParticles(world, pos, amount, interval, 0.5, 0.5);
    }

    public static void smokeParticles(World world, BlockPos pos, int amount, int interval, double y_offset) {
        EnumParticleTypes particles = amount > 3 ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL;
        FXHelper.makeParticles(world, pos, particles, amount, interval, y_offset, 0.5);
    }

    public static void smokeParticles(World world, BlockPos pos, int amount, int interval, double y_offset, double speed_offset) {
        EnumParticleTypes particles = amount > 3 ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL;
        FXHelper.makeParticles(world, pos, particles, amount, interval, y_offset, speed_offset);
    }

    public static void smokeParticlesWeather(World world, BlockPos pos, int interval, int amount, double y_offset, double speed_offset) {
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151586_h) {
            FXHelper.makeParticles(world, pos, EnumParticleTypes.WATER_BUBBLE, amount, interval, y_offset, speed_offset);
        } else {
            EnumParticleTypes particles = CommonUtils.isExposedToWeather(world, pos.func_177984_a()) ? EnumParticleTypes.CLOUD : (amount > 2 ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL);
            FXHelper.makeParticles(world, pos, particles, particles == EnumParticleTypes.CLOUD ? 2 : amount, interval, y_offset, speed_offset);
        }
    }

    public static void makeBubbles(World world, BlockPos pos, int amount, int interval, double y_offset) {
        FXHelper.makeParticles(world, pos, EnumParticleTypes.WATER_BUBBLE, amount, interval, y_offset, 0.5);
    }

    public static void makeBubbles(World world, BlockPos pos, int amount, int interval, double y_offset, double speed_offset) {
        FXHelper.makeParticles(world, pos, EnumParticleTypes.WATER_BUBBLE, amount, interval, y_offset, speed_offset);
    }

    public static void makeParticles(World world, BlockPos pos, EnumParticleTypes particles, int amount, int interval, double y_offset) {
        FXHelper.makeParticles(world, pos, particles, amount, interval, y_offset, 0.5);
    }

    public static void makeParticles(World world, BlockPos pos, EnumParticleTypes particles, int amount, int interval, double y_offset, double speed_offset) {
        if (PrimalAPI.randomCheck(interval)) {
            for (int i = 0; i <= amount; ++i) {
                world.func_175688_a(particles, (double)pos.func_177958_n() + PrimalCore.RANDOM.nextDouble(), (double)pos.func_177956_o() + y_offset, (double)pos.func_177952_p() + PrimalCore.RANDOM.nextDouble(), (PrimalCore.RANDOM.nextDouble() - speed_offset) / 10.0, (PrimalCore.RANDOM.nextDouble() - speed_offset) / 10.0, (PrimalCore.RANDOM.nextDouble() - speed_offset) / 10.0, new int[0]);
            }
        }
    }

    public static void makeParticles(WorldServer world, BlockPos pos, EnumParticleTypes particles, int amount, int interval, double xOffset, double yOffset, double zOffset, double particleSpeed) {
        if (PrimalAPI.randomCheck(interval)) {
            for (int i = 0; i <= amount; ++i) {
                world.func_175739_a(particles, (double)pos.func_177958_n() + PrimalCore.RANDOM.nextDouble(0.2, 0.6), (double)pos.func_177956_o() + yOffset, (double)pos.func_177952_p() + PrimalCore.RANDOM.nextDouble(0.2, 0.6), 1, xOffset, yOffset, zOffset, particleSpeed, new int[]{0});
            }
        }
    }

    public static void drawParticleTrail(EnumParticleTypes particles, EntityLivingBase entity, BlockPos destination) {
        World world = entity.func_130014_f_();
        if (!world.field_72995_K) {
            double x = destination.func_177958_n();
            double y = destination.func_177956_o();
            double z = destination.func_177952_p();
            for (int j = 0; j < 128; ++j) {
                double d6 = (double)j / 127.0;
                float f0 = (PrimalCore.RANDOM.nextFloat() - 0.5f) * 0.2f;
                float f1 = (PrimalCore.RANDOM.nextFloat() - 0.5f) * 0.2f;
                float f2 = (PrimalCore.RANDOM.nextFloat() - 0.5f) * 0.2f;
                double d3 = x + (entity.field_70165_t - x) * d6 + (PrimalCore.RANDOM.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
                double d4 = y + (entity.field_70163_u - y) * d6 + PrimalCore.RANDOM.nextDouble() * (double)entity.field_70131_O;
                double d5 = z + (entity.field_70161_v - z) * d6 + (PrimalCore.RANDOM.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
                ((WorldServer)world).func_175739_a(particles, d3, d4, d5, 1, (double)f0, (double)f1, (double)f2, 0.0, new int[0]);
            }
        }
    }

    public static void soundFireAmbient(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, volume, 2.6f + (PrimalCore.RANDOM.nextFloat() - PrimalCore.RANDOM.nextFloat()) * 0.8f);
    }

    public static void soundFireExtinguish(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, volume, 2.6f + (PrimalCore.RANDOM.nextFloat() - PrimalCore.RANDOM.nextFloat()) * 0.8f);
    }

    public static void soundSteamHiss(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_MISC_STEAM, SoundCategory.BLOCKS, volume, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public static void soundSwish(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_FLUID_SWISH, SoundCategory.BLOCKS, volume, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public static void soundPotteryHit(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_BLOCK_POTTERY_HIT, SoundCategory.BLOCKS, volume, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public static void soundPotteryLid(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_BLOCK_POTTERY_LID, SoundCategory.BLOCKS, volume, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public static void soundPotteryBreak(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_BLOCK_POTTERY_BREAK, SoundCategory.BLOCKS, volume, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public static void soundPotteryActive(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_BLOCK_POTTERY_ACTIVE, SoundCategory.BLOCKS, volume, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public static void soundIceFreeze(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_BLOCK_ICE_FREEZE, SoundCategory.BLOCKS, volume, 2.6f + (PrimalCore.RANDOM.nextFloat() - PrimalCore.RANDOM.nextFloat()) * 0.8f);
    }

    public static void soundOoze(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_BLOCK_OOZE, SoundCategory.BLOCKS, volume, 2.6f + (PrimalCore.RANDOM.nextFloat() - PrimalCore.RANDOM.nextFloat()) * 0.8f);
    }

    public static void soundHurt(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, SoundEvents.field_187543_bD, SoundCategory.BLOCKS, volume, 1.0f);
    }

    public static void soundStringBreak(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, SoundEvents.field_187746_da, SoundCategory.BLOCKS, volume, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public static void soundStickBreak(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, SoundEvents.field_187623_cM, SoundCategory.BLOCKS, volume, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public static void soundMysteriousThud(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_MISC_PLACEMENT, SoundCategory.BLOCKS, volume, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public static void soundMagicInhibit(World world, BlockPos pos, float volume) {
        world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_EFFECT_MAGIC_INHIBIT, SoundCategory.BLOCKS, volume, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public static void fxLava(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            FXHelper.soundFireExtinguish(world, pos, 1.0f);
            FXHelper.makeParticles((WorldServer)world, pos, EnumParticleTypes.SMOKE_LARGE, PrimalCore.RANDOM.nextInt(4, 8), 0, 0.0, 0.9f, 0.0, 0.0);
            FireHelper.makeSmoke(world, pos, 0.015f);
        }
    }

    public static void fxWater(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            FXHelper.soundFireExtinguish(world, pos, 1.0f);
            FXHelper.makeParticles((WorldServer)world, pos, EnumParticleTypes.CLOUD, PrimalCore.RANDOM.nextInt(4, 8), 0, 0.0, 0.9f, 0.0, 0.0);
            FireHelper.makeSmoke(world, pos, 0.015f);
        }
    }

    public static void fxIce(World world, BlockPos pos, float volume) {
        if (!world.field_72995_K) {
            FXHelper.soundIceFreeze(world, pos, volume);
            FXHelper.makeParticles((WorldServer)world, pos, EnumParticleTypes.CLOUD, PrimalCore.RANDOM.nextInt(0, 6), 0, 0.0, 0.9f, 0.0, 0.0);
        }
    }

    public static void fxOoze(World world, BlockPos pos, float volume) {
        if (!world.field_72995_K) {
            FXHelper.soundOoze(world, pos, volume);
            FXHelper.makeParticles((WorldServer)world, pos, EnumParticleTypes.TOWN_AURA, PrimalCore.RANDOM.nextInt(0, 6), 0, 0.0, 0.9f, 0.0, 0.0);
        }
    }

    public static void fxEnvironmentDamage(EntityLivingBase entity) {
        World world = entity.func_130014_f_();
        if (!world.field_72995_K) {
            BlockPos pos = entity.func_180425_c();
            FXHelper.soundFireExtinguish(world, pos, 1.0f);
            for (int i = 0; i < PrimalCore.RANDOM.nextInt(8, 12); ++i) {
                ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)entity.func_180425_c().func_177958_n() + (double)(PrimalCore.RANDOM.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N, (double)entity.func_180425_c().func_177956_o() + (double)(PrimalCore.RANDOM.nextFloat() * entity.field_70131_O), (double)entity.func_180425_c().func_177952_p() + (double)(PrimalCore.RANDOM.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N, 1, PrimalCore.RANDOM.nextGaussian() * 0.02, PrimalCore.RANDOM.nextGaussian() * 0.02, PrimalCore.RANDOM.nextGaussian() * 0.02, 0.0, new int[]{0});
            }
        }
    }
}

