/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.helper;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.FXHelper;

public class TeleportHelper {
    public static boolean teleportTo(EntityLivingBase entity, double x, double y, double z, boolean play_sound) {
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = entity.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        entity.field_70143_R = 0.0f;
        if (flag && play_sound) {
            entity.field_70170_p.func_184148_a(null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, SoundEvents.field_187534_aX, entity.func_184176_by(), 1.0f, 1.0f);
            entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    public static boolean teleportTargetToSelf(EntityLivingBase self, EntityLivingBase target, boolean play_sound) {
        EnderTeleportEvent event = new EnderTeleportEvent(target, target.field_70165_t, target.field_70163_u, target.field_70161_v, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        for (int i = 0; i < 16 && !target.func_184595_k(self.field_70165_t + (PrimalCore.RANDOM.nextDouble() - 0.5) * 2.0, self.field_70163_u + 0.5, self.field_70161_v + (PrimalCore.RANDOM.nextDouble() - 0.5) * 2.0); ++i) {
        }
        if (play_sound) {
            target.func_130014_f_().func_184148_a(null, self.field_70165_t, self.field_70163_u, self.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        if (self instanceof EntityEnderman) {
            target.func_130014_f_().func_184148_a(null, self.field_70165_t, self.field_70163_u, self.field_70161_v, SoundEvents.field_187532_aV, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        return true;
    }

    public static boolean teleportToForced(EntityLivingBase entity, double x, double y, double z, boolean play_sound) {
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (TeleportHelper.forceTeleport(entity, event.getTargetX(), event.getTargetY(), event.getTargetZ())) {
            entity.field_70143_R = 0.0f;
            if (play_sound) {
                entity.field_70170_p.func_184148_a(null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, SoundEvents.field_187534_aX, entity.func_184176_by(), 1.0f, 1.0f);
                entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public static boolean teleportRandomly(EntityLivingBase entity, int iterations) {
        for (int i = 0; i < iterations; ++i) {
            double d2;
            double d1;
            double d0 = entity.field_70165_t + (PrimalCore.RANDOM.nextDouble() - 0.5) * 64.0;
            if (!TeleportHelper.teleportTo(entity, d0, d1 = entity.field_70163_u + (double)(PrimalCore.RANDOM.nextInt(64) - 32), d2 = entity.field_70161_v + (PrimalCore.RANDOM.nextDouble() - 0.5) * 64.0, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean teleportRandomly(EntityLivingBase entity) {
        double d0 = entity.field_70165_t + (PrimalCore.RANDOM.nextDouble() - 0.5) * 64.0;
        double d1 = entity.field_70163_u + (double)(PrimalCore.RANDOM.nextInt(64) - 32);
        double d2 = entity.field_70161_v + (PrimalCore.RANDOM.nextDouble() - 0.5) * 64.0;
        return TeleportHelper.teleportTo(entity, d0, d1, d2, true);
    }

    public static boolean teleportToEntity(EntityLivingBase entity, Entity target) {
        Vec3d vec3d = new Vec3d(entity.field_70165_t - target.field_70165_t, entity.func_174813_aQ().field_72338_b + (double)(entity.field_70131_O / 2.0f) - target.field_70163_u + (double)target.func_70047_e(), entity.field_70161_v - target.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = entity.field_70165_t + (PrimalCore.RANDOM.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = entity.field_70163_u + (double)(PrimalCore.RANDOM.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = entity.field_70161_v + (PrimalCore.RANDOM.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return TeleportHelper.teleportTo(entity, d1, d2, d3, true);
    }

    public static boolean teleportBlock(World world, BlockPos pos, Block block) {
        IBlockState iblockstate = world.func_180495_p(pos);
        if (iblockstate.func_177230_c() == block) {
            for (int i = 0; i < 1000; ++i) {
                BlockPos blockpos = pos.func_177982_a(world.field_73012_v.nextInt(16) - world.field_73012_v.nextInt(16), world.field_73012_v.nextInt(8) - world.field_73012_v.nextInt(8), world.field_73012_v.nextInt(16) - world.field_73012_v.nextInt(16));
                if (world.func_180495_p(blockpos).func_185904_a() != Material.field_151579_a) continue;
                if (world.field_72995_K) {
                    for (int j = 0; j < 128; ++j) {
                        double d0 = world.field_73012_v.nextDouble();
                        float f = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                        float f1 = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                        float f2 = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                        double d1 = (double)blockpos.func_177958_n() + (double)(pos.func_177958_n() - blockpos.func_177958_n()) * d0 + (world.field_73012_v.nextDouble() - 0.5) + 0.5;
                        double d2 = (double)blockpos.func_177956_o() + (double)(pos.func_177956_o() - blockpos.func_177956_o()) * d0 + world.field_73012_v.nextDouble() - 0.5;
                        double d3 = (double)blockpos.func_177952_p() + (double)(pos.func_177952_p() - blockpos.func_177952_p()) * d0 + (world.field_73012_v.nextDouble() - 0.5) + 0.5;
                        world.func_175688_a(EnumParticleTypes.PORTAL, d1, d2, d3, (double)f, (double)f1, (double)f2, new int[0]);
                    }
                } else {
                    world.func_180501_a(blockpos, iblockstate, 2);
                    world.func_175698_g(pos);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean forceTeleport(EntityLivingBase entity, double x, double y, double z) {
        World world = entity.field_70170_p;
        BlockPos target_pos = new BlockPos(x, y, z);
        double d0 = entity.field_70165_t;
        double d1 = entity.field_70163_u;
        double d2 = entity.field_70161_v;
        entity.field_70165_t = x;
        entity.field_70163_u = y;
        entity.field_70161_v = z;
        if (world.func_175667_e(target_pos) && world.func_175623_d(target_pos)) {
            FXHelper.drawParticleTrail(EnumParticleTypes.PORTAL, entity, new BlockPos(d0, d1, d2));
            entity.func_70634_a(x, y, z);
            if (entity instanceof EntityCreature) {
                ((EntityCreature)entity).func_70661_as().func_75499_g();
            }
            return true;
        }
        return false;
    }

    public boolean attemptTeleport(Entity entity, double x, double y, double z) {
        double d0 = entity.field_70165_t;
        double d1 = entity.field_70163_u;
        double d2 = entity.field_70161_v;
        entity.field_70165_t = x;
        entity.field_70163_u = y;
        entity.field_70161_v = z;
        boolean flag = false;
        World world = entity.field_70170_p;
        BlockPos blockpos = new BlockPos(entity);
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                entity.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                entity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (world.func_184144_a(entity, entity.func_174813_aQ()).isEmpty() && !world.func_72953_d(entity.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.func_70634_a(d0, d1, d2);
            return false;
        }
        int i = 128;
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (PrimalCore.RANDOM.nextFloat() - 0.5f) * 0.2f;
            float f1 = (PrimalCore.RANDOM.nextFloat() - 0.5f) * 0.2f;
            float f2 = (PrimalCore.RANDOM.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (entity.field_70165_t - d0) * d6 + (PrimalCore.RANDOM.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            double d4 = d1 + (entity.field_70163_u - d1) * d6 + PrimalCore.RANDOM.nextDouble() * (double)entity.field_70131_O;
            double d5 = d2 + (entity.field_70161_v - d2) * d6 + (PrimalCore.RANDOM.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        if (entity instanceof EntityCreature) {
            ((EntityCreature)entity).func_70661_as().func_75499_g();
        }
        return true;
    }

    public static BlockPos getRespawnPoint(EntityPlayer player, BlockPos origin, int min, int max, int iterations) {
        World world = player.func_130014_f_();
        BlockPos ret = origin;
        for (int tryCounter = 0; tryCounter < iterations; ++tryCounter) {
            ret = TeleportHelper.getRandomPoint(world, origin, min, max);
            int cmp = ret.func_177956_o() - world.field_73011_w.func_76557_i();
            Material check = world.func_180495_p(ret).func_185904_a();
            IBlockState state = world.func_180495_p(ret.func_177984_a());
            if (cmp >= 0 && !check.func_76224_d() && state.func_177230_c().func_181623_g()) break;
        }
        return ret;
    }

    public static BlockPos getRandomPoint(World world, BlockPos origin, int min, int max) {
        BlockPos ret = origin;
        double length = MathHelper.func_76136_a((Random)PrimalCore.RANDOM, (int)min, (int)max);
        double angle = MathHelper.func_82716_a((Random)PrimalCore.RANDOM, (double)0.0, (double)360.0);
        double customX = -Math.sin(angle) * length;
        double customZ = Math.cos(angle) * length;
        ret = ret.func_177963_a((double)MathHelper.func_76128_c((double)customX) + 0.5, 1.5, (double)MathHelper.func_76128_c((double)customZ) + 0.5);
        ret = world.func_175672_r(ret);
        return ret;
    }

    public static Integer[] getDimensions() {
        return DimensionManager.getIDs();
    }

    public static BlockPos findSpawnLocation(EntityLivingBase entity) {
        World world = entity.func_130014_f_();
        WorldInfo worldInfo = world.func_72912_H();
        if (worldInfo.func_76075_d() <= 0) {
            worldInfo.func_76056_b(world.func_181545_F() + 1);
        }
        int i = entity.func_180425_c().func_177958_n();
        int j = entity.func_180425_c().func_177952_p();
        int k = 0;
        while (world.func_184141_c(new BlockPos(i, 0, j)).func_185904_a() == Material.field_151579_a) {
            i += PrimalCore.RANDOM.nextInt(8) - PrimalCore.RANDOM.nextInt(8);
            j += PrimalCore.RANDOM.nextInt(8) - PrimalCore.RANDOM.nextInt(8);
            if (++k != 10000) continue;
        }
        return new BlockPos(i, k, j);
    }
}

