/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.helper;

import com.google.common.base.Predicate;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;
import nmd.primal.core.common.init.ModCompat;
import nmd.primal.core.common.init.ModConfig;

public class WorldHelper {
    private static final String DATA_ID_PREFIX = "primal.world.";
    public static final int BLOCK_FLAG = 18;
    public static final int XZ_OFFSET = 8;
    public static final String DATA_ID_TREE = "primal.world.tree";
    public static final String DATA_ID_OCEAN = "primal.world.ocean";
    public static final String DATA_ID_STONE = "primal.world.stone";
    public static final String DATA_ID_MUD = "primal.world.mud";
    public static final String DATA_ID_SALT = "primal.world.salt";
    public static final String DATA_ID_ORES = "primal.world.ores";
    public static Predicate<IBlockState> PREDICATE_OCEAN = BlockMultiplexer.forBlock(new Block[]{Blocks.field_150348_b, Blocks.field_150354_m, Blocks.field_150351_n});
    public static Predicate<IBlockState> PREDICATE_STONE = BlockMultiplexer.forBlock(new Block[]{Blocks.field_150348_b, Blocks.field_150354_m, Blocks.field_150322_A});
    public static Predicate<IBlockState> PREDICATE_MUD = BlockMultiplexer.forBlock(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150354_m});
    public static Predicate<IBlockState> PREDICATE_SALT = BlockMultiplexer.forBlock(new Block[]{Blocks.field_150348_b, Blocks.field_150354_m, Blocks.field_150322_A, Blocks.field_180395_cM});
    public static Predicate<IBlockState> PREDICATE_ORES = BlockMultiplexer.forBlock(Blocks.field_150348_b);
    public static final String DATA_ID_NETHER = "primal.world.nether";
    public static final String DATA_ID_NETHER_LAVA = "primal.world.nether_lava";
    public static Predicate<IBlockState> PREDICATE_NETHER = BlockMultiplexer.forBlock(Blocks.field_150424_aL, ModCompat.NEX_NETHERRACK);
    public static Predicate<IBlockState> PREDICATE_NETHER_LAVA = BlockMultiplexer.forBlock(new Block[]{Blocks.field_150424_aL, ModCompat.NEX_NETHERRACK, Blocks.field_150353_l});
    public static final String DATA_ID_END_AIR = "primal.world.end_air";
    public static final String DATA_ID_END_STONE = "primal.world.end_stone";
    public static final String DATA_ID_END_INCLUSIVE = "primal.world.end_inclusive";
    public static Predicate<IBlockState> PREDICATE_END_AIR = BlockMultiplexer.forBlock(Blocks.field_150350_a);
    public static Predicate<IBlockState> PREDICATE_END_STONE = BlockMultiplexer.forBlock(Blocks.field_150377_bs);
    public static Predicate<IBlockState> PREDICATE_END_INCLUSIVE = BlockMultiplexer.forBlock(Blocks.field_150350_a, Blocks.field_150377_bs, PrimalAPI.Blocks.NIGHT_STONE);

    public static int getChunkPos(int chunk_coordinate) {
        return chunk_coordinate * 16 + 8;
    }

    public static BlockPos getWorldGenPos(int x, int z, int y) {
        return WorldHelper.getWorldGenPos(PrimalCore.RANDOM, x, z, y);
    }

    public static BlockPos getWorldGenPos(Random rand, int x, int z, int y) {
        return new BlockPos(x + rand.nextInt(8), y, z + rand.nextInt(8));
    }

    public static boolean isInChunk(ChunkPos chunkPos, BlockPos pos) {
        int blockX = pos.func_177958_n();
        int blockZ = pos.func_177952_p();
        return blockX >= chunkPos.func_180334_c() && blockX <= chunkPos.func_180332_e() && blockZ >= chunkPos.func_180333_d() && blockZ <= chunkPos.func_180330_f();
    }

    public static boolean isValidPos(World world, BlockPos pos, ChunkPos chunkPos, int range) {
        return WorldHelper.isInChunk(chunkPos, pos) || world.func_190526_b(pos.func_177958_n() >> range, pos.func_177952_p() >> range);
    }

    public static boolean isValidPos(World world, BlockPos pos, ChunkPos chunkPos) {
        return WorldHelper.isValidPos(world, pos, chunkPos, 4);
    }

    public static void setBlockAndNotifyAdequately(World world, BlockPos pos, IBlockState state, boolean doBlockNotify) {
        if (doBlockNotify) {
            world.func_180501_a(pos, state, 3);
        } else {
            world.func_180501_a(pos, state, 18);
        }
    }

    public static IBlockState getGroundAboveSeaLevel(World world, BlockPos pos, int sealevel) {
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), sealevel, pos.func_177952_p());
        while (!world.func_175623_d(blockpos.func_177984_a())) {
            blockpos = blockpos.func_177984_a();
        }
        return world.func_180495_p(blockpos);
    }

    public static boolean worldGenOre(World world, Biome biome, ThreadLocalRandom rand, int x, int z, IBlockState state, int weight, int iteration, int y_min, int y_max, int gen_min, int gen_max, Predicate<IBlockState> predicate, BiomeDictionary.Type ... types) {
        if (PrimalAPI.randomCheck(weight) && WorldHelper.biomeHasType(biome, types)) {
            for (int k = 0; k < iteration; ++k) {
                BlockPos pos = new BlockPos(x + rand.nextInt(8), rand.nextInt(y_min, y_max), z + rand.nextInt(8));
                if (world.func_189509_E(pos)) {
                    return false;
                }
                if (!new WorldGenMinable(state, rand.nextInt(gen_min, gen_max), predicate).func_180709_b(world, (Random)rand, pos)) continue;
                PrimalAPI.logger(16, "world gen " + state.func_177230_c().func_149732_F(), biome + "@" + pos);
                return true;
            }
        }
        return false;
    }

    public static boolean hasNetherFog() {
        return ModConfig.Worldgen.NETHER_FOG_DENSITY_OVERRIDE > 0.0;
    }

    public static boolean biomeHasType(Biome biome, BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type type : types) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type)) continue;
            return true;
        }
        return false;
    }

    public static Biome[] getBiomes(BiomeDictionary.Type type) {
        PrimalAPI.logger(60, "spawn biome", "add: " + type);
        return BiomeDictionary.getBiomes((BiomeDictionary.Type)type).toArray(new Biome[0]);
    }

    public static Biome[] getBiomes(String name, boolean orTypes, BiomeDictionary.Type ... types) {
        LinkedList<Biome> list = new LinkedList<Biome>();
        List biomes = ForgeRegistries.BIOMES.getValues();
        for (Biome biome : biomes) {
            if (orTypes) {
                for (BiomeDictionary.Type t : types) {
                    if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t) || list.contains(biome)) continue;
                    list.add(biome);
                    PrimalAPI.logger(16, "  >>> Adding " + biome.func_185359_l() + " for spawning");
                }
                continue;
            }
            int count = types.length;
            int shouldAdd = 0;
            for (BiomeDictionary.Type t : types) {
                if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t)) continue;
                ++shouldAdd;
            }
            if (list.contains(biome) || shouldAdd != count) continue;
            list.add(biome);
        }
        return list.toArray(new Biome[0]);
    }

    public static boolean plantIPlantable(World world, BlockPos pos, ItemStack stack) {
        Block block;
        Block plant;
        Item item = stack.func_77973_b();
        if (item instanceof IPlantable && (plant = ((IPlantable)item).getPlant((IBlockAccess)world, pos).func_177230_c()).canSustainPlant(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)plant)) {
            return world.func_180501_a(pos, ((IPlantable)plant).getPlant((IBlockAccess)world, pos), 2);
        }
        if (item instanceof ItemBlock && (block = Block.func_149634_a((Item)item)) instanceof IPlantable) {
            Block plant2 = ((IPlantable)block).getPlant((IBlockAccess)world, pos).func_177230_c();
            if (block.canSustainPlant(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)plant2)) {
                return world.func_180501_a(pos, plant2.func_176203_a(stack.func_77960_j()), 2);
            }
        }
        return false;
    }

    public static boolean isAnimalLightLevel(EntityLivingBase entity) {
        BlockPos blockpos = new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b), MathHelper.func_76128_c((double)entity.field_70161_v));
        return entity.func_130014_f_().func_175699_k(blockpos) > 8;
    }

    public static boolean isMobLightLevel(EntityLivingBase entity) {
        BlockPos blockpos;
        World world = entity.func_130014_f_();
        if (world.func_175642_b(EnumSkyBlock.SKY, blockpos = new BlockPos(entity.field_70165_t, entity.func_174813_aQ().field_72338_b, entity.field_70161_v)) > PrimalCore.RANDOM.nextInt(32)) {
            return false;
        }
        int i = world.func_175671_l(blockpos);
        if (world.func_72911_I()) {
            int j = world.func_175657_ab();
            world.func_175692_b(10);
            i = world.func_175671_l(blockpos);
            world.func_175692_b(j);
        }
        return i <= PrimalCore.RANDOM.nextInt(8);
    }
}

