/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.init;

import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.helper.CompatHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.init.ModCompat;

public final class ModCapabilities {
    public static final int PASSIVE_TRAIT_MAX_TIMER = Integer.MAX_VALUE;
    public static final int PASSIVE_TRAIT_AMPLIFIER = 120;
    public static final int ACTIVE_TRAIT_BASE_INTERVAL = 8;

    public static void registerCapabilities() {
    }

    public static boolean addCapabilityEffect(EntityPlayer player, Potion potion, int amplifier) {
        if (!player.func_70644_a(potion)) {
            player.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE, amplifier, true, false));
            return true;
        }
        return false;
    }

    public static boolean addCapabilityEffect(EntityPlayer player, Potion potion) {
        return ModCapabilities.addCapabilityEffect(player, potion, 120);
    }

    public static boolean removeCapabilityEffect(EntityPlayer player, Potion potion) {
        PotionEffect effect = player.func_70660_b(potion);
        if (effect != null && effect.func_76458_c() == 120) {
            player.func_184589_d(potion);
            return true;
        }
        return false;
    }

    public static boolean toggleCapabilityEffect(EntityPlayer player, Potion potion, boolean condition) {
        return condition ? ModCapabilities.addCapabilityEffect(player, potion) : ModCapabilities.removeCapabilityEffect(player, potion);
    }

    public static boolean toggleCapabilityEffect(EntityPlayer player, Potion potion) {
        return ModCapabilities.toggleCapabilityEffect(player, potion, true);
    }

    public static void preInit() {
        ModCapabilities.registerCapabilities();
    }

    public static void init() {
    }

    public static void postInit() {
    }

    public static boolean hasLightProtection(EntityPlayer player) {
        return PlayerHelper.isArmorSlot((EntityLivingBase)player, EntityEquipmentSlot.HEAD, PrimalAPI.Items.GOGGLES_DARK_LENS, ModCompat.CBR_SHADES_ROUND, ModCompat.CBR_SHADES_SQUARE);
    }

    public static boolean hasSensitiveLight(EntityPlayer player) {
        World world = player.field_70170_p;
        BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v);
        if (world.field_73011_w.func_177495_o()) {
            return false;
        }
        if (player.func_70055_a(Material.field_151587_i) || player.func_70055_a(Material.field_151586_h)) {
            return false;
        }
        return world.func_175724_o(pos) > 0.2f && !CompatHelper.isCyberwareInstalled((EntityLivingBase)player, ModCompat.CBR_CYBER_EYES) && !CompatHelper.isSlotQuantum((EntityLivingBase)player, EntityEquipmentSlot.HEAD, ModCompat.IC2_QUANTUM_HELMET);
    }
}

