/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.init;

import java.util.Hashtable;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.types.ITypeWood;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.crafting.custom.RecipesKiln;
import nmd.primal.core.common.recipes.crafting.custom.RecipesRockDrop;
import nmd.primal.core.common.recipes.crafting.irecipe.RecipesAutomatic;
import nmd.primal.core.common.recipes.crafting.irecipe.RecipesCraftingTable;
import nmd.primal.core.common.recipes.crafting.irecipe.RecipesCraftingTools;
import nmd.primal.core.common.recipes.crafting.irecipe.RecipesFurnace;
import nmd.primal.core.common.recipes.inworld.FireSource;
import nmd.primal.core.common.recipes.irecipe.RecipeHandler;
import nmd.primal.core.common.recipes.irecipe.ToolCraftingRecipe;
import nmd.primal.core.common.recipes.misc.FuelValue;
import nmd.primal.core.common.recipes.misc.RepairRecipe;
import nmd.primal.core.common.recipes.tile.HibachiRecipe;

public final class ModRecipes {
    public static Hashtable<Object, ItemStack> BASIC_KERN_CRAFTING_REGISTRY = new Hashtable();

    public static void preInit() {
        ModRecipes.registerFuels();
        ModRecipes.registerRepairItems();
    }

    public static void init() {
        ModRecipes.removeRecipes();
        ModRecipes.addRecipes();
        ModRecipes.registerItemFireSources();
    }

    public static void postInit() {
        HibachiRecipe.getFurnaceRecipes();
    }

    public static void addRecipes() {
        RecipesAutomatic.addRecipes();
        ModRecipes.addBasicKernRecipes(PrimalAPI.Items.STONE_BASIN);
        RecipesRockDrop.addRockDropRecipes();
        RecipesCraftingTools.addClipperRecipes();
        RecipesCraftingTools.addGallagherStoneRecipes(ToolCraftingRecipe.EnumToolType.MALLET_STONE);
        RecipesCraftingTools.addGallagherStoneRecipes(ToolCraftingRecipe.EnumToolType.MALLET_METAL);
        RecipesCraftingTools.addGallagherMetalRecipes(ToolCraftingRecipe.EnumToolType.MALLET_METAL);
        RecipesCraftingTools.addGallagherStoneRecipes(ToolCraftingRecipe.EnumToolType.FORGE_HAMMER);
        RecipesCraftingTools.addGallagherMetalRecipes(ToolCraftingRecipe.EnumToolType.FORGE_HAMMER);
        RecipesCraftingTools.addWorkBladeRecipes();
        RecipesCraftingTools.addWoodRecipes();
        RecipesCraftingTools.addSawWoodRecipes(ToolCraftingRecipe.EnumToolType.HANDSAW_FLINT);
        RecipesCraftingTools.addSawWoodRecipes(ToolCraftingRecipe.EnumToolType.HANDSAW_METAL);
        RecipesCraftingTools.addSawStoneRecipes(ToolCraftingRecipe.EnumToolType.HANDSAW_METAL);
        RecipesCraftingTools.addSawWoodRecipes(ToolCraftingRecipe.EnumToolType.HANDSAW_GEM);
        RecipesCraftingTools.addSawStoneRecipes(ToolCraftingRecipe.EnumToolType.HANDSAW_GEM);
        RecipesCraftingTools.addSawGemRecipes(ToolCraftingRecipe.EnumToolType.HANDSAW_GEM);
        RecipesKiln.addRecipes();
        RecipesCraftingTable.addRecipes();
        RecipesFurnace.addRecipes();
        ToolCraftingRecipe.registerRecipes();
    }

    public static void removeRecipes() {
        if (ModConfig.Survival.DISABLE_ENDEREYE_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "ender_eye"));
        }
        if (ModConfig.Survival.DISABLE_ENDERCHEST_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "ender_chest"));
        }
        if (ModConfig.Survival.DISABLE_TOOLS_WOOD_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "wooden_pickaxe"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "wooden_axe"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "wooden_shovel"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "wooden_hoe"));
        }
        if (ModConfig.Survival.DISABLE_TOOLS_STONE_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "stone_pickaxe"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "stone_axe"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "stone_shovel"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "stone_hoe"));
        }
        if (ModConfig.Survival.DISABLE_TOOLS_IRON_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "iron_pickaxe"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "iron_axe"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "iron_shovel"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "iron_hoe"));
        }
        if (ModConfig.Survival.DISABLE_TOOLS_GOLD_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "golden_pickaxe"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "golden_axe"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "golden_shovel"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "golden_hoe"));
        }
        if (ModConfig.Survival.DISABLE_TOOLS_DIAMOND_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "diamond_pickaxe"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "diamond_axe"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "diamond_shovel"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "diamond_hoe"));
        }
        if (ModConfig.Survival.DISABLE_SWORD_WOOD_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "wooden_sword"));
        }
        if (ModConfig.Survival.DISABLE_SWORD_STONE_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "stone_sword"));
        }
        if (ModConfig.Survival.DISABLE_SWORD_IRON_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "iron_sword"));
        }
        if (ModConfig.Survival.DISABLE_SWORD_GOLD_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "golden_sword"));
        }
        if (ModConfig.Survival.DISABLE_SWORD_DIAMOND_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "diamond_sword"));
        }
        if (ModConfig.Survival.DISABLE_VANILLA_PLANK_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "acacia_planks"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "birch_planks"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "dark_oak_planks"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "jungle_planks"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "oak_planks"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "spruce_planks"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "stick"));
        }
        if (ModConfig.Survival.REPLACE_CHISELED_BLOCK_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "chiseled_quartz_block"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "chiseled_red_sandstone"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "chiseled_sandstone"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "chiseled_stonebrick"));
        }
        if (ModConfig.Survival.DISABLE_VANILLA_SLAB_RECIPE) {
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "acacia_wooden_slab"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "birch_wooden_slab"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "dark_oak_wooden_slab"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "jungle_wooden_slab"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "oak_wooden_slab"));
            RecipeHandler.removeRecipe(new ResourceLocation("minecraft", "spruce_wooden_slab"));
        }
        if (ModConfig.Compatibility.DISABLE_JETPACKS) {
            RecipeHandler.removeRecipe(new ResourceLocation("mekanism", "Jetpack"));
            RecipeHandler.removeRecipe(new ResourceLocation("mekanism", "ArmoredJetpack"));
        }
        if (ModConfig.Compatibility.RECIPE_REMOVAL.length > 0) {
            for (String recipe : ModConfig.Compatibility.RECIPE_REMOVAL) {
                PrimalAPI.logger(2, "remove list", "recipe: " + recipe);
                RecipeHandler.removeRecipe(new ResourceLocation(recipe));
            }
        }
    }

    public static void registerFuels() {
        if (ModConfig.Features.ENABLE_FUELS) {
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.CHARCOAL_MOTE), 177);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.CHARCOAL_FAIR), 1600);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.CHARCOAL_GOOD), 2000);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.CHARCOAL_HIGH), 2400);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.PARAFFIN_CLUMP), 900);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.CALCIFIED_PARAFFIN), 3600);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.CHARCOAL_STACK), 16000);
            FuelValue.addFuel(new ItemStack(Items.field_151121_aF), 60);
            FuelValue.addFuel(new ItemStack(Items.field_151122_aG), 180);
            FuelValue.addFuel(new ItemStack(Items.field_151007_F), 10);
            FuelValue.addFuel(new ItemStack(Blocks.field_150478_aa), 400);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.YEW_STICK), 100);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.IRONWOOD_STICK), 100);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.LACQUER_STICK), 200);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.ARROW_TORCH_WOOD), 400);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.WOOD_PIN), 33);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARK_ACACIA), 33);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARK_DARK_OAK), 33);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARK_BIRCH), 33);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARK_JUNGLE), 33);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARK_OAK), 33);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARK_SPRUCE), 33);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.PLANT_FIBER), 16);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.PLANT_CORDAGE), 48);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.PLANT_TINDER), 60);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.PLANT_PAPYRUS), 60);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.PLANT_CLOTH), 144);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.LEATHER_STRIP), 20);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.LEATHER_CORDAGE), 40);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.THATCH), 120);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.THATCHING_DRY), 60);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.DAUCUS_MURN_WITHERED), 60);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.VALUS_STALK_WITHERED), 60);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.CORN_STALK_DRY), 60);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.FISH_TRAP, 1, ITypeWood.EnumType.OAK.getMetadata()), 340);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.FISH_TRAP, 1, ITypeWood.EnumType.SPRUCE.getMetadata()), 340);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.FISH_TRAP, 1, ITypeWood.EnumType.BIRCH.getMetadata()), 340);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.FISH_TRAP, 1, ITypeWood.EnumType.JUNGLE.getMetadata()), 340);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.FISH_TRAP, 1, ITypeWood.EnumType.ACACIA.getMetadata()), 340);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.FISH_TRAP, 1, ITypeWood.EnumType.DARK_OAK.getMetadata()), 340);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.FISH_TRAP, 1, ITypeWood.EnumType.IRONWOOD.getMetadata()), 440);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.FISH_TRAP, 1, ITypeWood.EnumType.YEW.getMetadata()), 340);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.FISH_TRAP, 1, ITypeWood.EnumType.LACQUER.getMetadata()), 460);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.DRYING_RACK, 1, ITypeWood.EnumType.OAK.getMetadata()), 859);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.DRYING_RACK, 1, ITypeWood.EnumType.SPRUCE.getMetadata()), 859);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.DRYING_RACK, 1, ITypeWood.EnumType.BIRCH.getMetadata()), 859);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.DRYING_RACK, 1, ITypeWood.EnumType.JUNGLE.getMetadata()), 859);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.DRYING_RACK, 1, ITypeWood.EnumType.ACACIA.getMetadata()), 859);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.DRYING_RACK, 1, ITypeWood.EnumType.DARK_OAK.getMetadata()), 859);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.DRYING_RACK, 1, ITypeWood.EnumType.IRONWOOD.getMetadata()), 859);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.DRYING_RACK, 1, ITypeWood.EnumType.YEW.getMetadata()), 859);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.DRYING_RACK, 1, ITypeWood.EnumType.LACQUER.getMetadata()), 1225);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.BARREL, 1, ITypeWood.EnumType.OAK.getMetadata()), 525);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.BARREL, 1, ITypeWood.EnumType.SPRUCE.getMetadata()), 525);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.BARREL, 1, ITypeWood.EnumType.BIRCH.getMetadata()), 525);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.BARREL, 1, ITypeWood.EnumType.JUNGLE.getMetadata()), 525);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.BARREL, 1, ITypeWood.EnumType.ACACIA.getMetadata()), 525);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.BARREL, 1, ITypeWood.EnumType.DARK_OAK.getMetadata()), 525);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.BARREL, 1, ITypeWood.EnumType.IRONWOOD.getMetadata()), 525);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.BARREL, 1, ITypeWood.EnumType.YEW.getMetadata()), 525);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.BARREL, 1, ITypeWood.EnumType.LACQUER.getMetadata()), 585);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARREL_LID_OAK), 75);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARREL_LID_SPRUCE), 75);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARREL_LID_BIRCH), 75);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARREL_LID_JUNGLE), 75);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARREL_LID_ACACIA), 75);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARREL_LID_DARK_OAK), 75);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARREL_LID_IRONWOOD), 75);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARREL_LID_YEW), 75);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.BARREL_LID_LACQUER), 135);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.SLAT_OAK), 37);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.SLAT_SPRUCE), 37);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.SLAT_BIRCH), 37);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.SLAT_JUNGLE), 37);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.SLAT_ACACIA), 37);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.SLAT_DARK_OAK), 37);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.SLAT_IRONWOOD), 37);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.SLAT_YEW), 37);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.SLAT_CORYPHA), 0);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Blocks.SLAT_LACQUER), 67);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.LOGS_SPLIT_ACACIA), 225);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.LOGS_SPLIT_DARK_OAK), 225);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.LOGS_SPLIT_BIRCH), 225);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.LOGS_SPLIT_IRONWOOD), 225);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.LOGS_SPLIT_JUNGLE), 225);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.LOGS_SPLIT_OAK), 225);
            FuelValue.addFuel(new ItemStack(PrimalAPI.Items.LOGS_SPLIT_SPRUCE), 225);
        }
    }

    public static void registerRepairItems() {
        RepairRecipe.addRecipe("plankWood", Item.ToolMaterial.WOOD);
        RepairRecipe.addRecipe("stone", Item.ToolMaterial.STONE);
        RepairRecipe.addRecipe("plateIron", Item.ToolMaterial.IRON);
        RepairRecipe.addRecipe("flakeBone", PrimalAPI.ToolMaterials.TOOL_BONE);
        RepairRecipe.addRecipe("flakeBoneVitrified", PrimalAPI.ToolMaterials.TOOL_VITRIFIED);
        RepairRecipe.addRecipe("ingotWootz", PrimalAPI.ToolMaterials.TOOL_WOOTZ_STEEL);
        RepairRecipe.addRecipe("ingotCrudeIron", PrimalAPI.ToolMaterials.TOOL_CRUDE_IRON);
        RepairRecipe.addRecipe("ingotCopper", PrimalAPI.ToolMaterials.TOOL_COPPER);
        RepairRecipe.addRecipe("ingotBronze", PrimalAPI.ToolMaterials.TOOL_BRONZE);
        RepairRecipe.addRecipe("ingotSilver", PrimalAPI.ToolMaterials.TOOL_SILVER);
        RepairRecipe.addRecipe("ingotShibuichi", PrimalAPI.ToolMaterials.TOOL_SHIBUICHI);
        RepairRecipe.addRecipe("plankIronwood", PrimalAPI.ToolMaterials.TOOL_IRONWOOD);
        RepairRecipe.addRecipe("flakeFlint", PrimalAPI.ToolMaterials.TOOL_FLINT);
        RepairRecipe.addRecipe("flakeQuartz", PrimalAPI.ToolMaterials.TOOL_QUARTZ);
        RepairRecipe.addRecipe("flakeObsidian", PrimalAPI.ToolMaterials.TOOL_OBSIDIAN);
        RepairRecipe.addRecipe("flakeOpal", PrimalAPI.ToolMaterials.TOOL_OPAL);
        RepairRecipe.addRecipe("flakeEmerald", PrimalAPI.ToolMaterials.TOOL_EMERALD);
        RepairRecipe.addRecipe("flakeDiamond", Item.ToolMaterial.DIAMOND);
        RepairRecipe.addRecipe("plateIron", new ItemStack(PrimalAPI.Items.IRON_SAW));
        RepairRecipe.addRecipe("plateCopper", new ItemStack(PrimalAPI.Items.COPPER_SAW));
        RepairRecipe.addRecipe("stoneNether", new ItemStack(PrimalAPI.Items.NETHER_GALLAGHER));
        RepairRecipe.addRecipe("blockQuartz", new ItemStack(PrimalAPI.Items.QUARTZ_GALLAGHER));
    }

    public static void registerItemFireSources() {
        for (ItemStack stack : CommonUtils.getStackList(ModConfig.Flammability.FIRE_SOURCE_ITEMS)) {
            PrimalAPI.logger(15, "adding item fire sources", stack.func_77977_a());
            OreDictionary.registerOre((String)"firesource", (ItemStack)stack);
        }
        FireSource.add(FireSource.EnumUseAction.FLINT_STEEL, new ItemStack(Items.field_151033_d));
        FireSource.add(FireSource.EnumUseAction.FIRE_BOW, new ItemStack(PrimalAPI.Items.FIRE_BOW));
        FireSource.add(FireSource.EnumUseAction.BASIC, "torch");
        FireSource.add(FireSource.EnumUseAction.BASIC, "firesource");
        FireSource.add(FireSource.EnumUseAction.BASIC, new ItemStack(Items.field_151129_at));
        FireSource.add(FireSource.EnumUseAction.BASIC, true, new ItemStack(PrimalAPI.Items.SEARING_SPRIG));
    }

    public static void addBasicKernRecipe(String in, ItemStack out) {
        BASIC_KERN_CRAFTING_REGISTRY.put(in, out);
    }

    public static void addBasicKernRecipe(ItemStack in, ItemStack out) {
        BASIC_KERN_CRAFTING_REGISTRY.put(in, out);
    }

    public static void addBasicKernRecipes(Item tool) {
        ItemStack STONE_BASIN = new ItemStack(tool, 1, Short.MAX_VALUE);
        ModRecipes.addBasicKernRecipe(new ItemStack(Items.field_151015_O), new ItemStack(PrimalAPI.Items.WHEAT_GROUND));
        ModRecipes.addBasicKernRecipe(new ItemStack(PrimalAPI.Items.CORN_SEEDS, 2), new ItemStack(PrimalAPI.Items.CORN_GROUND));
        ModRecipes.addBasicKernRecipe("bone", new ItemStack(Items.field_151100_aR, 3, 15));
        ModRecipes.addBasicKernRecipe(new ItemStack(PrimalAPI.Items.PLANT_TINDER), new ItemStack(PrimalAPI.Items.PLANT_FIBER_PULP));
        ModRecipes.addBasicKernRecipe(new ItemStack(PrimalAPI.Items.NETHER_TINDER), new ItemStack(PrimalAPI.Items.CINERIS_FIBER_PULP));
        ModRecipes.addBasicKernRecipe(new ItemStack((Block)Blocks.field_150328_O), new ItemStack(PrimalAPI.Items.URUSHI_GROUND));
        ModRecipes.addBasicKernRecipe(new ItemStack((Block)Blocks.field_150327_N), new ItemStack(PrimalAPI.Items.URUSHI_GROUND));
        ModRecipes.addBasicKernRecipe(new ItemStack(Blocks.field_185766_cS), new ItemStack(PrimalAPI.Items.URUSHI_GROUND, 4));
        ModRecipes.addBasicKernRecipe(new ItemStack(PrimalAPI.Items.RUSH_STEMS), new ItemStack(PrimalAPI.Items.URUSHI_GROUND, 2));
        ModRecipes.addBasicKernRecipe(new ItemStack(PrimalAPI.Items.VALUS_STALK_WITHERED), new ItemStack(PrimalAPI.Items.URUSHI_GROUND, 2));
        ModRecipes.addBasicKernRecipe(new ItemStack(PrimalAPI.Items.INANIS_ROOT), new ItemStack(PrimalAPI.Items.URUSHI_GROUND, 2));
        ModRecipes.addBasicKernRecipe(new ItemStack(PrimalAPI.Items.CINERIS_ROOT), new ItemStack(PrimalAPI.Items.CINERIS_FIBER_PULP, 1));
        ModRecipes.addBasicKernRecipe(new ItemStack(PrimalAPI.Blocks.INFERUM_VINE), new ItemStack(PrimalAPI.Items.INFERUM_GROUND, 1));
        ModRecipes.addBasicKernRecipe(new ItemStack(PrimalAPI.Items.DAUCUS_MURN_WITHERED), new ItemStack(Items.field_151102_aT, 2));
        ModRecipes.addBasicKernRecipe("barkWood", new ItemStack(PrimalAPI.Items.TANNIN_GROUND, 1));
        for (Map.Entry<Object, ItemStack> entry : BASIC_KERN_CRAFTING_REGISTRY.entrySet()) {
            RecipeHandler.addShapedOreRecipe(entry.getValue(), "S", "I", "C", Character.valueOf('S'), "rock", Character.valueOf('I'), entry.getKey(), Character.valueOf('C'), STONE_BASIN);
        }
    }
}

