/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.foods;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.plants.AbstractPlant;
import nmd.primal.core.common.helper.TeleportHelper;
import nmd.primal.core.common.init.ModPlants;
import nmd.primal.core.common.items.foods.Foodstuff;

public class Seeds
extends Foodstuff
implements IPlantable {
    public Seeds(int healAmount, float saturation) {
        super(healAmount, saturation, false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + ModPlants.getSeedDescription(this));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState soil_state = world.func_180495_p(pos);
        IBlockState plant_state = ModPlants.getSeedPlant(this);
        if (plant_state != null && plant_state.func_177230_c() instanceof AbstractPlant) {
            AbstractPlant plant = (AbstractPlant)plant_state.func_177230_c();
            if (facing == EnumFacing.UP && player.func_175151_a(pos.func_177972_a(facing), facing, stack) && plant.canSustainPlant(soil_state, (IBlockAccess)world, pos, EnumFacing.UP, plant) && world.func_175623_d(pos.func_177984_a())) {
                if (!world.field_72995_K) {
                    world.func_180501_a(pos.func_177984_a(), plant_state, 11);
                    stack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        super.func_77849_c(stack, world, player);
        if (this == PrimalAPI.Items.SEARING_EMBER) {
            player.func_70015_d(3 + PrimalCore.RANDOM.nextInt(13));
        }
        if (this == PrimalAPI.Items.INANIS_SEED && !player.func_70026_G()) {
            TeleportHelper.teleportRandomly((EntityLivingBase)player);
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return ModPlants.getSeedPlant(this);
    }
}

