/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.projectiles;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import nmd.primal.core.common.entities.EntityFireProofItems;
import nmd.primal.core.common.entities.projectiles.TypeMud;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.items.PrimalItem;

public class Mud
extends PrimalItem {
    private Type type;

    public Mud(Type type, int stacksize) {
        this.field_77777_bU = stacksize;
        this.type = type;
    }

    public Mud(Type type) {
        this(type, 64);
    }

    @Override
    public boolean hasCustomEntity(ItemStack stack) {
        return this.type.func_176610_l().equals("ancient_ice");
    }

    @Override
    public Entity createEntity(World world, Entity location, ItemStack stack) {
        EntityFireProofItems entity = new EntityFireProofItems(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, stack);
        entity.field_70159_w = location.field_70159_w;
        entity.field_70181_x = location.field_70181_x;
        entity.field_70179_y = location.field_70179_y;
        entity.func_174867_a(12);
        return entity;
    }

    public boolean onEntityItemUpdate(EntityItem entity) {
        if (entity instanceof EntityFireProofItems) {
            World world = entity.func_130014_f_();
            BlockPos pos = entity.func_180425_c();
            if (!world.field_72995_K) {
                if (entity.func_70090_H() && world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
                    world.func_180501_a(pos, Blocks.field_150432_aD.func_176223_P(), 2);
                    FXHelper.fxIce(world, pos, 1.5f);
                    entity.func_70106_y();
                } else if (entity.func_180799_ab() && world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_185904_a() == Material.field_151587_i) {
                    world.func_180501_a(pos.func_177972_a(EnumFacing.DOWN), Blocks.field_150347_e.func_176223_P(), 2);
                    FXHelper.fxLava(world, pos);
                    entity.func_70106_y();
                }
            }
        }
        return super.onEntityItemUpdate(entity);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!world.field_72995_K) {
            TypeMud mud = new TypeMud(world, (EntityLivingBase)player);
            mud.setType(this.type.func_176610_l());
            mud.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
            world.func_72838_d((Entity)mud);
        }
        player.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static enum Type implements IStringSerializable
    {
        MUD("mud", 0.35f, 0.0f),
        MUCK("muck", 0.65f, 0.2f),
        MUCK_MOLTEN("muck_molten", 0.65f, 1.0f),
        TERRA("terra", 0.35f, 0.0f),
        CINIS("cinis", 0.35f, 0.0f),
        ADOBE("adobe", 0.35f, 0.0f),
        WAX("wax", 0.65f, 0.0f),
        SLAG("slag", 0.45f, 0.5f),
        FERMENTED_JUNGLE("fermented_jungle", 0.45f, 0.5f),
        ANCIENT_ICE("ancient_ice", 0.25f, 1.0f);

        private final String name;
        private final float drop_chance;
        private final float damage_modifier;

        private Type(String name, float drop_chance, float damage_modifier) {
            this.name = name;
            this.drop_chance = drop_chance;
            this.damage_modifier = damage_modifier;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public float getDropChance() {
            return this.drop_chance;
        }

        public float getDamgeModifier() {
            return this.damage_modifier;
        }

        public static Type byName(String name) {
            for (Type blocks$enumtype : Type.values()) {
                if (!blocks$enumtype.func_176610_l().equals(name)) continue;
                return blocks$enumtype;
            }
            return MUD;
        }
    }
}

