/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.tools;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.common.blocks.machines.Cauldron;
import nmd.primal.core.common.items.PrimalItem;
import nmd.primal.core.common.tiles.machines.TileCauldron;

public class CauldronLadle
extends PrimalItem {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.cauldron_ladle_view"));
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.cauldron_ladle_take"));
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        TileCauldron tile;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!world.field_72995_K && block instanceof Cauldron && (tile = (TileCauldron)world.func_175625_s(pos)) != null) {
            FluidStack heldFluid = tile.getContainedFluid();
            if (face == EnumFacing.UP) {
                if (!tile.isCovered() && !tile.takeOutput(player)) {
                    tile.takeInput(player);
                }
            } else {
                String count;
                ItemStack stack;
                int i;
                ItemStackHandler stackHandler;
                if (heldFluid != null) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.BLUE + tile.getContainedFluid().getLocalizedName() + " (" + tile.getContainedFluid().amount + ")", new Object[0]));
                }
                if (tile.hasInput()) {
                    stackHandler = tile.getInputHandler();
                    for (i = 0; i < stackHandler.getSlots(); ++i) {
                        stack = stackHandler.getStackInSlot(i);
                        if (stack.func_190926_b()) continue;
                        count = stack.func_190916_E() > 1 ? " (" + stack.func_190916_E() + ")" : "";
                        player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + stack.func_82833_r() + count, new Object[0]));
                    }
                }
                if (tile.hasOutput()) {
                    stackHandler = tile.getOutputHandler();
                    for (i = 0; i < stackHandler.getSlots(); ++i) {
                        stack = stackHandler.getStackInSlot(i);
                        if (stack.func_190926_b()) continue;
                        count = stack.func_190916_E() > 1 ? " (" + stack.func_190916_E() + ")" : "";
                        player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GOLD + stack.func_82833_r() + count, new Object[0]));
                    }
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GRAY + "Cauldron is currently " + TextFormatting.RED + this.getHeatLevel(tile.getHeat()), new Object[0]));
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public String getHeatLevel(float value) {
        if (value < 0.1f) {
            return "Cold";
        }
        if (value > 0.1f && value < 0.79f) {
            return "Warm";
        }
        if (value > 0.79f && value < 1.1f) {
            return "Hot";
        }
        if (value > 1.1f && value < 1.9f) {
            return "Too Hot";
        }
        if (value > 1.9f) {
            return "Super Hot";
        }
        return "Unknown";
    }
}

