/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.tools;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.items.tools.AbstractCraftingTool;
import nmd.primal.core.common.recipes.irecipe.ToolCraftingRecipe;

public class FireBow
extends AbstractCraftingTool {
    public FireBow(Item.ToolMaterial material) {
        super(material, ToolCraftingRecipe.EnumToolType.FIRE_BOW);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("using"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.fire_bow_torches"));
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.fire_bow_fuel"));
    }

    @Override
    public boolean func_82789_a(ItemStack item, ItemStack repair) {
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack stick_stack = PlayerHelper.findItem(player, "stickWood");
        BlockPos pos_offset = pos.func_177972_a(facing);
        if (world.func_180495_p(pos).func_177230_c() instanceof ILit) {
            return EnumActionResult.FAIL;
        }
        if (stick_stack.func_190926_b() || !player.func_175151_a(pos_offset, facing, stack)) {
            return EnumActionResult.FAIL;
        }
        FXHelper.soundStringBreak(world, pos, 0.2f);
        if (PrimalAPI.randomCheck(ModConfig.Features.FIREBOW_DIFFICULTY)) {
            if (!world.field_72995_K) {
                if (world.func_175623_d(pos_offset)) {
                    PlayerHelper.useStack(player, hand, stick_stack);
                    world.func_180501_a(pos_offset, Blocks.field_150480_ab.func_176223_P(), 11);
                    FireHelper.makeSmoke(world, pos_offset, 8);
                }
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return EnumActionResult.SUCCESS;
        }
        if (!world.field_72995_K && PrimalAPI.randomCheck(6)) {
            FXHelper.soundStickBreak(world, pos, 1.0f);
            PlayerHelper.useStack(player, hand, stick_stack);
        }
        return EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean flag = PlayerHelper.hasItem(player, "stickWood");
        if (!player.field_71075_bZ.field_75098_d && !flag) {
            return !flag ? new ActionResult(EnumActionResult.FAIL, (Object)stack) : new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

