/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.tools;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.interfaces.IFireProof;
import nmd.primal.core.api.interfaces.crafting.IDictionaryName;
import nmd.primal.core.api.interfaces.crafting.IToolHandler;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.entities.EntityFireProofItems;
import nmd.primal.core.common.helper.RegistryHelper;
import nmd.primal.core.common.recipes.irecipe.ToolCraftingRecipe;
import nmd.primal.core.common.recipes.misc.RepairRecipe;

public class PrimalAxe
extends ItemAxe
implements IToolHandler,
IFireProof<ItemAxe>,
IDictionaryName<Item> {
    private boolean is_fire_proof;
    private boolean is_immortal;
    private String[] dictionary_names;

    public PrimalAxe(Item.ToolMaterial material, float damage, float speed) {
        super(material, damage, speed);
        this.field_77865_bY = damage;
        this.field_185065_c = speed;
    }

    public PrimalAxe(Item.ToolMaterial material, float speed) {
        this(material, 5.0f + material.func_78000_c(), speed);
    }

    public PrimalAxe(Item.ToolMaterial material) {
        this(material, -3.0f);
    }

    public ItemAxe setNoDespawn(boolean is_immortal) {
        this.is_immortal = is_immortal;
        return this;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        EnumEnchantmentType type = enchantment.field_77351_y;
        if (type != null) {
            switch (enchantment.field_77351_y) {
                case DIGGER: 
                case WEAPON: 
                case BREAKABLE: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Item setDictionaryNames(String ... strings) {
        this.dictionary_names = strings;
        return this;
    }

    @Override
    public String[] getDictionaryNames() {
        return this.dictionary_names;
    }

    @Override
    public void registerDictionaryNames() {
        for (String name : this.getDictionaryNames()) {
            RegistryHelper.registerDictionaryNames(new ItemStack((Item)this), name);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.abstract_grid_crafting_tool"));
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.abstract_world_crafting_tool"));
        if (this.is_fire_proof) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_74838_a((String)"tooltip.info.primal.abstract_fire_proof"));
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77952_i() < this.getMaxDamage(stack);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack container = stack.func_77946_l();
        container.func_96631_a(1, (Random)PrimalCore.RANDOM, null);
        return container;
    }

    public boolean func_82789_a(ItemStack item, ItemStack repair) {
        return RepairRecipe.isRepairItem(repair, item, this.field_77862_b);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    @Override
    public ToolCraftingRecipe.EnumToolType getToolType() {
        return ToolCraftingRecipe.EnumToolType.HATCHET;
    }

    @Override
    public ItemAxe setFireProof(boolean is_fire_proof) {
        this.is_fire_proof = is_fire_proof;
        return this;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.is_fire_proof;
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        EntityFireProofItems entity = this.getEntity(world, location, stack);
        if (this.is_immortal) {
            entity.func_174873_u();
        }
        return entity;
    }
}

