/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.tools;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.interfaces.IFireProof;
import nmd.primal.core.api.interfaces.crafting.IToolHandler;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.checks.MaterialMultiplexer;
import nmd.primal.core.common.recipes.irecipe.ToolCraftingRecipe;
import nmd.primal.core.common.recipes.misc.RepairRecipe;

public class PrimalShears
extends ItemShears
implements IToolHandler,
IFireProof<ItemShears> {
    private Item.ToolMaterial toolMaterial;
    private ToolCraftingRecipe.EnumToolType toolType;
    private boolean is_fire_proof;

    public PrimalShears(Item.ToolMaterial material, ToolCraftingRecipe.EnumToolType type) {
        this.func_77656_e(material.func_77997_a());
        this.toolMaterial = material;
        this.toolType = type;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (this.is_fire_proof) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_74838_a((String)"tooltip.info.primal.abstract_fire_proof"));
        }
    }

    @Override
    public ToolCraftingRecipe.EnumToolType getToolType() {
        return this.toolType;
    }

    public boolean func_82789_a(ItemStack item, ItemStack repair) {
        return RepairRecipe.isRepairItem(repair, item, this.toolMaterial);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77952_i() < this.getMaxDamage(stack);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack container = stack.func_77946_l();
        container.func_96631_a(1, (Random)PrimalCore.RANDOM, null);
        return container;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (MaterialMultiplexer.forMaterial(Material.field_151569_G, Material.field_151585_k, Material.field_151582_l, Material.field_151584_j, Material.field_151580_n, Material.field_151593_r, Material.field_151594_q, Material.field_151589_v).apply(state)) {
            return 15.0f;
        }
        return super.func_150893_a(stack, state);
    }

    @Override
    public ItemShears setFireProof(boolean is_fire_proof) {
        this.is_fire_proof = is_fire_proof;
        return this;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.is_fire_proof;
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        return this.getEntity(world, location, stack);
    }
}

