/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.tools;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFireProof;
import nmd.primal.core.api.interfaces.crafting.IDictionaryName;
import nmd.primal.core.api.interfaces.crafting.IToolHandler;
import nmd.primal.core.common.entities.EntityFireProofItems;
import nmd.primal.core.common.helper.RegistryHelper;
import nmd.primal.core.common.recipes.misc.RepairRecipe;

public abstract class PrimalTool
extends ItemTool
implements IFireProof<ItemTool>,
IDictionaryName<Item>,
IToolHandler {
    public Item.ToolMaterial material;
    private final float attackDamage;
    private final float attackSpeed;
    private boolean is_fire_proof;
    private boolean is_immortal;
    private String[] dictionary_names;

    public PrimalTool(Item.ToolMaterial material, float attack_damage, float attack_speed, Set<Block> effective_on, String toolClass) {
        super(attack_damage, attack_speed, material, effective_on);
        this.attackDamage = attack_damage;
        this.attackSpeed = attack_damage;
        this.material = material;
        this.setHarvestLevel(toolClass, material.func_77996_d());
    }

    public PrimalTool(Item.ToolMaterial material, float attack_damage, float attack_speed, Set<Block> effective_on) {
        this(material, attack_damage, attack_speed, effective_on, "unknown");
    }

    public ItemTool setNoDespawn(boolean is_immortal) {
        this.is_immortal = is_immortal;
        return this;
    }

    public boolean func_82789_a(ItemStack item, ItemStack repair) {
        PrimalAPI.logger(2, "inworld repair", "inworld: " + item);
        return RepairRecipe.isRepairItem(repair, item, this.field_77862_b);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (this.is_fire_proof) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_74838_a((String)"tooltip.info.primal.abstract_fire_proof"));
        }
    }

    public float getAttackDamage() {
        return this.material.func_78000_c();
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(2, attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        if ((double)state.func_185887_b(world, pos) != 0.0) {
            stack.func_77972_a(1, entity);
        }
        return true;
    }

    @Override
    public ItemTool setFireProof(boolean is_fire_proof) {
        this.is_fire_proof = is_fire_proof;
        return this;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.is_fire_proof;
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        EntityFireProofItems entity = this.getEntity(world, location, stack);
        if (this.is_immortal) {
            entity.func_174873_u();
        }
        return entity;
    }

    @Override
    public Item setDictionaryNames(String ... strings) {
        this.dictionary_names = strings;
        return this;
    }

    @Override
    public String[] getDictionaryNames() {
        return this.dictionary_names;
    }

    @Override
    public void registerDictionaryNames() {
        for (String name : this.getDictionaryNames()) {
            RegistryHelper.registerDictionaryNames(new ItemStack((Item)this, 1, Short.MAX_VALUE), name);
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        EnumEnchantmentType type = enchantment.field_77351_y;
        if (type != null) {
            switch (enchantment.field_77351_y) {
                case DIGGER: 
                case WEAPON: 
                case BREAKABLE: {
                    return true;
                }
            }
        }
        return false;
    }
}

