/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.potions;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.helper.DamageHelper;
import nmd.primal.core.common.potions.PrimalPotion;

@GameRegistry.ObjectHolder(value="primal")
public final class ModPotions {
    public static final PrimalPotion ACONITE = new PrimalPotion(true, 2, 2, 2, "aconite", new ItemStack(PrimalAPI.Items.OVIS_MILK_BOTTLE), new ItemStack(PrimalAPI.Items.CHEESE_RED));
    public static final PrimalPotion YEW = new PrimalPotion(true, 2, 2, 2, "yew", new ItemStack(PrimalAPI.Items.OVIS_MILK_BOTTLE), new ItemStack(PrimalAPI.Items.CHEESE_RED));
    public static final PrimalPotion ADRENALINE = new PrimalPotion(false, 2, 2, 2, "adrenaline", new ItemStack[0]);
    public static final PrimalPotion PORPHYRIA = new PrimalPotion(true, 2, 2, 2, "porphyria", new ItemStack(PrimalAPI.Items.SINUOUS_RESIN));
    public static final PrimalPotion WATER_BURN = new PrimalPotion(true, 2, 2, 2, "water_burn", new ItemStack[0]);
    public static final PrimalPotion SUN_BURN = new PrimalPotion(true, 2, 2, 2, "sun_burn", new ItemStack[0]);
    Potion[] adrenaline_effects = new Potion[]{MobEffects.field_76444_x, MobEffects.field_76429_m, MobEffects.field_76420_g, MobEffects.field_76424_c, MobEffects.field_76430_j};

    public static int getPotionAmplifier(EntityLivingBase entity, Potion potion) {
        PotionEffect effect = entity.func_70660_b(potion);
        return effect != null ? effect.func_76458_c() : 0;
    }

    public static int getPotionDuration(EntityLivingBase entity, Potion potion) {
        PotionEffect effect = entity.func_70660_b(potion);
        return effect != null ? effect.func_76459_b() : 0;
    }

    public static boolean stackPotionAmplifier(EntityLivingBase entity, PotionEffect potionEffect) {
        Potion potion = potionEffect.func_188419_a();
        if (entity.func_70644_a(potion)) {
            PotionEffect effect = entity.func_70660_b(potion);
            if (effect != null) {
                int incoming_level = potionEffect.func_76458_c() > 0 ? potionEffect.func_76458_c() : 1;
                int combined_level = effect.func_76458_c() + incoming_level < 4 ? effect.func_76458_c() + incoming_level : effect.func_76458_c();
                entity.func_70690_d(new PotionEffect(potion, effect.func_76459_b() + potionEffect.func_76459_b(), combined_level, potionEffect.func_82720_e(), potionEffect.func_188418_e()));
                return true;
            }
        } else {
            entity.func_70690_d(potionEffect);
            return true;
        }
        return false;
    }

    public static void addCurativeItems() {
        ItemStack white_cheese = new ItemStack(PrimalAPI.Items.CHEESE_WHITE);
        ItemStack red_cheese = new ItemStack(PrimalAPI.Items.CHEESE_RED);
    }

    public static void addPotions() {
    }

    @Mod.EventBusSubscriber(modid="primal")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerPotions(RegistryEvent.Register<Potion> event) {
            PrimalAPI.logger(1, "Registering Potions");
            IForgeRegistry registry = event.getRegistry();
            registry.registerAll((IForgeRegistryEntry[])new Potion[]{ACONITE, YEW, ADRENALINE, PORPHYRIA, WATER_BURN, SUN_BURN});
        }

        @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
        public static void onPotionUpdate(LivingEvent.LivingUpdateEvent event) {
            PotionEffect sun_burn;
            PotionEffect water_burn;
            int amplifier;
            PotionEffect effect;
            EntityLivingBase entity = event.getEntityLiving();
            World world = entity.func_130014_f_();
            if (world.field_72995_K) {
                return;
            }
            if (entity.func_70644_a((Potion)ACONITE) && PrimalAPI.randomCheck(8) && (effect = entity.func_70660_b((Potion)ACONITE)) != null) {
                amplifier = effect.func_76458_c();
                PrimalAPI.logger(31, "aconite poison", "amplifier: " + amplifier);
                entity.func_70097_a((DamageSource)DamageHelper.ACONITE, 1.0f);
                if (!entity.func_70644_a(MobEffects.field_76437_t)) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 900, 0));
                }
                if (PrimalAPI.randomCheck(16) && !entity.func_70644_a(MobEffects.field_76440_q)) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 900, 0));
                }
                if (PrimalAPI.randomCheck(60) && !entity.func_70644_a(MobEffects.field_76431_k)) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
                }
            }
            if (entity.func_70644_a((Potion)YEW) && PrimalAPI.randomCheck(8) && (effect = entity.func_70660_b((Potion)YEW)) != null) {
                amplifier = effect.func_76458_c();
                PrimalAPI.logger(31, "yew poison", "amplifier: " + amplifier);
                entity.func_70097_a((DamageSource)DamageHelper.YEW, 1.0f);
                if (!entity.func_70644_a(MobEffects.field_76437_t)) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 900, 0));
                }
                if (PrimalAPI.randomCheck(16) && !entity.func_70644_a(MobEffects.field_76421_d)) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 900, 0));
                }
            }
            if ((water_burn = entity.func_70660_b((Potion)WATER_BURN)) != null && PrimalAPI.randomCheck(8)) {
                DamageHelper.applyWaterDamage(entity, water_burn.func_76458_c(), false);
            }
            if ((sun_burn = entity.func_70660_b((Potion)SUN_BURN)) != null && PrimalAPI.randomCheck(8)) {
                DamageHelper.applySunDamage(entity, sun_burn.func_76458_c());
            }
        }
    }
}

