/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.recipes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.recipes.AbstractRecipe;

public abstract class AbstractToolRecipe<RECIPE extends AbstractRecipe<RECIPE>>
extends AbstractRecipe<RECIPE> {
    private IBlockState input_state;
    private IBlockState output_state;
    private ItemStack output_stack;
    private Orientation output_orientation;
    private int[] output_amount;

    public AbstractToolRecipe(IBlockState input_state, IBlockState output_state, ItemStack output_stack, int[] output_amount, Orientation output_orientation) {
        if (input_state == null) {
            throw new IllegalArgumentException("[AbstractToolRecipe] Invalid RecipeAnnotation, must specify a valid input BlockState");
        }
        this.input_state = input_state;
        this.output_state = output_state;
        this.output_stack = output_stack;
        this.output_amount = output_amount;
        this.output_orientation = output_orientation;
    }

    public AbstractToolRecipe(IBlockState input_state, IBlockState output_state, ItemStack output_stack, int[] output_amount) {
        this(input_state, output_state, output_stack, output_amount, Orientation.NORMAL);
    }

    public AbstractToolRecipe(IBlockState input_state, IBlockState output_state, Orientation output_facing) {
        this(input_state, output_state, ItemStack.field_190927_a, new int[]{0, 0}, output_facing);
    }

    public AbstractToolRecipe(IBlockState input_state, IBlockState output_state) {
        this(input_state, output_state, ItemStack.field_190927_a, new int[]{0, 0}, Orientation.NORMAL);
    }

    public IBlockState getInputState() {
        return this.input_state;
    }

    public IBlockState getOutputState() {
        return this.output_state;
    }

    public ItemStack getOutputStack() {
        ItemStack output = this.output_stack.func_77946_l();
        output.func_190920_e(this.getOutputAmount());
        return output;
    }

    public int getOutputAmount() {
        return this.output_amount.length > 1 ? PrimalCore.RANDOM.nextInt(this.getOutputMin(), this.getOutputMax() + 1) : this.getOutputMin();
    }

    public int getOutputMin() {
        return this.output_amount[0];
    }

    public int getOutputMax() {
        return this.output_amount.length > 1 ? this.output_amount[1] : this.output_amount[0];
    }

    public Orientation getFacing() {
        return this.output_orientation;
    }

    public boolean hasFacing() {
        return this.output_orientation == Orientation.FACING;
    }

    public boolean match(IBlockState state) {
        return state != null && !this.isDisabled() && state == this.input_state;
    }

    public List<ItemStack> getInput() {
        return RecipeHelper.buildList(AbstractToolRecipe.getItemStack(this.input_state, this.output_orientation));
    }

    public List<ItemStack> getOutput() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (this.getOutputState() != null && this.getOutputState().func_177230_c() != Blocks.field_150350_a) {
            list.add(AbstractToolRecipe.getItemStack(this.output_state, this.output_orientation));
        }
        if (this.getOutputStack() != null && !this.getOutputStack().func_190926_b()) {
            list.add(this.getOutputStack());
        }
        return list;
    }

    public static ItemStack getItemStack(IBlockState state, Orientation orientation) {
        int meta = orientation == Orientation.NORMAL ? state.func_177230_c().func_176201_c(state) : 0;
        return new ItemStack(state.func_177230_c(), 1, meta);
    }

    public static enum Orientation implements IStringSerializable
    {
        NORMAL("normal"),
        FACING("facing"),
        LOG("log");

        private final String name;

        private Orientation(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static Orientation byName(String name) {
            if (name != null) {
                for (Orientation blocks$enumtype : Orientation.values()) {
                    if (!blocks$enumtype.func_176610_l().equals(name)) continue;
                    return blocks$enumtype;
                }
            }
            return NORMAL;
        }
    }
}

