/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.recipes.crafting.custom;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.types.IQuality;
import nmd.primal.core.api.interfaces.types.ITypeBrick;
import nmd.primal.core.common.blocks.misc.ObsidianGlass;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.recipes.tile.SmelterRecipe;

@GameRegistry.ObjectHolder(value="primal")
@Mod.EventBusSubscriber
public final class RecipesSmelter {
    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<SmelterRecipe> event) {
        String[] ores;
        PrimalAPI.logger(7, "Registering Recipes: smelter");
        IForgeRegistry recipes = event.getRegistry();
        List<ItemStack> charcoal_mote = RecipeHelper.getOreStack(1, "charcoalMote");
        List<ItemStack> charcoal_fair = RecipeHelper.getOreStack(1, "charcoalFair");
        List<ItemStack> charcoal_good = RecipeHelper.getOreStack(1, "charcoalGood");
        List<ItemStack> charcoal_high = RecipeHelper.getOreStack(1, "charcoalHigh");
        List<ItemStack> charcoal_high_x2 = RecipeHelper.getOreStack(2, "charcoalHigh");
        List<ItemStack> charcoal_mix = RecipeHelper.getOreStack(1, "charcoal");
        List<ItemStack> charcoal_mid = RecipeHelper.getOreStack(1, "charcoalFair", "charcoalGood");
        List<ItemStack> charcoal_end = RecipeHelper.getOreStack(1, "charcoalGood", "charcoalHigh");
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, RecipeHelper.getOreStack("bone", 1, new ItemStack[0]), new ItemStack(PrimalAPI.Items.ASH_BONE, 1)).setRecipeName("bone_ash"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(3, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.PELT_WOLF, 1)), new ItemStack(PrimalAPI.Items.ASH_WOLF, 1)).setRecipeName("wolf_ash"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(4, RecipeHelper.getOreStack("plankYew", 1, new ItemStack[0]), new ItemStack(PrimalAPI.Blocks.ASH_YEW, 1)).setRecipeName("yew_ash"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(4, RecipeHelper.getOreStack("plankIronwood", 1, new ItemStack[0]), new ItemStack(PrimalAPI.Blocks.ASH_IRONWOOD, 1)).setRecipeName("ironwood_ash"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(8, RecipeHelper.getOreStack("charcoalHigh", 16, new ItemStack[0]), RecipeHelper.buildList(new ItemStack(Items.field_151044_h, 1, 0)), new ItemStack(PrimalAPI.Items.CHARCOAL_PURE, 2), new ItemStack(PrimalAPI.Items.CHARCOAL_MOTE, 16), new ItemStack(PrimalAPI.Blocks.ASH_COMMON, 6)).setRecipeName("pure_carbon"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(3, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.SOUL_RESIDUE, 1)), charcoal_mote, new ItemStack(Items.field_151130_bT, 1)).setRecipeName("soul_residue"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(3, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.SINUOUS_SPORE, 1)), charcoal_mote, new ItemStack(PrimalAPI.Items.SINUOUS_RESIN, 1)).setRecipeName("sinuous_spores"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, RecipeHelper.getOreStack("skullZombie", 1, new ItemStack[0]), RecipeHelper.getOreStack("charcoalMote", 3, new ItemStack[0]), new ItemStack(Items.field_151144_bL), new ItemStack(PrimalAPI.Blocks.ASH_COMMON)).setRecipeName("skull"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(2, RecipeHelper.getOreStack("barkWood", 1, new ItemStack[0]), new ItemStack(PrimalAPI.Items.CHARCOAL_MOTE)).setRecipeName("bark"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(3, RecipeHelper.getOreStack("logWood", 1, new ItemStack(PrimalAPI.Blocks.LOGS_STRIPPED)), new ItemStack(Items.field_151044_h, 1, 1), new ItemStack(PrimalAPI.Items.CHARCOAL_MOTE, 4)).setRecipeName("charcoal_log"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(3, RecipeHelper.getOreStack("logStripped", 1, new ItemStack[0]), new ItemStack(Items.field_151044_h, 1, 1)).setRecipeName("charcoal_stripped"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, RecipeHelper.buildList(new ItemStack(Blocks.field_150425_aM)), charcoal_mote, new ItemStack(PrimalAPI.Blocks.SOUL_GLASS, 1)).setRecipeName("soul_sand"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, RecipeHelper.buildList(new ItemStack((Block)Blocks.field_150354_m)), charcoal_mote, new ItemStack(Blocks.field_150359_w, 1)).setRecipeName("sand"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, RecipeHelper.buildList(new ItemStack(Blocks.field_150347_e)), charcoal_mote, new ItemStack(Blocks.field_150348_b, 1)).setRecipeName("stone"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, RecipeHelper.buildList(new ItemStack(PrimalAPI.Blocks.SOUL_GLASS)), charcoal_mote, new ItemStack(Blocks.field_150359_w, 2)).setRecipeName("soul_glass_to_glass"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, RecipeHelper.getOreStack("stoneNether", 1, new ItemStack[0]), RecipeHelper.getOreStack("charcoalMote", 4, new ItemStack[0]), new ItemStack(Items.field_151130_bT, 4)).setRecipeName("netherstone_to_brick"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, RecipeHelper.getOreStack("netherrack", 1, new ItemStack[0]), charcoal_mote, new ItemStack(Items.field_151130_bT, 1)).setRecipeName("netherrack_to_brick"));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(10, RecipeHelper.buildList(new ItemStack(PrimalAPI.Blocks.SATETSU, 1, IQuality.EnumQuality.POOR.getMetadata())), charcoal_mote, new ItemStack(PrimalAPI.Blocks.IRON_GLASS, 1)).setRecipeName("satetsu_poor_glass")).setSlag(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(6, RecipeHelper.buildList(new ItemStack(PrimalAPI.Blocks.SATETSU, 1, IQuality.EnumQuality.FAIR.getMetadata())), charcoal_mote, new ItemStack(PrimalAPI.Blocks.IRON_GLASS, 2)).setRecipeName("satetsu_fair_glass")).setSlag(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(6, RecipeHelper.buildList(new ItemStack(PrimalAPI.Blocks.SATETSU, 1, IQuality.EnumQuality.GOOD.getMetadata())), RecipeHelper.getOreStack("charcoalMote", 2, new ItemStack[0]), new ItemStack(PrimalAPI.Blocks.IRON_GLASS, 4)).setRecipeName("satetsu_good_glass")).setSlag(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(6, RecipeHelper.buildList(new ItemStack(PrimalAPI.Blocks.SATETSU, 1, IQuality.EnumQuality.HIGH.getMetadata())), RecipeHelper.getOreStack("charcoalMote", 2, new ItemStack[0]), new ItemStack(PrimalAPI.Blocks.IRON_GLASS, 5)).setRecipeName("satetsu_high_glass")).setSlag(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(6, RecipeHelper.buildList(new ItemStack(PrimalAPI.Blocks.SATETSU, 1, IQuality.EnumQuality.PURE.getMetadata())), RecipeHelper.getOreStack("charcoalMote", 2, new ItemStack[0]), new ItemStack(PrimalAPI.Blocks.IRON_GLASS, 6)).setRecipeName("satetsu_pure_glass")).setSlag(true));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(4, RecipeHelper.buildList(new ItemStack(Items.field_151045_i)), RecipeHelper.getOreStack("charcoalMote", 4, new ItemStack[0]), new ItemStack(PrimalAPI.Items.DIAMOND_PLATE)).setRecipeName("diamond_plate"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(4, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.DIAMOND_PLATE)), RecipeHelper.getOreStack("charcoalMote", 4, new ItemStack[0]), new ItemStack(Items.field_151045_i)).setRecipeName("diamond_from_plate"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(4, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.OBSIDIAN_SHARD)), RecipeHelper.getOreStack("charcoalMote", 4, new ItemStack[0]), new ItemStack(PrimalAPI.Items.OBSIDIAN_PLATE)).setRecipeName("obsidian_shard"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.OBSIDIAN_PLATE)), charcoal_end, new ItemStack(PrimalAPI.Items.OBSIDIAN_LENS)).setRecipeName("obsidian_plate"));
        recipes.register(((SmelterRecipe)new SmelterRecipe(8, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.OBSIDIAN_SHARD, 4)), charcoal_mix, new ItemStack(Blocks.field_150343_Z)).setRecipeName("obsidian_block")).setHidden(true));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, RecipeHelper.buildList(new ItemStack(Blocks.field_150343_Z)), charcoal_end, new ItemStack(PrimalAPI.Blocks.OBSIDIAN_TRANSPARENT, 1, ObsidianGlass.EnumType.NORMAL.getMetadata())).setRecipeName("obsidian_glass"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(6, RecipeHelper.buildList(new ItemStack(PrimalAPI.Blocks.OBSIDIAN_TRANSPARENT, 1, ObsidianGlass.EnumType.NORMAL.getMetadata())), charcoal_end, new ItemStack(PrimalAPI.Blocks.OBSIDIAN_TRANSPARENT, 1, ObsidianGlass.EnumType.SMOOTH.getMetadata())).setRecipeName("obsidian_glass_smooth"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(4, RecipeHelper.buildList(new ItemStack(PrimalAPI.Blocks.NETHER_EARTH, 1, ITypeBrick.EnumType.NORMAL.getMetadata())), RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.SALT_DUST_FIRE, 4)), RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.MUCK_MOLTEN, 1)), new ItemStack(PrimalAPI.Blocks.NETHER_GROWTH)).setRecipeName("nether_growth"));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)((SmelterRecipe)new SmelterRecipe(6, RecipeHelper.getOreStack("gemQuartzVitrified", 2, new ItemStack[0]), RecipeHelper.getOreStack(1, "charcoalPure"), RecipeHelper.getOreStack(4, "specialCarbon"), new ItemStack(PrimalAPI.Items.QUARTZ_VITRIFIED_LENS, 1)).setRecipeName("vitrified_quartz")).setHidden(false)).setSlag(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(24, RecipeHelper.getOreStack("foodBoiledegg", 1, new ItemStack[0]), RecipeHelper.getOreStack("foodSalt", 2, new ItemStack[0]), RecipeHelper.getOreStack(2, "specialCarbon"), new ItemStack(PrimalAPI.Items.EGG_DEATH)).setRecipeName("eggs")).setPassive(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(16, RecipeHelper.buildList(new ItemStack((Block)Blocks.field_150362_t, 4, BlockPlanks.EnumType.JUNGLE.func_176839_a())), new ItemStack(PrimalAPI.Items.FERMENTED_JUNGLE)).setRecipeName("fermented_jungle")).setPassive(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(6, RecipeHelper.getOreStack("blockGlass", 1, new ItemStack(PrimalAPI.Blocks.SOUL_GLASS), new ItemStack(PrimalAPI.Blocks.IRON_GLASS)), RecipeHelper.buildList(new ItemStack(Items.field_151156_bN)), new ItemStack(PrimalAPI.Blocks.SOUL_GLASS)).setRecipeName("soul_glass_conversion")).setPassive(true).setCatalyst(new ItemStack(Items.field_151156_bN)));
        List<ItemStack> carbon_x1 = RecipeHelper.getOreStack(1, "specialCarbon");
        List<ItemStack> carbon_x2 = RecipeHelper.getOreStack(2, "specialCarbon");
        List<ItemStack> flux_good_x2 = RecipeHelper.getOreStack(2, "slackLime", "slackGlass");
        List<ItemStack> flux_poor = RecipeHelper.getOreStack(1, "sand");
        ItemStack slag_extra = new ItemStack(PrimalAPI.Items.SLAG, 1);
        List<ItemStack> cluster_bog_iron = RecipeHelper.getOreStack("oreClusterBogIron", 2, new ItemStack[0]);
        List<ItemStack> cluster_magnetite = RecipeHelper.getOreStack("oreClusterMagnetite", 2, new ItemStack[0]);
        List<ItemStack> cluster_zinc = RecipeHelper.getOreStack("oreClusterZinc", 2, new ItemStack[0]);
        List<ItemStack> dust_copper = RecipeHelper.getOreStack("dustCopper", 1, new ItemStack[0]);
        List<ItemStack> dust_tin = RecipeHelper.getOreStack("dustTin", 1, new ItemStack[0]);
        List<ItemStack> dust_gold = RecipeHelper.getOreStack("dustGold", 1, new ItemStack[0]);
        List<ItemStack> dust_silver = RecipeHelper.getOreStack("dustSilver", 1, new ItemStack[0]);
        List<ItemStack> dust_nickel = RecipeHelper.getOreStack("dustNickel", 1, new ItemStack[0]);
        List<ItemStack> three_motes = RecipeHelper.getOreStack("charcoalMote", 3, new ItemStack[0]);
        ItemStack constantan_ingot = RecipeHelper.getFirstDictionaryMatch("ingotConstantan", 2);
        ItemStack electrum_ingot = RecipeHelper.getFirstDictionaryMatch("ingotElectrum", 2);
        ItemStack electrum_nugget = RecipeHelper.getFirstDictionaryMatch("nuggetElectrum", 3);
        ItemStack constantan_nugget = RecipeHelper.getFirstDictionaryMatch("nuggetConstantan", 3);
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(18, cluster_bog_iron, charcoal_fair, RecipeHelper.getOreStack("sand", 1, new ItemStack[0]), new ItemStack(PrimalAPI.Items.CRUDE_IRON_NUGGET, 8), new ItemStack(Items.field_191525_da, 2), new ItemStack(PrimalAPI.Items.SLAG, 1)).setRecipeName("bog_iron_sand_fair")).setSlag(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(16, cluster_bog_iron, charcoal_good, flux_poor, new ItemStack(PrimalAPI.Items.CRUDE_IRON_NUGGET, 8), new ItemStack(Items.field_191525_da, 4), new ItemStack(PrimalAPI.Items.SLAG, 1)).setRecipeName("bog_iron_sand_good")).setSlag(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(16, cluster_bog_iron, charcoal_high, flux_poor, new ItemStack(PrimalAPI.Items.CRUDE_IRON_NUGGET, 6), new ItemStack(Items.field_191525_da, 6)).setRecipeName("bog_iron_sand_high")).setSlag(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(14, cluster_bog_iron, charcoal_fair, flux_good_x2, new ItemStack(PrimalAPI.Items.CRUDE_IRON_INGOT), new ItemStack(PrimalAPI.Items.CRUDE_IRON_NUGGET, 2), new ItemStack(Items.field_191525_da, 2)).setRecipeName("bog_iron_lime_fair")).setSlag(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(12, cluster_bog_iron, charcoal_good, flux_good_x2, new ItemStack(PrimalAPI.Items.CRUDE_IRON_INGOT), new ItemStack(Items.field_191525_da, 4)).setRecipeName("bog_iron_lime_good")).setSlag(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(12, cluster_bog_iron, charcoal_high, flux_good_x2, new ItemStack(PrimalAPI.Items.CRUDE_IRON_INGOT), new ItemStack(Items.field_191525_da, 6)).setRecipeName("bog_iron_lime_high")).setSlag(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(12, cluster_zinc, charcoal_good, flux_good_x2, new ItemStack(PrimalAPI.Items.ZINC_INGOT), new ItemStack(PrimalAPI.Items.ZINC_NUGGET, 4)).setRecipeName("zinc_lime_good")).setSlag(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(12, cluster_zinc, charcoal_high, flux_good_x2, new ItemStack(PrimalAPI.Items.ZINC_INGOT), new ItemStack(PrimalAPI.Items.ZINC_NUGGET, 6)).setRecipeName("zinc_lime_high")).setSlag(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(16, cluster_magnetite, charcoal_high_x2, carbon_x1, flux_good_x2, new ItemStack(PrimalAPI.Items.WOOTZ_INGOT), new ItemStack(PrimalAPI.Items.STEEL_NUGGET, 4), new ItemStack(Items.field_191525_da, 3)).setRecipeName("magnetite_ore")).setSlag(true));
        recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(16, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.CRUDE_IRON_INGOT)), charcoal_good, flux_good_x2, new ItemStack(Items.field_151042_j)).setRecipeName("iron")).setSlag(true));
        int ore_time = 13;
        boolean ore_output_amount = true;
        int ore_extra_amount = 3;
        for (String ore : ores = new String[]{"Gold", "Iron", "Copper", "Tin", "Silver", "Lead", "Aluminum", "Nickel", "Platinum", "Zinc", "Osmium", "Uranium", "Yellorium", "Thorium", "Boron", "Lithium", "Magnesium", "Constantan", "Electrum", "Steel", "Bronze", "Brass", "Thaumium", "Void"}) {
            List<ItemStack> plate_input;
            List<ItemStack> dust_input;
            ItemStack ore_output = RecipeHelper.getFirstDictionaryMatch("ingot" + ore, 1);
            List<ItemStack> ore_input = RecipeHelper.getOreStack("ore" + ore, 1, new ItemStack[0]);
            if (!ore_input.isEmpty() && !ore_output.func_190926_b()) {
                recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, ore_input, charcoal_end, flux_good_x2, ore_output, RecipeHelper.getFirstDictionaryMatch("nugget" + ore, 3)).setRecipeName("ore_good_" + ore)).setSlag(true));
                recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, ore_input, charcoal_fair, flux_good_x2, ore_output).setRecipeName("ore_fair_" + ore)).setSlag(true));
                recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, ore_input, charcoal_mix, flux_poor, RecipeHelper.getFirstDictionaryMatch("nugget" + ore, 7), slag_extra).setRecipeName("ore_sand_" + ore)).setSlag(true));
            }
            if (!(dust_input = RecipeHelper.getOreStack("dust" + ore, 1, new ItemStack[0])).isEmpty()) {
                recipes.register((IForgeRegistryEntry)new SmelterRecipe(13, dust_input, three_motes, ore_output).setRecipeName("dust_" + ore));
            }
            if ((plate_input = RecipeHelper.getOreStack("plate" + ore, 1, new ItemStack[0])).isEmpty()) continue;
            recipes.register((IForgeRegistryEntry)new SmelterRecipe(13, plate_input, three_motes, ore_output).setRecipeName("plate_" + ore));
        }
        if (!dust_copper.isEmpty() && !dust_silver.isEmpty()) {
            recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, RecipeHelper.getOreStack(1, "dustSilver", "ingotSilver"), RecipeHelper.getOreStack(3, "dustCopper", "ingotCopper"), RecipeHelper.getOreStack(4, "resinSinuous"), charcoal_high, new ItemStack(PrimalAPI.Items.SHIBUICHI_INGOT, 4), new ItemStack(PrimalAPI.Items.SHIBUICHI_NUGGET, 6)).setRecipeName("alloy_shibuichi")).setSlag(true));
        }
        if (!dust_copper.isEmpty() && !dust_tin.isEmpty()) {
            recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, RecipeHelper.getOreStack(1, "dustTin", "ingotTin"), RecipeHelper.getOreStack(3, "dustCopper", "ingotCopper"), charcoal_high, new ItemStack(PrimalAPI.Items.BRONZE_INGOT, 4), new ItemStack(PrimalAPI.Items.BRONZE_NUGGET, 6)).setRecipeName("alloy_bronze")).setSlag(true));
        }
        if (!dust_copper.isEmpty() && !dust_tin.isEmpty()) {
            recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, RecipeHelper.getOreStack(1, "dustZinc", "ingotZinc"), RecipeHelper.getOreStack(3, "dustCopper", "ingotCopper"), charcoal_high, new ItemStack(PrimalAPI.Items.BRASS_INGOT, 4), new ItemStack(PrimalAPI.Items.BRASS_NUGGET, 6)).setRecipeName("alloy_brass")).setSlag(true));
        }
        if (!(dust_copper.isEmpty() || dust_nickel.isEmpty() || constantan_ingot.func_190926_b() || constantan_nugget.func_190926_b())) {
            recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, RecipeHelper.getOreStack(1, "dustNickel", "ingotNickel"), RecipeHelper.getOreStack(1, "dustCopper", "ingotCopper"), charcoal_high, constantan_ingot, constantan_nugget).setRecipeName("alloy_constantan")).setSlag(true));
        }
        if (!(dust_gold.isEmpty() || dust_silver.isEmpty() || electrum_ingot.func_190926_b())) {
            recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, RecipeHelper.getOreStack(1, "dustGold", "ingotGold"), RecipeHelper.getOreStack(1, "dustSilver", "ingotSilver"), charcoal_high, electrum_ingot, electrum_nugget).setRecipeName("alloy_electrum")).setSlag(true));
        }
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(13, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.ADAMANT_PLATE)), three_motes, new ItemStack(PrimalAPI.Items.ADAMANT_INGOT)).setRecipeName("plate_adamant"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(13, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.SHIBUICHI_PLATE)), three_motes, new ItemStack(PrimalAPI.Items.SHIBUICHI_INGOT)).setRecipeName("plate_shibuichi"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(13, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.TAMAHAGANE_PLATE)), three_motes, new ItemStack(PrimalAPI.Items.TAMAHAGANE_INGOT)).setRecipeName("plate_tamahagane"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(13, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.WOOTZ_PLATE)), three_motes, new ItemStack(PrimalAPI.Items.WOOTZ_INGOT)).setRecipeName("plate_wootz"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(13, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.VANADIUM_PLATE)), three_motes, new ItemStack(PrimalAPI.Items.VANADIUM_INGOT)).setRecipeName("plate_vanadium"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(13, RecipeHelper.buildList(new ItemStack(Items.field_151133_ar)), charcoal_mix, new ItemStack(Items.field_151042_j, 3)).setRecipeName("bucket_to_ingot"));
        recipes.register((IForgeRegistryEntry)new SmelterRecipe(13, RecipeHelper.buildList(new ItemStack(Items.field_151139_aw)), charcoal_mix, new ItemStack(Items.field_151042_j, 2)).setRecipeName("door_to_ingot"));
    }
}

