/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.recipes.inworld;

import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;

@Deprecated
public class FireSource {
    private static ArrayList<FireSource> fireSources = new ArrayList();
    private EnumUseAction actionType;
    private boolean hasDurability;
    private Object input;

    public FireSource(EnumUseAction actionType, boolean hasDurability, Object input) {
        this.actionType = actionType;
        this.hasDurability = hasDurability;
        this.input = input;
    }

    public static void add(EnumUseAction actionType, boolean hasDurability, String ... inputs) {
        for (String input : inputs) {
            if (input.isEmpty()) continue;
            fireSources.add(new FireSource(actionType, hasDurability, input));
        }
    }

    public static void add(EnumUseAction actionType, boolean hasDurability, ItemStack ... inputs) {
        for (ItemStack input : inputs) {
            if (input.func_190926_b()) continue;
            fireSources.add(new FireSource(actionType, hasDurability, input));
        }
    }

    public static void add(EnumUseAction actionType, String ... inputs) {
        FireSource.add(actionType, false, inputs);
    }

    public static void add(EnumUseAction actionType, ItemStack ... inputs) {
        FireSource.add(actionType, false, inputs);
    }

    public static FireSource getSource(ItemStack input) {
        for (FireSource source : fireSources) {
            if (source.input instanceof String && RecipeHelper.isOreName(input, (String)source.input)) {
                return source;
            }
            if (!(source.input instanceof ItemStack) || !input.func_185136_b((ItemStack)source.input)) continue;
            return source;
        }
        return null;
    }

    public static EnumUseAction getActionType(String input) {
        for (FireSource source : fireSources) {
            if (source.input instanceof String && input == source.input) {
                return source.actionType;
            }
            if (!(source.input instanceof ItemStack) || !RecipeHelper.isOreName((ItemStack)source.input, input)) continue;
            return source.actionType;
        }
        return null;
    }

    public static EnumUseAction getActionType(ItemStack input) {
        for (FireSource source : fireSources) {
            if (source.input instanceof String && RecipeHelper.isOreName(input, (String)source.input)) {
                return source.actionType;
            }
            if (!(source.input instanceof ItemStack) || !input.func_77969_a((ItemStack)source.input)) continue;
            return source.actionType;
        }
        return null;
    }

    public static boolean isSource(ItemStack stack) {
        return !stack.func_190926_b() && FireSource.getSource(stack) != null;
    }

    public static boolean useSource(World world, BlockPos pos, EnumFacing face, EntityPlayer player, EnumHand hand, ItemStack stack, float hitX, float hitY, float hitZ) {
        if (stack.func_190926_b()) {
            return false;
        }
        FireSource source = FireSource.getSource(stack);
        if (source != null) {
            switch (source.actionType) {
                case FLINT_STEEL: {
                    world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    return true;
                }
                case FIRE_BOW: {
                    ItemStack stick = PlayerHelper.findItem(player, "stickWood");
                    world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187746_da, SoundCategory.PLAYERS, 0.2f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
                    player.func_184609_a(EnumHand.MAIN_HAND);
                    if (PrimalAPI.randomCheck(ModConfig.Features.FIREBOW_DIFFICULTY)) {
                        FireHelper.makeSmoke(world, pos, 8);
                        PrimalAPI.useStack(player, stick);
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        return true;
                    }
                    if (PrimalAPI.randomCheck(6)) {
                        world.func_184133_a(player, pos, SoundEvents.field_187623_cM, SoundCategory.BLOCKS, 1.0f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
                        PrimalAPI.useStack(player, stick);
                    }
                    return false;
                }
                case BASIC: {
                    world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
                    if (source.hasDurability) {
                        stack.func_77972_a(1, (EntityLivingBase)player);
                    }
                    return true;
                }
            }
            return false;
        }
        if (NBTHelper.hasTag(stack, "hot") && NBTHelper.getFloat(stack, "hot") > 0.0f || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack) > 0) {
            FXHelper.soundFireAmbient(world, pos, 1.0f);
            if (stack.func_77984_f()) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    public static enum EnumUseAction implements IStringSerializable
    {
        FLINT_STEEL("flint_steel"),
        FIRE_BOW("firebow"),
        BASIC("basic"),
        NONE("none");

        private final String name;

        private EnumUseAction(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

