/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.recipes.inworld;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistry;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.helper.checks.MaterialMultiplexer;
import nmd.primal.core.common.recipes.AbstractRecipe;

public class FlakeRecipe
extends AbstractRecipe<FlakeRecipe> {
    public static final String RECIPE_PREFIX = "flake";
    public static final IForgeRegistry<FlakeRecipe> REGISTRY = GameRegistry.findRegistry(FlakeRecipe.class);
    public static final Collection<FlakeRecipe> RECIPES = REGISTRY.getValuesCollection();
    public static final Predicate<IBlockState> MATERIALS = MaterialMultiplexer.forMaterial(Material.field_151576_e, Material.field_151592_s, Material.field_151598_x, Material.field_151573_f, Material.field_151574_g);
    private float block_hardness;
    private float flake_difficulty;
    private float failure_chance;
    private List<ItemStack> input;
    private List<ItemStack> output;
    private boolean is_disabled;
    private boolean is_hidden;

    public FlakeRecipe(float block_hardness, float flake_difficulty, float failure_chance, List<ItemStack> input, ItemStack ... output) {
        this.block_hardness = block_hardness;
        this.flake_difficulty = flake_difficulty;
        this.failure_chance = failure_chance;
        this.input = input;
        this.output = RecipeHelper.buildList(output);
        this.is_disabled = false;
        this.is_hidden = false;
    }

    public FlakeRecipe(float hardness, float difficulty, float failure, ItemStack input, ItemStack ... output) {
        this(hardness, difficulty, failure, new ArrayList<ItemStack>(Collections.singletonList(input)), output);
    }

    public FlakeRecipe(float hardness, float difficulty, float failure, String input, ItemStack ... output) {
        this(hardness, difficulty, failure, RecipeHelper.buildList(new OreIngredient(input).func_193365_a()), output);
    }

    public boolean match(ItemStack stack) {
        if (!stack.func_190926_b() && !this.isDisabled()) {
            for (ItemStack match : this.input) {
                if (!stack.func_185136_b(match)) continue;
                return true;
            }
        }
        return false;
    }

    public float getBlock_hardness() {
        return this.block_hardness;
    }

    public float getFlakeDifficulty() {
        return this.flake_difficulty;
    }

    public float getFailureChance() {
        return this.failure_chance;
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public List<ItemStack> getOutput() {
        return this.output;
    }

    public List<ItemStack> listInputs() {
        return this.getInput();
    }

    public List<ItemStack> listOutputs() {
        return this.getOutput();
    }
}

