/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.recipes.inworld;

import java.util.Collection;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import nmd.primal.core.common.recipes.AbstractRecipe;

public class IceRecipe
extends AbstractRecipe<IceRecipe> {
    public static final String RECIPE_PREFIX = "ice";
    public static final IForgeRegistry<IceRecipe> REGISTRY = GameRegistry.findRegistry(IceRecipe.class);
    public static final Collection<IceRecipe> RECIPES = REGISTRY.getValuesCollection();
    private final Fluid input;
    private final IBlockState output;
    private boolean is_disabled;
    private boolean is_hidden;

    public IceRecipe(Fluid input, IBlockState output) {
        this.input = input;
        this.output = output;
        this.is_disabled = false;
        this.is_hidden = false;
    }

    @Override
    public IceRecipe setDisabled(boolean is_disabled) {
        this.is_disabled = is_disabled;
        return this;
    }

    @Override
    public IceRecipe setHidden(boolean is_hidden) {
        this.is_hidden = is_hidden;
        return this;
    }

    @Override
    public boolean isDisabled() {
        return this.is_disabled;
    }

    @Override
    public boolean isHidden() {
        return this.is_hidden;
    }

    public static IceRecipe getRecipe(IBlockState fluid) {
        for (IceRecipe recipe : RECIPES) {
            if (fluid.func_177230_c() != recipe.input.getBlock()) continue;
            return recipe;
        }
        return null;
    }

    public Fluid getInput() {
        return this.input;
    }

    public IBlockState getOutput() {
        return this.output;
    }
}

