/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.recipes.tile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.recipes.AbstractRecipe;
import nmd.primal.core.common.tiles.machines.TileDryingRack;

public class DryingRecipe
extends AbstractRecipe<DryingRecipe> {
    public static final String RECIPE_PREFIX = "drying_rack";
    public static final IForgeRegistry<DryingRecipe> REGISTRY = GameRegistry.findRegistry(DryingRecipe.class);
    public static final Collection<DryingRecipe> RECIPES = REGISTRY.getValuesCollection();
    private final List<ItemStack> input;
    private final ItemStack output_success;
    private final ItemStack output_failed;
    private final int dry_time;
    private final int rot_chance;

    public DryingRecipe(int dry_time, int rot_chance, List<ItemStack> input, ItemStack output_failed, ItemStack output_success) {
        this.dry_time = dry_time;
        this.rot_chance = rot_chance;
        this.input = input;
        this.output_failed = output_failed;
        this.output_success = output_success;
    }

    public DryingRecipe(int dry_time, int rot_chance, ItemStack input, ItemStack output_failed, ItemStack output_success) {
        this(dry_time, rot_chance, new ArrayList<ItemStack>(Collections.singletonList(input)), output_failed, output_success);
    }

    public DryingRecipe(int dry_time, int rot_chance, String input, ItemStack output_failed, ItemStack output_success) {
        this(dry_time, rot_chance, RecipeHelper.buildList(new OreIngredient(input).func_193365_a()), output_failed, output_success);
    }

    public DryingRecipe(int dry_time, List<ItemStack> input, ItemStack output_success) {
        this(dry_time, 0, input, ItemStack.field_190927_a, output_success);
    }

    public DryingRecipe(int dry_time, ItemStack input, ItemStack output_success) {
        this(dry_time, 0, input, ItemStack.field_190927_a, output_success);
    }

    public DryingRecipe(int dry_time, String input, ItemStack output_success) {
        this(dry_time, 0, RecipeHelper.buildList(new OreIngredient(input).func_193365_a()), ItemStack.field_190927_a, output_success);
    }

    public boolean matches(ItemStack stack) {
        if (!this.isDisabled()) {
            for (ItemStack match : this.getInput()) {
                if (!match.func_77969_a(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matches(TileDryingRack tile) {
        ItemStackHandler handler;
        if (this.isDisabled()) {
            PrimalAPI.logger(22, "drying rack", "recipe is disabled");
            return false;
        }
        if (tile.hasCraftingItems() && (handler = tile.getCraftingHandler()) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!this.matches(handler.getStackInSlot(i))) continue;
                return true;
            }
        }
        return false;
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public List<ItemStack> getOutput() {
        return new ArrayList<ItemStack>(Arrays.asList(this.getOutputSuccess(), this.getOutputFailed()));
    }

    public ItemStack getOutputSuccess() {
        return this.output_success.func_77946_l();
    }

    public ItemStack getOutputFailed() {
        return this.output_failed.func_77946_l();
    }

    public int getDryTime() {
        return this.dry_time;
    }

    public int getRotChance() {
        return this.rot_chance;
    }
}

