/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.recipes.tile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistry;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.helper.RegistryHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.AbstractRecipe;
import nmd.primal.core.common.tiles.machines.TileHibachi;

public class HibachiRecipe
extends AbstractRecipe<HibachiRecipe> {
    public static final String RECIPE_PREFIX = "hibachi";
    public static final IForgeRegistry<HibachiRecipe> REGISTRY = GameRegistry.findRegistry(HibachiRecipe.class);
    public static final Collection<HibachiRecipe> RECIPES = REGISTRY.getValuesCollection();
    public static final List<HibachiRecipe> FURNACE_RECIPES = new ArrayList<HibachiRecipe>();
    private final List<ItemStack> input;
    private final ItemStack output;
    private final int cook_time;

    public HibachiRecipe(int cook_time, List<ItemStack> input, ItemStack output) {
        this.cook_time = cook_time;
        this.input = input;
        this.output = output;
    }

    public HibachiRecipe(int cook_time, ItemStack input, ItemStack output) {
        this(cook_time, RecipeHelper.buildList(input), output);
    }

    public HibachiRecipe(int cook_time, String input, ItemStack output) {
        this(cook_time, RecipeHelper.buildList(new OreIngredient(input).func_193365_a()), output);
    }

    public static List<HibachiRecipe> getFurnaceRecipes() {
        int base_cook_time = Math.max(1, ModConfig.Machines.HIBACHI_BASE_FURNACE_RECIPE_TIME);
        for (Map.Entry map : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            ItemStack input = (ItemStack)map.getKey();
            ItemStack output = (ItemStack)map.getValue();
            if (input.func_190926_b() || output.func_190926_b() || !(output.func_77973_b() instanceof ItemFood) || CommonUtils.matchItemList(ModConfig.Machines.HIBACHI_FURNACE_BLACKLIST, output)) continue;
            int cook_time = base_cook_time + Math.max(0, ((ItemFood)output.func_77973_b()).func_150905_g(output));
            FURNACE_RECIPES.add((HibachiRecipe)new HibachiRecipe(cook_time, input, output).setRecipeName(RegistryHelper.formatRecipeName(input.func_77977_a())));
        }
        return FURNACE_RECIPES;
    }

    public boolean matches(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (ItemStack match : this.getInput()) {
                if (match.func_77969_a(stack)) {
                    return true;
                }
                if (match.func_77952_i() != Short.MAX_VALUE || match.func_77973_b() != stack.func_77973_b()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matches(TileHibachi tile) {
        ItemStackHandler handler;
        if (!this.isDisabled() && tile.hasCraftingItems() && (handler = tile.getCraftingHandler()) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!this.matches(handler.getStackInSlot(i))) continue;
                return true;
            }
        }
        return false;
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public int getCookTime() {
        return this.cook_time;
    }
}

