/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.recipes.tile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import nmd.primal.core.api.interfaces.crafting.ICatalyst;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.helper.StackHelper;
import nmd.primal.core.common.recipes.AbstractRecipe;
import nmd.primal.core.common.tiles.machines.TileSmelter;

public class SmelterRecipe
extends AbstractRecipe<SmelterRecipe>
implements ICatalyst<SmelterRecipe> {
    public static final String RECIPE_PREFIX = "smelter";
    public static final IForgeRegistry<SmelterRecipe> REGISTRY = GameRegistry.findRegistry(SmelterRecipe.class);
    public static final Collection<SmelterRecipe> RECIPES = REGISTRY.getValuesCollection();
    private final List<List<ItemStack>> input = new ArrayList<List<ItemStack>>(4);
    private final List<ItemStack> output = new ArrayList<ItemStack>(4);
    private ItemStack catalyst;
    private final int cook_time;
    private int catalyst_slot;
    private boolean is_passive;
    private boolean has_slag;

    public SmelterRecipe(int cook_time, List<ItemStack> input_slot_1, List<ItemStack> input_slot_2, List<ItemStack> input_slot_3, List<ItemStack> input_slot_4, ItemStack ... outputs) {
        if (input_slot_1 == null || input_slot_1.get(0).func_190926_b()) {
            throw new IllegalArgumentException("[SmelterRecipe] Invalid RecipeAnnotation, must specify at least one input");
        }
        if (outputs == null || outputs.length < 1) {
            throw new IllegalArgumentException("[SmelterRecipe] Invalid RecipeAnnotation, must specify at least one output_items");
        }
        RecipeHelper.addToList(this.output, outputs);
        RecipeHelper.addToList(this.input, input_slot_1, input_slot_2, input_slot_3, input_slot_4);
        this.catalyst_slot = -1;
        this.catalyst = ItemStack.field_190927_a;
        this.cook_time = Math.max(0, cook_time);
    }

    public SmelterRecipe(int cook_time, List<ItemStack> input_slot_1, List<ItemStack> input_slot_2, List<ItemStack> input_slot_3, ItemStack ... output) {
        this(cook_time, input_slot_1, input_slot_2, input_slot_3, (List<ItemStack>)null, output);
    }

    public SmelterRecipe(int cook_time, List<ItemStack> input_slot_1, List<ItemStack> input_slot_2, ItemStack ... output) {
        this(cook_time, input_slot_1, input_slot_2, (List<ItemStack>)null, (List<ItemStack>)null, output);
    }

    public SmelterRecipe(int cook_time, List<ItemStack> input_slot_1, ItemStack ... output) {
        this(cook_time, input_slot_1, (List<ItemStack>)null, (List<ItemStack>)null, (List<ItemStack>)null, output);
    }

    @Override
    public SmelterRecipe setCatalyst(ItemStack catalyst) {
        this.catalyst = catalyst;
        this.catalyst_slot = this.matchCatalystIngredient(this.input);
        return this;
    }

    @Override
    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    @Override
    public int getCatalystSlot() {
        return this.catalyst_slot;
    }

    public List<List<ItemStack>> getInput() {
        return this.input;
    }

    public List<ItemStack> getOutput() {
        return this.output;
    }

    public int getCookTime() {
        return this.cook_time;
    }

    public SmelterRecipe setSlag(boolean slag) {
        this.has_slag = slag;
        return this;
    }

    public boolean hasSlag() {
        return this.has_slag;
    }

    public SmelterRecipe setPassive(boolean passive) {
        this.is_passive = passive;
        return this;
    }

    public boolean isPassive() {
        return this.is_passive;
    }

    public boolean matches(TileSmelter tile) {
        if (this.isDisabled()) {
            return false;
        }
        if (this.hasCatalyst() && !this.isCatalystIngredient() && !tile.hasInput(this.catalyst)) {
            return false;
        }
        int recipe_slot_count = this.getInput().size();
        if (recipe_slot_count > 0 && tile.canStoreOutput(this.getOutput())) {
            List<ItemStack> tile_slots = RecipeHelper.buildList(tile.getInputHandler());
            int match_count = 0;
            block0: for (List<ItemStack> recipe_slots : this.getInput()) {
                for (ItemStack recipe_slot_item : recipe_slots) {
                    for (ItemStack tile_slot_item : tile_slots) {
                        if (!StackHelper.containsStack(tile_slot_item, recipe_slot_item)) continue;
                        ++match_count;
                        tile_slots.remove(tile_slot_item);
                        continue block0;
                    }
                }
            }
            return match_count == recipe_slot_count;
        }
        return false;
    }
}

