/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.tiles;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.tiles.AbstractTileType;

public abstract class AbstractTilePottery
extends AbstractTileType {
    private boolean is_covered = false;

    public boolean isCovered() {
        return this.is_covered;
    }

    public void setCovered(boolean value) {
        this.is_covered = value;
    }

    public abstract ItemStackHandler getStorageHandler();

    public void onAddItem() {
        this.playSoundAdd();
        this.spawnParticles();
    }

    public ItemStack takeItems() {
        int amount;
        int slot;
        ItemStackHandler stackHandler = this.getStorageHandler();
        ItemStack check = stackHandler.getStackInSlot(slot = this.RANDOM.nextInt(stackHandler.getSlots())).func_77946_l();
        int n = amount = !check.func_190926_b() && check.func_190916_E() > 1 ? this.RANDOM.nextInt(1, check.func_190916_E()) : 1;
        if (!check.func_190926_b()) {
            this.playSoundTake();
        }
        return stackHandler.extractItem(slot, amount, false);
    }

    public boolean addItem(ItemStack addStack) {
        if (!addStack.func_190926_b()) {
            ItemStackHandler handler = this.getStorageHandler();
            int size = addStack.func_190916_E();
            if ((addStack = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)addStack.func_77946_l(), (boolean)false)).func_190916_E() < size) {
                this.onAddItem();
                return true;
            }
        }
        return false;
    }

    public boolean addItem(EntityItem entityItem) {
        ItemStack stack = entityItem.func_92059_d().func_77946_l();
        if (this.addItem(stack)) {
            entityItem.func_70106_y();
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean hasItem(ItemStackHandler handler, ItemStack stack) {
        int amount = stack.func_190916_E();
        int count = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stored = handler.getStackInSlot(i);
            if (!stored.func_77969_a(stack)) continue;
            count += stored.func_190916_E();
        }
        PrimalAPI.logger(26, "pottery", "found amount: " + count + ":" + amount);
        return count >= amount;
    }

    @Override
    public NBTTagCompound readNBT(NBTTagCompound nbt) {
        this.setCovered(nbt.func_74767_n("covered"));
        return nbt;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("covered", this.isCovered());
        return nbt;
    }

    public void playSoundAdd() {
        FXHelper.soundPotteryHit(this.field_145850_b, this.field_174879_c, 1.5f);
    }

    public void playSoundCraft() {
        FXHelper.soundSteamHiss(this.field_145850_b, this.field_174879_c, 0.5f);
    }

    public void playSoundTake() {
        FXHelper.soundPotteryLid(this.field_145850_b, this.field_174879_c, 0.5f);
    }

    public void spawnParticles() {
        if (this.field_145850_b instanceof WorldServer) {
            for (int i = 0; i <= this.RANDOM.nextInt(6, 10); ++i) {
                ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.TOWN_AURA, (double)this.field_174879_c.func_177958_n() + this.RANDOM.nextDouble(0.2, 0.6), (double)this.field_174879_c.func_177956_o() + 0.9, (double)this.field_174879_c.func_177952_p() + this.RANDOM.nextDouble(0.2, 0.6), 1, 0.0, 0.0, 0.0, 0.0, new int[]{0});
            }
        }
    }
}

