/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.tiles;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.tiles.AbstractTile;

public abstract class AbstractTileTank
extends AbstractTile {
    protected boolean is_covered = false;

    public boolean isCovered() {
        return this.is_covered;
    }

    public void setCovered(boolean value) {
        this.is_covered = value;
    }

    public abstract String getFluidKey();

    public abstract FluidTank getTank();

    public FluidStack getContainedFluid() {
        return this.getContainedFluid(false);
    }

    public FluidStack getContainedFluid(Boolean makeCopy) {
        FluidStack fluid = this.getTank().getFluid();
        if (fluid == null) {
            return null;
        }
        if (makeCopy.booleanValue()) {
            return fluid.copy();
        }
        return fluid;
    }

    public void fillWithRain() {
        this.getTank().fill(new FluidStack(PrimalAPI.Fluids.RAIN_WATER, 125 + this.RANDOM.nextInt(125)), true);
    }

    public float getFluidHeight() {
        FluidStack stack;
        int capacity = this.getTank().getCapacity();
        if (capacity > 0 && (stack = this.getContainedFluid()) != null) {
            return 6.0f + (float)stack.amount * 9.0f / (float)this.getTank().getCapacity();
        }
        return 0.0f;
    }

    public boolean hasFluid() {
        return this.getTank().getFluidAmount() > 0;
    }

    public boolean hasFluid(int amount) {
        return this.getTank().getFluidAmount() >= amount;
    }

    public boolean hasFluid(FluidStack fluidStack) {
        FluidStack tankStack = this.getContainedFluid(true);
        return tankStack != null && tankStack.isFluidEqual(fluidStack) && tankStack.amount >= fluidStack.amount;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getTank();
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound readNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b(this.getFluidKey(), 10)) {
            this.getTank().readFromNBT(nbt.func_74775_l(this.getFluidKey()));
        } else {
            this.getTank().readFromNBT(nbt);
        }
        this.setCovered(nbt.func_74767_n("covered"));
        return nbt;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        this.getTank().writeToNBT(nbt);
        nbt.func_74757_a("covered", this.isCovered());
        return nbt;
    }
}

